﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bcm-data-exports/BCMDataExports_EXPORTS.h>
#include <aws/bcm-data-exports/model/ExecutionStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BCMDataExports {
namespace Model {

/**
 * <p>The reference for the data export update.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bcm-data-exports-2023-11-26/ExecutionReference">AWS
 * API Reference</a></p>
 */
class ExecutionReference {
 public:
  AWS_BCMDATAEXPORTS_API ExecutionReference() = default;
  AWS_BCMDATAEXPORTS_API ExecutionReference(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMDATAEXPORTS_API ExecutionReference& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMDATAEXPORTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID for this specific execution.</p>
   */
  inline const Aws::String& GetExecutionId() const { return m_executionId; }
  inline bool ExecutionIdHasBeenSet() const { return m_executionIdHasBeenSet; }
  template <typename ExecutionIdT = Aws::String>
  void SetExecutionId(ExecutionIdT&& value) {
    m_executionIdHasBeenSet = true;
    m_executionId = std::forward<ExecutionIdT>(value);
  }
  template <typename ExecutionIdT = Aws::String>
  ExecutionReference& WithExecutionId(ExecutionIdT&& value) {
    SetExecutionId(std::forward<ExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of this specific execution.</p>
   */
  inline const ExecutionStatus& GetExecutionStatus() const { return m_executionStatus; }
  inline bool ExecutionStatusHasBeenSet() const { return m_executionStatusHasBeenSet; }
  template <typename ExecutionStatusT = ExecutionStatus>
  void SetExecutionStatus(ExecutionStatusT&& value) {
    m_executionStatusHasBeenSet = true;
    m_executionStatus = std::forward<ExecutionStatusT>(value);
  }
  template <typename ExecutionStatusT = ExecutionStatus>
  ExecutionReference& WithExecutionStatus(ExecutionStatusT&& value) {
    SetExecutionStatus(std::forward<ExecutionStatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_executionId;

  ExecutionStatus m_executionStatus;
  bool m_executionIdHasBeenSet = false;
  bool m_executionStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace BCMDataExports
}  // namespace Aws
