﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>

namespace Aws {
namespace VPCLattice {
namespace Model {
enum class ServiceNetworkVpcAssociationStatus {
  NOT_SET,
  CREATE_IN_PROGRESS,
  ACTIVE,
  UPDATE_IN_PROGRESS,
  DELETE_IN_PROGRESS,
  CREATE_FAILED,
  DELETE_FAILED,
  UPDATE_FAILED
};

namespace ServiceNetworkVpcAssociationStatusMapper {
AWS_VPCLATTICE_API ServiceNetworkVpcAssociationStatus GetServiceNetworkVpcAssociationStatusForName(const Aws::String& name);

AWS_VPCLATTICE_API Aws::String GetNameForServiceNetworkVpcAssociationStatus(ServiceNetworkVpcAssociationStatus value);
}  // namespace ServiceNetworkVpcAssociationStatusMapper
}  // namespace Model
}  // namespace VPCLattice
}  // namespace Aws
