/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.COSUnread;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdmodel.ConformingPDDocument;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.XrefEntry;
import org.apache.pdfbox.persistence.util.COSObjectKey;

public class ConformingPDFParser
extends BaseParser {
    protected RandomAccess inputFile;
    List<XrefEntry> xrefEntries;
    private long currentOffset;
    private ConformingPDDocument doc = null;
    private boolean throwNonConformingException = true;
    private boolean recursivlyRead = true;

    public ConformingPDFParser(File inputFile) throws IOException {
        this.inputFile = new RandomAccessFile(inputFile, "r");
    }

    public void parse() throws IOException {
        long xRefTableLocation;
        this.document = new COSDocument();
        this.doc = new ConformingPDDocument(this.document);
        this.currentOffset = this.inputFile.length() - 1L;
        this.currentOffset = xRefTableLocation = this.parseTrailerInformation();
        this.parseXrefTable();
        boolean oldValue = this.recursivlyRead;
        this.recursivlyRead = false;
        List<COSObjectKey> keys = this.doc.getObjectKeysFromPool();
        for (COSObjectKey key : keys) {
            this.getObject(key.getNumber(), key.getGeneration());
        }
        this.recursivlyRead = oldValue;
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return this.doc;
    }

    private boolean parseXrefTable() throws IOException {
        String currentLine = this.readLine();
        if (this.throwNonConformingException && !"xref".equals(currentLine)) {
            throw new AssertionError((Object)("xref table not found.\nExpected: xref\nFound: " + currentLine));
        }
        int objectNumber = this.readInt();
        int entries = this.readInt();
        this.xrefEntries = new ArrayList<XrefEntry>(entries);
        for (int i = 0; i < entries; ++i) {
            this.xrefEntries.add(new XrefEntry(objectNumber++, this.readInt(), this.readInt(), this.readLine()));
        }
        return true;
    }

    protected long parseTrailerInformation() throws IOException, NumberFormatException {
        long xrefLocation = -1L;
        this.consumeWhitespaceBackwards();
        String currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"%%EOF".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid EOF marker.\nExpected: %%EOF\nFound: " + currentLine));
        }
        xrefLocation = this.readLongBackwards();
        currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"startxref".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid trailer.\nExpected: startxref\nFound: " + currentLine));
        }
        this.document.setTrailer(this.readDictionaryBackwards());
        this.consumeWhitespaceBackwards();
        currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"trailer".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid trailer.\nExpected: trailer\nFound: " + currentLine));
        }
        return xrefLocation;
    }

    protected byte readByteBackwards() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        --this.currentOffset;
        return singleByte;
    }

    protected byte readByte() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        ++this.currentOffset;
        return singleByte;
    }

    protected String readBackwardUntilWhitespace() throws IOException {
        StringBuilder sb = new StringBuilder();
        byte singleByte = this.readByteBackwards();
        while (!this.isWhitespace(singleByte)) {
            sb.insert(0, (char)singleByte);
            singleByte = this.readByteBackwards();
        }
        return sb.toString();
    }

    protected byte consumeWhitespaceBackwards() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        if (!this.isWhitespace(singleByte)) {
            return singleByte;
        }
        while (this.isWhitespace(singleByte)) {
            singleByte = this.readByteBackwards();
        }
        ++this.currentOffset;
        return singleByte;
    }

    protected byte consumeWhitespace() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        if (!this.isWhitespace(singleByte)) {
            return singleByte;
        }
        while (this.isWhitespace(singleByte)) {
            singleByte = this.readByte();
        }
        --this.currentOffset;
        return singleByte;
    }

    protected long readLongBackwards() throws IOException, NumberFormatException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespaceBackwards();
        byte singleByte = this.readByteBackwards();
        while (!this.isWhitespace(singleByte)) {
            sb.insert(0, (char)singleByte);
            singleByte = this.readByteBackwards();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return Long.parseLong(sb.toString());
    }

    @Override
    protected int readInt() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespace();
        byte singleByte = this.readByte();
        while (!this.isWhitespace(singleByte)) {
            sb.append((char)singleByte);
            singleByte = this.readByte();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return Integer.parseInt(sb.toString());
    }

    protected COSNumber readNumber() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespace();
        byte singleByte = this.readByte();
        while (!this.isWhitespace(singleByte)) {
            sb.append((char)singleByte);
            singleByte = this.readByte();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return this.parseNumber(sb.toString());
    }

    protected COSNumber parseNumber(String number) throws IOException {
        if (number.matches("^[0-9]+$")) {
            return COSInteger.get(number);
        }
        return new COSFloat(Float.parseFloat(number));
    }

    protected COSBase processCosObject(String string) throws IOException {
        if (string != null && string.endsWith(">")) {
            return COSString.createFromHexString(string.replaceAll("^<", "").replaceAll(">$", ""));
        }
        return null;
    }

    protected COSBase readObjectBackwards() throws IOException {
        COSBase obj = null;
        this.consumeWhitespaceBackwards();
        String lastSection = this.readBackwardUntilWhitespace();
        if ("R".equals(lastSection)) {
            long gen = this.readLongBackwards();
            long number = this.readLongBackwards();
            this.doc.putObjectInPool(new COSUnread(), number, gen);
            obj = new COSUnread(number, gen, this);
        } else {
            if (">>".equals(lastSection)) {
                throw new RuntimeException("Not yet implemented");
            }
            if (lastSection != null && lastSection.endsWith("]")) {
                COSArray array = new COSArray();
                lastSection = lastSection.replaceAll("]$", "");
                while (!lastSection.startsWith("[")) {
                    if (lastSection.matches("^\\s*<.*>\\s*$")) {
                        array.add(COSString.createFromHexString(lastSection.replaceAll("^\\s*<", "").replaceAll(">\\s*$", "")));
                    }
                    lastSection = this.readBackwardUntilWhitespace();
                }
                if ((lastSection = lastSection.replaceAll("^\\[", "")).matches("^\\s*<.*>\\s*$")) {
                    array.add(COSString.createFromHexString(lastSection.replaceAll("^\\s*<", "").replaceAll(">\\s*$", "")));
                }
                obj = array;
            } else if (lastSection != null && lastSection.endsWith(">")) {
                obj = this.processCosObject(lastSection);
            } else {
                try {
                    Long.parseLong(lastSection);
                    obj = COSNumber.get(lastSection);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Not yet implemented");
                }
            }
        }
        return obj;
    }

    protected COSName readNameBackwards() throws IOException {
        String name = this.readBackwardUntilWhitespace();
        name = name.replaceAll("^/", "");
        return COSName.getPDFName(name);
    }

    public COSBase getObject(long objectNumber, long generation) throws IOException {
        XrefEntry entry = this.xrefEntries.get((int)objectNumber);
        this.currentOffset = entry.getByteOffset();
        return this.readObject(objectNumber, generation);
    }

    public COSBase readObject(long objectNumber, long generation) throws IOException {
        COSBase obj;
        if (this.document != null && this.recursivlyRead && (obj = this.doc.getObjectFromPool(objectNumber, generation)) != null) {
            return obj;
        }
        int actualObjectNumber = this.readInt();
        if (objectNumber != (long)actualObjectNumber && this.throwNonConformingException) {
            throw new AssertionError((Object)("Object numer expected was " + objectNumber + " but actual was " + actualObjectNumber));
        }
        this.consumeWhitespace();
        int actualGeneration = this.readInt();
        if (generation != (long)actualGeneration && this.throwNonConformingException) {
            throw new AssertionError((Object)("Generation expected was " + generation + " but actual was " + actualGeneration));
        }
        this.consumeWhitespace();
        String obj2 = this.readWord();
        if (!"obj".equals(obj2) && this.throwNonConformingException) {
            throw new AssertionError((Object)("Expected keyword 'obj' but found " + obj2));
        }
        this.doc.putObjectInPool(new COSObject(null), objectNumber, generation);
        COSBase object = this.readObject();
        this.doc.putObjectInPool(object, objectNumber, generation);
        return object;
    }

    protected COSBase readObject() throws IOException {
        this.consumeWhitespace();
        String string = this.readWord();
        if (string.startsWith("<<")) {
            COSDictionary dictionary = new COSDictionary();
            boolean atEndOfDictionary = false;
            if ("".equals(string = string.replaceAll("^<<", "")) || string.matches("^\\w$")) {
                string = this.readWord().trim();
            }
            while (!atEndOfDictionary) {
                COSName name = COSName.getPDFName(string);
                COSBase object = this.readObject();
                dictionary.setItem(name, object);
                byte singleByte = this.consumeWhitespace();
                if (singleByte == 62) {
                    this.readByte();
                    atEndOfDictionary = true;
                }
                if (atEndOfDictionary) continue;
                string = this.readWord().trim();
            }
            return dictionary;
        }
        if (string.startsWith("/")) {
            COSName name = COSName.getPDFName(string);
            return name;
        }
        if (string.startsWith("-")) {
            return this.parseNumber(string);
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            long tempOffset = this.currentOffset;
            this.consumeWhitespace();
            String tempString = this.readWord();
            if (tempString.matches("^[0-9]+$")) {
                tempString = this.readWord();
                if (!"R".equals(tempString)) {
                    this.currentOffset = tempOffset;
                    return this.parseNumber(string);
                }
            } else {
                this.currentOffset = tempOffset;
                return this.parseNumber(string);
            }
            this.currentOffset = tempOffset;
            int number = Integer.parseInt(string);
            int gen = this.readInt();
            String r = this.readWord();
            if (!"R".equals(r) && this.throwNonConformingException) {
                throw new AssertionError((Object)("Expected keyword 'R' but found " + r));
            }
            if (this.recursivlyRead) {
                long tempLocation = this.currentOffset;
                this.currentOffset = this.xrefEntries.get(number).getByteOffset();
                COSBase returnValue = this.readObject(number, gen);
                this.currentOffset = tempLocation;
                return returnValue;
            }
            COSObject obj = new COSObject(new COSUnread());
            obj.setObjectNumber(COSInteger.get(number));
            obj.setGenerationNumber(COSInteger.get(gen));
            return obj;
        }
        if (string.startsWith("]")) {
            if ("]".equals(string)) {
                return null;
            }
            int oldLength = string.length();
            this.currentOffset -= (long)oldLength;
            return null;
        }
        if (string.startsWith("[")) {
            int oldLength = string.length();
            string = "[";
            this.currentOffset -= (long)(oldLength - string.length() + 1);
            COSArray array = new COSArray();
            COSBase object = this.readObject();
            while (object != null) {
                array.add(object);
                object = this.readObject();
            }
            return array;
        }
        if (string.startsWith("(")) {
            StringBuilder sb = new StringBuilder(string.substring(1));
            byte singleByte = this.readByte();
            while (singleByte != 41) {
                sb.append((char)singleByte);
                singleByte = this.readByte();
            }
            return new COSString(sb.toString());
        }
        throw new RuntimeException("Not yet implemented: " + string + " loation=" + this.currentOffset);
    }

    @Override
    protected String readString() throws IOException {
        this.consumeWhitespace();
        StringBuilder buffer = new StringBuilder();
        int c = this.pdfSource.read();
        while (!this.isEndOfName((char)c) && !this.isClosing(c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected COSDictionary readDictionaryBackwards() throws IOException {
        COSDictionary dict = new COSDictionary();
        this.consumeWhitespaceBackwards();
        byte singleByte = this.readByteBackwards();
        if (this.throwNonConformingException && singleByte != 62) {
            throw new AssertionError((Object)"");
        }
        singleByte = this.readByteBackwards();
        if (this.throwNonConformingException && singleByte != 62) {
            throw new AssertionError((Object)"");
        }
        boolean atEndOfDictionary = false;
        singleByte = this.consumeWhitespaceBackwards();
        if (singleByte == 60) {
            this.inputFile.seek(this.currentOffset - 1L);
            atEndOfDictionary = (byte)this.inputFile.read() == 60;
        }
        COSDictionary backwardsDictionary = new COSDictionary();
        while (!atEndOfDictionary) {
            COSBase object = this.readObjectBackwards();
            COSName name = this.readNameBackwards();
            backwardsDictionary.setItem(name, object);
            singleByte = this.consumeWhitespaceBackwards();
            if (singleByte != 60) continue;
            this.inputFile.seek(this.currentOffset - 1L);
            atEndOfDictionary = (byte)this.inputFile.read() == 60;
        }
        Set<COSName> backwardsKeys = backwardsDictionary.keySet();
        for (int i = backwardsKeys.size() - 1; i >= 0; --i) {
            dict.setItem((COSName)backwardsKeys.toArray()[i], backwardsDictionary.getItem((COSName)backwardsKeys.toArray()[i]));
        }
        this.readByteBackwards();
        this.readByteBackwards();
        return dict;
    }

    protected String readLineBackwards() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean endOfObject = false;
        do {
            byte singleByte;
            if ((singleByte = this.readByteBackwards()) == 10) {
                this.inputFile.seek(this.currentOffset);
                if ((byte)this.inputFile.read() == 13) {
                    --this.currentOffset;
                }
                endOfObject = true;
                continue;
            }
            if (singleByte == 13) {
                endOfObject = true;
                continue;
            }
            sb.insert(0, (char)singleByte);
        } while (!endOfObject);
        return sb.toString();
    }

    @Override
    protected String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean endOfLine = false;
        do {
            byte singleByte;
            if ((singleByte = this.readByte()) == 10) {
                this.inputFile.seek(this.currentOffset);
                if ((byte)this.inputFile.read() == 13) {
                    ++this.currentOffset;
                }
                endOfLine = true;
                continue;
            }
            if (singleByte == 13) {
                endOfLine = true;
                continue;
            }
            sb.append((char)singleByte);
        } while (!endOfLine);
        return sb.toString();
    }

    protected String readWord() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean stop = true;
        do {
            byte singleByte;
            if (!(stop = this.isWhitespace(singleByte = this.readByte())) && sb.length() > 0) {
                boolean bl = stop = singleByte == 47 || singleByte == 91 || singleByte == 93 || singleByte == 62 && !">".equals(sb.toString());
                if (stop) {
                    --this.currentOffset;
                }
            }
            if (stop) continue;
            sb.append((char)singleByte);
        } while (!stop);
        return sb.toString();
    }

    public boolean isRecursivlyRead() {
        return this.recursivlyRead;
    }

    public void setRecursivlyRead(boolean recursivlyRead) {
        this.recursivlyRead = recursivlyRead;
    }
}

