/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.coode.mdock.ComponentFactory;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.HorizontalSplitterNode;
import org.coode.mdock.Node;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.VerticalSplitterNode;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NodeReanimator
extends DefaultHandler {
    private ComponentFactory componentFactory;
    private Stack<NodeElement> elementStack;
    private ComponentElement currentComponentElement;
    private SplitterNode rootNode;

    public NodeReanimator(Reader is, ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.elementStack = new Stack();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(is), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SplitterNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("CNode")) {
            ComponentNodeElement element = new ComponentNodeElement();
            this.elementStack.push(element);
        } else if (qName.equals("HSNode")) {
            HorizontalSplitterElement element = new HorizontalSplitterElement(NodeReanimator.getSplits(attributes));
            this.elementStack.push(element);
        } else if (qName.equals("VSNode")) {
            VerticalSplitterElement element = new VerticalSplitterElement(NodeReanimator.getSplits(attributes));
            this.elementStack.push(element);
        } else if (qName.equals("Component")) {
            this.currentComponentElement = new ComponentElement(attributes.getValue("label"));
        } else if (qName.equals("Property")) {
            this.currentComponentElement.putProperty(attributes.getValue("id"), attributes.getValue("value"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("CNode")) {
            NodeElement element = this.elementStack.pop();
            this.elementStack.peek().addChildNodeElement(element);
        } else if (qName.equals("HSNode")) {
            NodeElement element = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.rootNode = (SplitterNode)element.createNode();
            } else {
                this.elementStack.peek().addChildNodeElement(element);
            }
        } else if (qName.equals("VSNode")) {
            NodeElement element = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.rootNode = (SplitterNode)element.createNode();
            } else {
                this.elementStack.peek().addChildNodeElement(element);
            }
        } else if (qName.equals("Component")) {
            ComponentNodeElement element = (ComponentNodeElement)this.elementStack.peek();
            element.addComponentElement(this.currentComponentElement);
        }
    }

    private static List<Double> getSplits(Attributes attributes) {
        String splits = attributes.getValue("splits");
        if (splits != null) {
            return NodeReanimator.parseSplits(splits);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Double> parseSplits(String splits) {
        ArrayList<Double> list = new ArrayList<Double>();
        StringTokenizer tokenizer = new StringTokenizer(splits.trim(), " ");
        while (tokenizer.hasMoreTokens()) {
            String curTok = tokenizer.nextToken();
            list.add(Double.parseDouble(curTok));
        }
        return list;
    }

    private class ComponentElement {
        private String label;
        private Map<String, String> properties;

        public ComponentElement(String label) {
            this.label = label;
            this.properties = new HashMap<String, String>();
        }

        public String getLabel() {
            return this.label;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String id, String val) {
            this.properties.put(id, val);
        }

        public JComponent createComponent() {
            return NodeReanimator.this.componentFactory.createComponent(this.properties);
        }
    }

    private class VerticalSplitterElement
    extends SplitterElement {
        public VerticalSplitterElement(List<Double> splits) {
            super(splits);
        }

        @Override
        public Node createNode() {
            return new VerticalSplitterNode(this.createChildNodes(), this.getSplits());
        }
    }

    private class HorizontalSplitterElement
    extends SplitterElement {
        public HorizontalSplitterElement(List<Double> splits) {
            super(splits);
        }

        @Override
        public Node createNode() {
            return new HorizontalSplitterNode(this.createChildNodes(), this.getSplits());
        }
    }

    private abstract class SplitterElement
    extends NodeElement {
        private List<Double> splits;

        protected SplitterElement(List<Double> splits) {
            this.splits = splits;
        }

        public List<Double> getSplits() {
            return this.splits;
        }
    }

    private class ComponentNodeElement
    extends NodeElement {
        private List<ComponentElement> componentElements;

        public ComponentNodeElement() {
            this.componentElements = new ArrayList<ComponentElement>();
        }

        public void addComponentElement(ComponentElement componentElement) {
            this.componentElements.add(componentElement);
        }

        @Override
        public Node createNode() {
            ComponentNode cn = new ComponentNode();
            for (ComponentElement element : this.componentElements) {
                cn.add(element.createComponent(), element.getLabel());
            }
            return cn;
        }
    }

    private abstract class NodeElement {
        private List<NodeElement> children = new ArrayList<NodeElement>();

        public void addChildNodeElement(NodeElement child) {
            this.children.add(child);
        }

        public abstract Node createNode();

        public List<Node> createChildNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            for (NodeElement element : this.children) {
                childNodes.add(element.createNode());
            }
            return childNodes;
        }
    }
}

