---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token PlanetScale API token'
---

## Description

The response body contains content that matches the pattern of a PlanetScale API service token was identified. Service tokens are created and assigned permissions depending on the allowed scope. A malicious actor with access to the service token is granted the same permissions that were assigned to this service token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a service token:

- Sign in to your PlanetScale account and access <https://app.planetscale.com/>.
- From the menu on the left-hand side, select "Settings"
- Under "Settings", select "Service tokens"
- Find the identified security token and select its name
- Take note of its organization access, permissions and scope
- Select "Delete service token" in the top right corner
- When prompted, select "Delete" in the "Delete service token" dialog

For more information, please see [PlanetScale's documentation on service tokens](https://planetscale.com/docs/concepts/service-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.91 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
