/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import java.lang.invoke.MethodType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.ValueCompiler;
import org.jruby.ir.targets.simple.ConstantLookupSite;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.runtime.callsite.ProfilingCachingCallSite;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;

public class NormalValueCompiler
implements ValueCompiler {
    private final IRBytecodeAdapter compiler;
    private final Map<Object, String> cacheFieldNames = new HashMap<Object, String>();

    public NormalValueCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void pushRuntime() {
        this.compiler.loadContext();
        this.compiler.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
    }

    @Override
    public void pushArrayClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getArray", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushHashClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getHash", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushObjectClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getObject", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushSymbolClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getObject", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushUndefined() {
        this.compiler.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    @Override
    public void pushFixnum(long l) {
        this.cacheValuePermanentlyLoadContext("fixnum", RubyFixnum.class, NormalValueCompiler.keyFor("fixnum", (Object)l), () -> {
            this.pushRuntime();
            this.compiler.adapter.ldc(l);
            this.compiler.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
        });
    }

    @Override
    public void pushFloat(double d) {
        this.cacheValuePermanentlyLoadContext("float", RubyFloat.class, NormalValueCompiler.keyFor("float", (Object)Double.doubleToLongBits(d)), () -> {
            this.pushRuntime();
            this.compiler.adapter.ldc(d);
            this.compiler.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
        });
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.pushRuntime();
        this.pushByteList(bl);
        this.compiler.adapter.ldc(cr);
        this.compiler.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newStringShared", CodegenUtils.sig(RubyString.class, Ruby.class, ByteList.class, Integer.TYPE));
    }

    @Override
    public void pushChilledString(ByteList bl, int cr, String file2, int line) {
        this.pushRuntime();
        this.pushByteList(bl);
        this.compiler.adapter.ldc(cr);
        this.compiler.adapter.ldc(file2);
        this.compiler.adapter.ldc(line);
        this.compiler.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newChilledString", CodegenUtils.sig(RubyString.class, Ruby.class, ByteList.class, Integer.TYPE, String.class, Integer.TYPE));
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr, String file2, int line) {
        this.cacheValuePermanentlyLoadContext("fstring", RubyString.class, NormalValueCompiler.keyFor("fstring", (Object)bl), () -> this.pushFrozenStringUncached(bl, cr, file2, line));
    }

    private void pushFrozenStringUncached(ByteList bl, int cr, String file2, int line) {
        this.compiler.loadContext();
        this.compiler.adapter.ldc(bl.toString());
        this.compiler.adapter.ldc(bl.getEncoding().toString());
        this.compiler.adapter.ldc(cr);
        this.compiler.adapter.ldc(file2);
        this.compiler.adapter.ldc(line);
        this.compiler.invokeIRHelper("newFrozenStringFromRaw", CodegenUtils.sig(RubyString.class, ThreadContext.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE));
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr) {
        this.cacheValuePermanentlyLoadContext("fstring", RubyString.class, NormalValueCompiler.keyFor("fstring", (Object)bl), () -> this.pushFrozenStringUncached(bl, cr));
    }

    private void pushFrozenStringUncached(ByteList bl, int cr) {
        this.compiler.loadContext();
        this.compiler.adapter.ldc(bl.toString());
        this.compiler.adapter.ldc(bl.getEncoding().toString());
        this.compiler.adapter.ldc(cr);
        this.compiler.invokeIRHelper("newFrozenStringFromRaw", CodegenUtils.sig(RubyString.class, ThreadContext.class, String.class, String.class, Integer.TYPE));
    }

    @Override
    public void pushEmptyString(Encoding encoding2) {
        this.pushRuntime();
        this.pushRubyEncoding(encoding2);
        this.compiler.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newEmptyString", CodegenUtils.sig(RubyString.class, Ruby.class, Encoding.class));
    }

    @Override
    public void pushBufferString(Encoding encoding2, int size2) {
        this.pushRuntime();
        this.compiler.adapter.pushInt(size2);
        this.pushEncoding(encoding2);
        this.compiler.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newStringLight", CodegenUtils.sig(RubyString.class, Ruby.class, Integer.TYPE, Encoding.class));
    }

    @Override
    public void buildDynamicString(Encoding encoding2, int size2, boolean frozen, boolean chilled, boolean debugFrozen, String file2, int line, List<ValueCompiler.DStringElement> elements) {
        this.pushBufferString(encoding2, size2);
        for (ValueCompiler.DStringElement elt : elements) {
            switch (elt.type()) {
                case STRING: {
                    StringLiteral str = (StringLiteral)elt.value();
                    this.pushFrozenString(str.getByteList(), str.getCodeRange());
                    this.compiler.adapter.invokevirtual(CodegenUtils.p(RubyString.class), "catWithCodeRange", CodegenUtils.sig(RubyString.class, RubyString.class));
                    break;
                }
                case OTHER: {
                    ((Runnable)elt.value()).run();
                    this.compiler.adapter.invokevirtual(CodegenUtils.p(RubyString.class), "appendAsDynamicString", CodegenUtils.sig(RubyString.class, IRubyObject.class));
                }
            }
        }
        if (frozen) {
            this.compiler.invokeIRHelper("freezeLiteralString", CodegenUtils.sig(RubyString.class, RubyString.class));
        }
        if (chilled) {
            this.compiler.invokeIRHelper("chillLiteralString", CodegenUtils.sig(RubyString.class, RubyString.class));
        }
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.cacheValuePermanentlyLoadContext("bytelist", ByteList.class, NormalValueCompiler.keyFor("bytelist", (Object)bl), () -> {
            this.pushRuntime();
            this.compiler.adapter.ldc(bl.toString());
            this.compiler.adapter.ldc(bl.getEncoding().toString());
            this.compiler.invokeIRHelper("newByteListFromRaw", CodegenUtils.sig(ByteList.class, Ruby.class, String.class, String.class));
        });
    }

    @Override
    public void pushRange(Runnable begin2, Runnable end2, boolean exclusive) {
        this.cacheValuePermanentlyLoadContext("range", RubyRange.class, null, () -> {
            this.compiler.loadContext();
            begin2.run();
            end2.run();
            if (exclusive) {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
            }
        });
    }

    @Override
    public void pushRange(long begin2, long end2, boolean exclusive) {
        this.cacheValuePermanentlyLoadContext("range", RubyRange.class, null, () -> {
            this.compiler.loadContext();
            this.compiler.adapter.ldc(begin2);
            this.compiler.adapter.ldc(end2);
            if (exclusive) {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, Long.TYPE, Long.TYPE));
            } else {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, Long.TYPE, Long.TYPE));
            }
        });
    }

    @Override
    public void pushEndlessRange(long end2, boolean exclusive) {
        this.cacheValuePermanentlyLoadContext("range", RubyRange.class, null, () -> {
            this.compiler.loadContext();
            this.compiler.adapter.ldc(end2);
            this.compiler.adapter.ldc(exclusive);
            this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newEndlessRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, Long.TYPE, Boolean.TYPE));
        });
    }

    @Override
    public void pushBeginlessRange(long begin2, boolean exclusive) {
        this.cacheValuePermanentlyLoadContext("range", RubyRange.class, null, () -> {
            this.compiler.loadContext();
            this.compiler.adapter.ldc(begin2);
            this.compiler.adapter.ldc(exclusive);
            this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newBeginlessRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, Long.TYPE, Boolean.TYPE));
        });
    }

    @Override
    public void pushRange(ByteList begin2, int beginCR, ByteList end2, int endCR, boolean exclusive) {
        this.cacheValuePermanentlyLoadContext("range", RubyRange.class, null, () -> {
            this.compiler.loadContext();
            this.pushFrozenStringUncached(begin2, beginCR);
            this.pushFrozenStringUncached(end2, endCR);
            if (exclusive) {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                this.compiler.adapter.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
            }
        });
    }

    @Override
    public void pushRegexp(ByteList source2, int options2) {
        this.cacheValuePermanentlyLoadContext("regexp", RubyRegexp.class, NormalValueCompiler.keyFor("regexp", source2, options2), () -> {
            this.compiler.loadContext();
            this.pushByteList(source2);
            this.compiler.adapter.pushInt(options2);
            this.compiler.invokeIRHelper("newLiteralRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, ByteList.class, Integer.TYPE));
        });
    }

    @Override
    public void pushSymbol(ByteList bytes2) {
        this.cacheValuePermanentlyLoadContext("symbol", RubySymbol.class, NormalValueCompiler.keyFor("symbol", bytes2, bytes2.getEncoding()), () -> {
            this.pushRuntime();
            this.pushByteList(bytes2);
            this.compiler.adapter.invokestatic(CodegenUtils.p(RubySymbol.class), "newSymbol", CodegenUtils.sig(RubySymbol.class, Ruby.class, ByteList.class));
        });
    }

    @Override
    public void pushSymbolProc(ByteList bytes2) {
        this.cacheValuePermanentlyLoadContext("symbolProc", RubyProc.class, null, () -> {
            this.compiler.loadContext();
            this.pushByteList(bytes2);
            this.compiler.invokeIRHelper("newSymbolProc", CodegenUtils.sig(RubyProc.class, ThreadContext.class, ByteList.class));
        });
    }

    @Override
    public void pushRubyEncoding(Encoding encoding2) {
        this.cacheValuePermanentlyLoadContext("rubyEncoding", RubyEncoding.class, NormalValueCompiler.keyFor("rubyEncoding", (Object)encoding2), () -> {
            this.compiler.loadContext();
            this.compiler.adapter.ldc(encoding2.toString());
            this.compiler.invokeIRHelper("retrieveEncoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class, String.class));
        });
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.cacheValuePermanentlyLoadContext("encoding", Encoding.class, NormalValueCompiler.keyFor("encoding", (Object)encoding2), () -> {
            this.compiler.loadContext();
            this.compiler.adapter.ldc(encoding2.toString());
            this.compiler.invokeIRHelper("retrieveJCodingsEncoding", CodegenUtils.sig(Encoding.class, ThreadContext.class, String.class));
        });
    }

    @Override
    public void pushNil() {
        this.compiler.loadContext();
        this.compiler.adapter.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.pushRuntime();
        this.compiler.adapter.invokevirtual(CodegenUtils.p(Ruby.class), b2 ? "getTrue" : "getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        String bigintStr = bigint.toString();
        this.pushRuntime();
        this.compiler.adapter.ldc(bigintStr);
        this.compiler.adapter.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, Ruby.class, String.class));
    }

    @Override
    public void pushCallSite(String className, String siteName, String scopeFieldName, CallBase call2) {
        String signature;
        Class siteClass;
        CallType callType = call2.getCallType();
        boolean profileCandidate = call2.hasLiteralClosure() && scopeFieldName != null && IRManager.IR_INLINER;
        boolean profiled = false;
        boolean refined = call2.isPotentiallyRefined();
        SkinnyMethodAdapter method2 = this.compiler.adapter;
        method2.getClassVisitor().visitField(10, siteName, CodegenUtils.ci(CachingCallSite.class), null, null).visitEnd();
        method2.getstatic(className, siteName, CodegenUtils.ci(CachingCallSite.class));
        method2.dup();
        Label doCall = new Label();
        method2.ifnonnull(doCall);
        method2.pop();
        method2.ldc(call2.getId());
        if (refined) {
            siteClass = RefinedCachingCallSite.class;
            signature = CodegenUtils.sig(siteClass, String.class, StaticScope.class, String.class);
            method2.getstatic(className, scopeFieldName, CodegenUtils.ci(StaticScope.class));
            method2.ldc(callType.name());
        } else {
            switch (callType) {
                case NORMAL: {
                    if (profileCandidate) {
                        profiled = true;
                        siteClass = ProfilingCachingCallSite.class;
                        break;
                    }
                    siteClass = MonomorphicCallSite.class;
                    break;
                }
                case FUNCTIONAL: {
                    if (profileCandidate) {
                        profiled = true;
                        siteClass = ProfilingCachingCallSite.class;
                        break;
                    }
                    siteClass = FunctionalCachingCallSite.class;
                    break;
                }
                case VARIABLE: {
                    siteClass = VariableCachingCallSite.class;
                    break;
                }
                default: {
                    throw new RuntimeException("BUG: Unexpected call type " + String.valueOf((Object)callType) + " in JVM6 invoke logic");
                }
            }
            if (profiled) {
                method2.getstatic(className, scopeFieldName, CodegenUtils.ci(IRScope.class));
                method2.ldc(call2.getCallSiteId());
                signature = CodegenUtils.sig(CallType.class, siteClass, String.class, IRScope.class, Long.TYPE);
            } else {
                signature = CodegenUtils.sig(siteClass, String.class);
            }
        }
        method2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "new" + siteClass.getSimpleName(), signature);
        method2.dup();
        method2.putstatic(className, siteName, CodegenUtils.ci(CachingCallSite.class));
        method2.label(doCall);
    }

    @Override
    public void pushConstantLookupSite(String className, String siteName, ByteList name2) {
        SkinnyMethodAdapter method2 = this.compiler.adapter;
        method2.getClassVisitor().visitField(10, siteName, CodegenUtils.ci(ConstantLookupSite.class), null, null).visitEnd();
        method2.getstatic(className, siteName, CodegenUtils.ci(ConstantLookupSite.class));
        method2.dup();
        Label doLookup = new Label();
        method2.ifnonnull(doLookup);
        method2.pop();
        method2.newobj(CodegenUtils.p(ConstantLookupSite.class));
        method2.dup();
        this.pushSymbol(name2);
        method2.invokespecial(CodegenUtils.p(ConstantLookupSite.class), "<init>", CodegenUtils.sig(Void.TYPE, RubySymbol.class));
        method2.dup();
        method2.putstatic(className, siteName, CodegenUtils.ci(ConstantLookupSite.class));
        method2.label(doLookup);
    }

    public String cacheValuePermanentlyLoadContext(String what, Class type2, Object key2, Runnable construction) {
        return this.cacheValuePermanently(what, type2, key2, false, MethodType.methodType(type2, ThreadContext.class), this.compiler::loadContext, construction);
    }

    public String cacheValuePermanently(String what, Class type2, Object key2, boolean sync2, Runnable construction) {
        return this.cacheValuePermanently(what, type2, key2, sync2, MethodType.methodType(type2), null, construction);
    }

    public String cacheValuePermanently(String what, Class type2, Object key2, boolean sync2, MethodType signature, Runnable loadState, Runnable construction) {
        String cacheName = key2 == null ? null : this.cacheFieldNames.get(key2);
        String clsName = this.compiler.getClassData().clsName;
        if (cacheName == null) {
            String newCacheName = cacheName = this.newFieldName(what);
            this.cacheFieldNames.put(key2, newCacheName);
            this.compiler.outline(newCacheName, signature, () -> {
                Label done = new Label();
                Label before = sync2 ? new Label() : null;
                Label after = sync2 ? new Label() : null;
                Label catchbody = sync2 ? new Label() : null;
                Label done2 = sync2 ? new Label() : null;
                this.compiler.adapter.getClassVisitor().visitField(10, newCacheName, CodegenUtils.ci(type2), null, null).visitEnd();
                this.compiler.adapter.getstatic(clsName, newCacheName, CodegenUtils.ci(type2));
                this.compiler.adapter.dup();
                this.compiler.adapter.ifnonnull(done);
                this.compiler.adapter.pop();
                Type classType = Type.getType("L" + clsName.replace('.', '/') + ";");
                int tempIndex = Type.getMethodType(CodegenUtils.sig(signature)).getArgumentsAndReturnSizes() >> 3;
                if (sync2) {
                    this.compiler.adapter.ldc(classType);
                    this.compiler.adapter.dup();
                    this.compiler.adapter.astore(tempIndex);
                    this.compiler.adapter.monitorenter();
                    this.compiler.adapter.trycatch(before, after, catchbody, null);
                    this.compiler.adapter.label(before);
                    this.compiler.adapter.getstatic(clsName, newCacheName, CodegenUtils.ci(type2));
                    this.compiler.adapter.dup();
                    this.compiler.adapter.ifnonnull(done2);
                    this.compiler.adapter.pop();
                }
                construction.run();
                this.compiler.adapter.dup();
                this.compiler.adapter.putstatic(clsName, newCacheName, CodegenUtils.ci(type2));
                if (sync2) {
                    this.compiler.adapter.label(done2);
                    this.compiler.adapter.aload(tempIndex);
                    this.compiler.adapter.monitorexit();
                    this.compiler.adapter.go_to(done);
                    this.compiler.adapter.label(after);
                    this.compiler.adapter.label(catchbody);
                    this.compiler.adapter.aload(tempIndex);
                    this.compiler.adapter.monitorexit();
                    this.compiler.adapter.athrow();
                }
                this.compiler.adapter.label(done);
                this.compiler.adapter.areturn();
            });
        }
        if (loadState != null) {
            loadState.run();
        }
        this.compiler.adapter.invokestatic(clsName, cacheName, CodegenUtils.sig(signature));
        return cacheName;
    }

    private String newFieldName(String baseName) {
        return baseName + this.compiler.getClassData().cacheFieldCount.getAndIncrement();
    }

    private static String keyFor(Object obj1, Object obj2) {
        StringBuilder sb = new StringBuilder(16);
        NormalValueCompiler.keyFor(sb, obj1);
        NormalValueCompiler.keyFor(sb, obj2);
        return sb.toString();
    }

    private static String keyFor(Object obj1, Object obj2, Object obj3) {
        StringBuilder sb = new StringBuilder(24);
        NormalValueCompiler.keyFor(sb, obj1);
        NormalValueCompiler.keyFor(sb, obj2);
        NormalValueCompiler.keyFor(sb, obj3);
        return sb.toString();
    }

    private static void keyFor(StringBuilder builder, Object obj) {
        builder.append(obj.toString());
        if (obj instanceof ByteList) {
            builder.append('_').append(((ByteList)obj).getEncoding());
        }
        builder.append('_');
    }

    @Override
    public void pushFixnumArray(List<Long> values2) {
        values2.forEach(obj -> this.pushFixnum((long)obj));
        this.compiler.getDynamicValueCompiler().array(values2.size());
    }

    @Override
    public void pushFloatArray(List<Double> values2) {
        values2.forEach(obj -> this.pushFloat((double)obj));
        this.compiler.getDynamicValueCompiler().array(values2.size());
    }
}

