﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/qapps/QApps_EXPORTS.h>
#include <aws/qapps/model/CardType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QApps {
namespace Model {

/**
 * <p>A card in an Amazon Q App that allows the user to input text.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TextInputCard">AWS
 * API Reference</a></p>
 */
class TextInputCard {
 public:
  AWS_QAPPS_API TextInputCard() = default;
  AWS_QAPPS_API TextInputCard(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API TextInputCard& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the text input card.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  TextInputCard& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The title or label of the text input card.</p>
   */
  inline const Aws::String& GetTitle() const { return m_title; }
  inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }
  template <typename TitleT = Aws::String>
  void SetTitle(TitleT&& value) {
    m_titleHasBeenSet = true;
    m_title = std::forward<TitleT>(value);
  }
  template <typename TitleT = Aws::String>
  TextInputCard& WithTitle(TitleT&& value) {
    SetTitle(std::forward<TitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Any dependencies or requirements for the text input card.</p>
   */
  inline const Aws::Vector<Aws::String>& GetDependencies() const { return m_dependencies; }
  inline bool DependenciesHasBeenSet() const { return m_dependenciesHasBeenSet; }
  template <typename DependenciesT = Aws::Vector<Aws::String>>
  void SetDependencies(DependenciesT&& value) {
    m_dependenciesHasBeenSet = true;
    m_dependencies = std::forward<DependenciesT>(value);
  }
  template <typename DependenciesT = Aws::Vector<Aws::String>>
  TextInputCard& WithDependencies(DependenciesT&& value) {
    SetDependencies(std::forward<DependenciesT>(value));
    return *this;
  }
  template <typename DependenciesT = Aws::String>
  TextInputCard& AddDependencies(DependenciesT&& value) {
    m_dependenciesHasBeenSet = true;
    m_dependencies.emplace_back(std::forward<DependenciesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the card.</p>
   */
  inline CardType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(CardType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline TextInputCard& WithType(CardType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The placeholder text to display in the text input field.</p>
   */
  inline const Aws::String& GetPlaceholder() const { return m_placeholder; }
  inline bool PlaceholderHasBeenSet() const { return m_placeholderHasBeenSet; }
  template <typename PlaceholderT = Aws::String>
  void SetPlaceholder(PlaceholderT&& value) {
    m_placeholderHasBeenSet = true;
    m_placeholder = std::forward<PlaceholderT>(value);
  }
  template <typename PlaceholderT = Aws::String>
  TextInputCard& WithPlaceholder(PlaceholderT&& value) {
    SetPlaceholder(std::forward<PlaceholderT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The default value to pre-populate in the text input field.</p>
   */
  inline const Aws::String& GetDefaultValue() const { return m_defaultValue; }
  inline bool DefaultValueHasBeenSet() const { return m_defaultValueHasBeenSet; }
  template <typename DefaultValueT = Aws::String>
  void SetDefaultValue(DefaultValueT&& value) {
    m_defaultValueHasBeenSet = true;
    m_defaultValue = std::forward<DefaultValueT>(value);
  }
  template <typename DefaultValueT = Aws::String>
  TextInputCard& WithDefaultValue(DefaultValueT&& value) {
    SetDefaultValue(std::forward<DefaultValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_title;

  Aws::Vector<Aws::String> m_dependencies;

  CardType m_type{CardType::NOT_SET};

  Aws::String m_placeholder;

  Aws::String m_defaultValue;
  bool m_idHasBeenSet = false;
  bool m_titleHasBeenSet = false;
  bool m_dependenciesHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_placeholderHasBeenSet = false;
  bool m_defaultValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
