/***********************************************************************************
 *  Copyright 2013 by Akshay Ratan <akshayratan@gmail.com>                         *
 *                                                                                 *
 *                                                                                 *
 *   This library is free software; you can redistribute it and/or                 *
 *   modify it under the terms of the GNU Lesser General Public                    *
 *   License as published by the Free Software Foundation; either                  *
 *   version 2.1 of the License, or (at your option) any later version.            *
 *                                                                                 *
 *   This library is distributed in the hope that it will be useful,               *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
 *   Lesser General Public License for more details.                               *
 *                                                                                 *
 *   You should have received a copy of the GNU Lesser General Public              *
 *   License along with this library.  If not, see <http://www.gnu.org/licenses/>. *
 ***********************************************************************************/

#include "filterlocalfilesmodel.h"
#include "localfilesabstractmodel.h"
#include <KDebug>
#include <mediacenter/mediacenter.h>



FilterLocalFilesModel::FilterLocalFilesModel(QObject* parent)
         : QSortFilterProxyModel(parent)
{
      FilterLocalFilesModel *p = new FilterLocalFilesModel();
      p.setParent(LocalFilesAbstractModel);
}

QString FilterLocalFilesModel::filterString() const
{
    return m_searchString;
}

void FilterLocalFilesModel::setFilterString(const QString& customString)
{
    m_searchString = customString;
    invalidate();
    emit filterStringChanged();
}

bool FilterLocalFilesModel::filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
{
    QModelIndex index = sourceModel()->index(sourceRow, 0 , sourceParent);
    return sourceModel()->data(index).toString().contains(m_searchString, Qt::CaseInsensitive)
        || sourceModel()->data(index, MediaCenter::MediaUrlRole).toString().contains(m_searchString, Qt::CaseInsensitive);
}

/*bool FilterLocalFilesModel::setFilterFixedString ( const QString & pattern , int sourceRow , int sourceColumn , const QModelIndex & source_parent)
{
    QModelIndex index = sourceModel()->index(sourceRow, 0 , source_parent);
    return sourceModel()->data(index).toString().contains(m_searchString, Qt::CaseInsensitive)
        
}*/

void FilterLocalFilesModel::setSourceLocalFilesModel(QObject* model)
{
    QAbstractItemModel *m = qobject_cast<QAbstractItemModel*>(model);
    if (m) {
        setSourceModel(m);
        emit sourceLocalFilesModelChanged();
    }
}

QObject* FilterLocalFilesModel::sourceLocalFilesModel()
{
    return static_cast<QObject*>(sourceModel());
}


