#Terms and Conditions

#Copyright (c) 2002 Jim Bublitz (jbublitz@nwinternet.com)

#Permission is hereby granted, free of charge, to any person obtaining a copy of
#this software and associated documentation files (the "Software"), to deal in
#the Software without restriction, including without limitation the rights to
#use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
#of the Software, and to permit persons to whom the Software is furnished to do
#so, subject to the following conditions:

#The above copyright notice and this permission notice shall be included in all
#copies or substantial portions of the Software.

#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
#COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
#IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
#CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#Except as contained in this notice, the names of the copyright holders shall not
#be used in advertising or otherwise to promote the sale, use or other dealings
#in this Software without prior written authorization from the copyright holders.


import sys, getopt, os, os.path, string

#---------- globals ----------

FALSE      = 0
TRUE       = not FALSE
addApp     = TRUE
addImport  = TRUE
pyuicPath  = "pyuic"
filename   = ''


# --------- support functions ----------

def getOptions ():
        global filename

	arglist = sys.argv [1:]
	shortOptions = "a i p:"
	longOptions  = "noapp noimport pyuic="

	try:
		optlist, args = getopt.getopt (arglist, shortOptions, longOptions)
	except getopt.GetoptError:
		optlist = []
		args    = []

	if len (args) != 1:
		print """\nUsage:

  kdepyuic [options] filename.ui

  Options:
        -a, --noapp     Don't add KApplication code
        -i, --noimport  Don't add kdecore, kdeui import statements
        -p, --pyuic     Path to pyuic program
  """
                sys.exit (-1)

        filename = args [0]
	return checkOptions (optlist)

def checkOptions (optlist):
        global addApp, addImport, pyuicPath

        for pair in optlist:
		if (pair [0] == '--noapp') or (pair [0] == '-a'):
                        addApp = FALSE

		elif (pair [0] == '--noimport') or (pair [0] == '-i'):
                        addImport = FALSE

		elif (pair [0] == '--pyuic') or (pair [0] == '-p'):
                        pyuicPath = pair [1]



# --------- operations ----------

def addimport (f):
        if addApp:
                f.write ('from kdecore import KCmdLineArgs, KApplication\n')

        f.write ('from kdeui import *\n\n')


def addapp (indent, f):
        f.write (indent + 'appname     = ""\n')
        f.write (indent + 'description = ""\n')
        f.write (indent + 'version     = ""\n')
        f.write ('\n')
        f.write (indent + 'KCmdLineArgs.init (sys.argv, appname, description, version)\n')
        f.write (indent + 'a = KApplication ()\n\n')

def doPyuic ():

        fn = os.path.splitext (filename) [0] + '.py'

        if addApp:
                opts = ' -x -o '
        else:
                opts = ' -o '

        if os.system (pyuicPath + opts + fn + ' ' + filename) != 0:
                print pyuicPath + opts + fn + ' ' + filename + " failed"
                sys.exit (-1)

        if addApp or addImport:
                m = open (fn, 'r')
                n = open (fn + '.tmp', 'w')

                buff = m.readlines ()

                for line in buff:
                        if addImport and (string.strip (line) == 'from qt import *'):
                                n.write (line)
                                addimport (n)

                        elif addApp and (string.strip (line) == 'a = QApplication(sys.argv)'):
                                indent = ''
                                i = 0
                                while line [i] in string.whitespace:
                                        indent = indent + line [i]
                                        i      = i + 1
                                addapp (indent, n)
                        else:
                                n.write (line)

                m.close ()
                n.close ()

                os.unlink (fn)
                os.rename (fn + '.tmp', fn)

        print fn + ' written'


# --------- main ----------

getOptions ()
doPyuic ()
