/* This file is part of the KDE libraries
    Copyright (c) 1999 Waldo Bastian <bastian@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <unistd.h>
#include "kuniqueapplication.h"

#include <stdio.h>
#include <kcmdlineargs.h>
#include <k4aboutdata.h>
#include <kdebug.h>

#include <QTimer>
#include <QFile>
#include <QtCore/QProcess>

class TestApp : public KUniqueApplication
{
    Q_OBJECT
public:
    TestApp() : KUniqueApplication("TestApp"), m_callCount(0) { }
    int newInstance() override;
    int callCount() const
    {
        return m_callCount;
    }

private Q_SLOTS:
    void executeNewChild()
    {
        // Duplicated from kglobalsettingstest.cpp - make a shared helper method?
        QProcess *proc = new QProcess(this);
        QString appName = "kuniqueapptest";
#ifdef Q_OS_WIN
        appName = appName + ".exe";
#else
        if (QFile::exists(appName + ".shell")) {
            appName = "./" + appName + ".shell";
        } else {
            Q_ASSERT(QFile::exists(appName));
            appName = "./" + appName;
        }
#endif
        proc->start(appName);
    }
private:
    int m_callCount;
};

int TestApp::newInstance()
{
    ++m_callCount;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    kDebug() << "NewInstance";
    for (int i = 0; i < args->count(); i++) {
        kDebug() << "argument " << i << " : " << args->arg(i);
    }

    if (m_callCount == 2) { // OK, all done, quit
        quit();
    }

    return 0;
}

int main(int argc, char *argv[])
{
    KCmdLineOptions options;
    options.add("!+[argument]", ki18n("arguments passed to new instance"));

    K4AboutData about("kuniqueapptest", nullptr, ki18n("kuniqueapptest"), "version");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();

    if (!TestApp::start()) {
        return 1;
    }
    TestApp a;

    // Testcase for the problem coming from the old fork-on-startup solution:
    // the "newInstance" D-Bus call would time out if the app took too much time
    // to be ready.
    //printf("Sleeping.\n");
    //sleep(200);

    QTimer::singleShot(400, &a, SLOT(executeNewChild()));

    printf("Running.\n");
    kapp->exec();
    printf("Terminating.\n");

    Q_ASSERT(a.callCount() == 2);
    const bool ok = a.callCount() == 2;

    return ok ? 0 : 1;
}

#include "kuniqueapptest.moc"
