/***************************************************************************
 *
 * knetworkmanager-devicestore.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICESTORE_H
#define KNETWORKMANAGER_DEVICESTORE_H

#include <NetworkManager/NetworkManager.h>

#include "knetworkmanager.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-dialup.h"
#include "knetworkmanager-devicestore_dbus.h"

class KNetworkManager;

typedef QValueList<Device*> DeviceList;
typedef QValueList<DialUp*> DialUpList;

typedef struct {
	int wiredDevices;
	int wirelessDevices;
	int wirelessNetworks;
	int dialUpConnections;
} s_status;

struct nl_object;

class DeviceStore : public QObject
{
	Q_OBJECT

	public:
	  DeviceStore  ( QObject * parent = 0, const char * name = 0);
	  ~DeviceStore ();

	  void        removeNetwork         (const QString &, const QString &);
	  void        updateNetworkStrength (const QString &, const QString &, int);
	  void        updateActivationStage (const QString &, NMActStage);
	  Network*    getActiveNetwork      (const Device*);

	  void        addDialUp     (DialUp*);
	  void        removeDialUp  (DialUp*);
	  DialUpList  getDialUpList () const { return _dialUpList; }

	  void        addDevice       (Device*);
	  void        removeDevice    (Device*);
	  void        removeDevice    (QString);
	  Device*     getActiveDevice (void);
	  Device*     getDevice       (Network*);
	  Device*     getDevice       (QString);
	  DeviceList  getDeviceList   (void);

	  s_status*   getStatus               (void);
	  void        invalidateActiveDevices (void);
	  void        commitUpdate            (void);
	  void        clear                   (void);

	  void        push (KNetworkManager*);

	  void emitStrengthChange (Device*);
	  void emitCarrierOn      (Device*);
	  void emitCarrierOff     (Device*);
	  void emitAdded          (Device*);
	  void emitRemoved        (Device*);
	  void emitNoLongerActive (Device*);
	  void emitActive         (Device*);
	  void emitActivating     (Device*);
	  void emitNetworkFound   (Network*);
	  void setStats           (struct rtnl_link*);
	signals:
	  void deviceStoreChanged (DeviceStore*);
	  void strengthChange     (Device*);
	  void carrierOn          (Device*);
	  void carrierOff         (Device*);
	  void added              (Device*);
	  void removed            (Device*);
	  void noLongerActive     (Device*);
	  void active             (Device*);
	  void activating         (Device*);
	  void networkFound       (Network*);
	  void networkDisappeared (Network*);

	public slots:
	  void activateDialUp   (DialUp*);
	  void deactivateDialUp (DialUp*);
	  void activateNetwork  (Network*, Device*);
	  void activateDevice   (Device*);
	  void getInterfaceStat ();

	private:
	  s_status   _status;
	  DialUpList _dialUpList;
	  DeviceList _deviceList;
};

#endif /* KNETWORKMANAGER_DEVICESTORE_H */
