/***************************************************************************
                          legenddlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEGENDDLG_H
#define LEGENDDLG_H

#include <kdialogbase.h>

class QLineEdit;
class KplSpinBox;
class KColorButton;
class LegendItem;
class KplDoc;
class KplDoubleEdit;

/**
  * Legend settings dialog class. Provides a dialog for the settings
  * of a legend describing markers or lines.
  * @author Werner Stille
  */
class LegendDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ld pointer to legend object.
   */
  LegendDlg(QWidget* parent, KplDoc* model, LegendItem* ld);
  /** Destructor. */
  ~LegendDlg();

protected:
  /**
   * Copies settings to legend object.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  LegendItem* ld;
  KplDoubleEdit *ex0, *ey0, *exl, *eyl;
  QLineEdit* eText;
  KplSpinBox *symb, *eRelSize, *eSymbSize;
  KColorButton *colSymb, *colText;

protected slots:
  /** Displays dialog to edit text. */
  void slotEditText();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
