#include "tlform.h"

#include <qwidget.h>
#include <qgrpbox.h>
#include <qlist.h>

#include "typelayout.h"

extern QDict <TLObj> objDict;

TLForm::TLForm(const char *ID,const char *title,QWidget *_widget, QWidget *_parent)
    :TLObj(ID,_widget)
{
    if (!_widget)
    {
        widget=new QWidget(_parent,ID);
    }
    else
        widget=_widget;
    
    widget->setCaption(title);
    align=AlignCenter;
    layout=new KTypeLayout (this);
}

TLForm::~TLForm()
{
    if (!ID.isEmpty())
    {
        objDict.remove(ID.data());
    }
}

TLBook::TLBook(const char *ID,QWidget *_widget=0):TLForm(ID,0,_widget)
{
    widget=_widget;
    align=AlignCenter;
    layout=new KBookLayout (this);
}

TLBook::~TLBook()
{
    if (!ID.isEmpty())
    {
        objDict.remove(ID.data());
    }
}
