BIN= addressbook
SRC=AddressBookAbout.cpp \
	main.cc \
	AddressBookAboutData.cpp \
	businesscard.cc \
	searchresults.cc \
	SearchDialog.cpp \
	datepickerdialog.cc \
	toplevelwidget.cc \
	SearchDialogData.cpp \
	editentry.cc \
	widget.cc \
	addressbook.cc \
	jpeg.cpp \
	widgets.cc 
OBJ= AddressBookAbout.o \
	main.o \
	AddressBookAboutData.o \
	businesscard.o \
	searchresults.o \
	SearchDialog.o \
	datepickerdialog.o \
	toplevelwidget.o \
	SearchDialogData.o \
	editentry.o \
	widget.o \
	addressbook.o \
	jpeg.o \
	widgets.o

#implicit:
%.o:%.cpp
	g++ -c $(CXXFLAGS) $< -o $@

CXXFLAGS+= -O2 -W -Wall \
		-I$(HOME)/Arbeitsverzeichnis/config/alpha/configDB \
		-I/opt/kde/include \
		-I/usr/X11R6/lib/qt/include \
		-DREMOVE_NANA -I..

LDFLAGS+= -L/opt/kde/lib -lqt -lkdecore -lkdeui -lXext -ljpeg -lkfm

all	:	$(BIN)

$(BIN)	:	$(OBJ)
	g++ -o $(BIN) $(LDFLAGS) $(OBJ) \
		$(HOME)/Arbeitsverzeichnis/config/alpha/configDB/libconfigDB.a


addressbook.cc:addressbook.moc
addressbook.moc:addressbook.h
	moc $< -o $@

widgets.cc:widgets.moc
widgets.moc:widgets.h
	moc $< -o $@

widget.cc:widget.moc
widget.moc:widget.h
	moc $< -o $@

toplevelwidget.cc:toplevelwidget.moc
toplevelwidget.moc:toplevelwidget.h
	moc $< -o $@

searchresults.cc:searchresults.moc
searchresults.moc:searchresults.h
	moc $< -o $@

editentry.cc:editentry.moc
editentry.moc:editentry.h
	moc $< -o $@

datepickerdialog.cc:datepickerdialog.moc
datepickerdialog.moc:datepickerdialog.h
	moc $< -o $@

businesscard.cc:businesscard.moc
businesscard.moc:businesscard.h
	moc $< -o $@

SearchDialog.cpp:SearchDialog.moc SearchDialogData.moc
SearchDialog.moc:SearchDialog.h
	moc $< -o $@
SearchDialogData.moc:SearchDialogData.h
	moc $< -o $@

AddressBookAbout.cpp:AddressBookAbout.moc AddressBookAboutData.moc
AddressBookAbout.moc:AddressBookAbout.h
	moc $< -o $@
AddressBookAboutData.moc:AddressBookAboutData.h
	moc $< -o $@

