//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class Meter plasma/widgets/meter.h <Plasma/Widgets/Meter>
    ///  Analog and bar meters are supported.
    ///  Svgs can have following ids:
    ///  - background: Drawn first to the bottom
    ///        background can be a FrameSvg
    ///  - label0, label1, ...: Rectangles mark the label places
    ///  - bar: Bar for the bar meter
    ///       can be replaced with bar-active and bar-inactive FrameSvg
    ///  - pointer: Pointer for analog meter
    ///  - rotatecenter: Marks the place of pointer rotation center
    ///  - rotateminmax: Width and height of this object are the Min and Max rotate
    ///                  angles for the pointer
    ///  - foreground: Is drawn to top
    /// </remarks>        <author> Petri Damstén
    ///  </author>
    ///         <short> Provides generic meter widget for Plasma.</short>
    [SmokeClass("Plasma::Meter")]
    public class Meter : QGraphicsWidget, IDisposable {
        protected Meter(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Meter), this);
        }
        /// <remarks>
        ///  Meter types enum
        ///      </remarks>        <short>    Meter types enum      </short>
        public enum MeterType {
            BarMeterHorizontal = 0,
            BarMeterVertical = 1,
            AnalogMeter = 2,
        }
        [Q_PROPERTY("int", "minimum")]
        public int Minimum {
            get { return (int) interceptor.Invoke("minimum", "minimum()", typeof(int)); }
            set { interceptor.Invoke("setMinimum$", "setMinimum(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("int", "maximum")]
        public int Maximum {
            get { return (int) interceptor.Invoke("maximum", "maximum()", typeof(int)); }
            set { interceptor.Invoke("setMaximum$", "setMaximum(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("int", "value")]
        public int Value {
            get { return (int) interceptor.Invoke("value", "value()", typeof(int)); }
            set { interceptor.Invoke("setValue$", "setValue(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("QString", "svg")]
        public string Svg {
            get { return (string) interceptor.Invoke("svg", "svg()", typeof(string)); }
            set { interceptor.Invoke("setSvg$", "setSvg(QString)", typeof(void), typeof(string), value); }
        }
        [Q_PROPERTY("Plasma::Meter::MeterType", "meterType")]
        public Plasma.Meter.MeterType meterType {
            get { return (Plasma.Meter.MeterType) interceptor.Invoke("meterType", "meterType()", typeof(Plasma.Meter.MeterType)); }
            set { interceptor.Invoke("setMeterType$", "setMeterType(Plasma::Meter::MeterType)", typeof(void), typeof(Plasma.Meter.MeterType), value); }
        }
        /// <remarks>
        ///  Constructor
        /// <param> name="parent" the QGraphicsItem this meter is parented to.
        /// </param><param> name="parent" the QObject this meter is parented to.
        ///      </param></remarks>        <short>    Constructor </short>
        public Meter(IQGraphicsItem parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Meter#", "Meter(QGraphicsItem*)", typeof(void), typeof(IQGraphicsItem), parent);
        }
        public Meter() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Meter", "Meter()", typeof(void));
        }
        /// <remarks>
        ///  Set text label for the meter
        /// <param> name="index" label index.
        /// </param><param> name="text" text for the label.
        ///      </param></remarks>        <short>    Set text label for the meter </short>
        public void SetLabel(int index, string text) {
            interceptor.Invoke("setLabel$$", "setLabel(int, const QString&)", typeof(void), typeof(int), index, typeof(string), text);
        }
        /// <remarks>
        /// <param> name="index" label index
        /// </param></remarks>        <return> text label for the meter
        ///      </return>
        ///         <short>   </short>
        public string Label(int index) {
            return (string) interceptor.Invoke("label$", "label(int) const", typeof(string), typeof(int), index);
        }
        /// <remarks>
        ///  Set text label color for the meter
        /// <param> name="index" label index
        /// </param><param> name="color" the color to apply to the label
        ///      </param></remarks>        <short>    Set text label color for the meter </short>
        public void SetLabelColor(int index, QColor color) {
            interceptor.Invoke("setLabelColor$#", "setLabelColor(int, const QColor&)", typeof(void), typeof(int), index, typeof(QColor), color);
        }
        /// <remarks>
        /// <param> name="index" label index
        /// </param></remarks>        <return> text label color for the meter
        ///      </return>
        ///         <short>   </short>
        public QColor LabelColor(int index) {
            return (QColor) interceptor.Invoke("labelColor$", "labelColor(int) const", typeof(QColor), typeof(int), index);
        }
        /// <remarks>
        ///  Set text label font for the meter
        /// <param> name="index" label index
        /// </param><param> name="font" the font to apply to the label
        ///      </param></remarks>        <short>    Set text label font for the meter </short>
        public void SetLabelFont(int index, QFont font) {
            interceptor.Invoke("setLabelFont$#", "setLabelFont(int, const QFont&)", typeof(void), typeof(int), index, typeof(QFont), font);
        }
        /// <remarks>
        /// <param> name="index" label index
        /// </param></remarks>        <return> text label font for the meter
        ///      </return>
        ///         <short>   </short>
        public QFont LabelFont(int index) {
            return (QFont) interceptor.Invoke("labelFont$", "labelFont(int) const", typeof(QFont), typeof(int), index);
        }
        /// <remarks>
        ///  Set text label alignment for the meter
        /// <param> name="index" label index
        /// </param><param> name="alignment" the text alignment to apply to the label
        ///      </param></remarks>        <short>    Set text label alignment for the meter </short>
        public void SetLabelAlignment(int index, uint alignment) {
            interceptor.Invoke("setLabelAlignment$$", "setLabelAlignment(int, const Qt::Alignment)", typeof(void), typeof(int), index, typeof(uint), alignment);
        }
        /// <remarks>
        /// <param> name="index" label index
        /// </param></remarks>        <return> text label alignment for the meter
        ///      </return>
        ///         <short>   </short>
        public uint LabelAlignment(int index) {
            return (uint) interceptor.Invoke("labelAlignment$", "labelAlignment(int) const", typeof(uint), typeof(int), index);
        }
        /// <remarks>
        /// <param> name="index" label index
        /// </param></remarks>        <return> the size of this label.
        ///      </return>
        ///         <short>   </short>
        public QRectF LabelRect(int index) {
            return (QRectF) interceptor.Invoke("labelRect$", "labelRect(int) const", typeof(QRectF), typeof(int), index);
        }
        /// <remarks>
        ///  Used when connecting to a DataEngine
        ///      </remarks>        <short>    Used when connecting to a DataEngine      </short>
        [Q_SLOT("void dataUpdated(QString, Plasma::DataEngine::Data)")]
        public void DataUpdated(string sourceName, Dictionary<string, QVariant> data) {
            interceptor.Invoke("dataUpdated$?", "dataUpdated(const QString&, const QHash<QString,QVariant>&)", typeof(void), typeof(string), sourceName, typeof(Dictionary<string, QVariant>), data);
        }
        /// <remarks>
        ///  Set maximum value for the meter
        ///      </remarks>        <short>    Set maximum value for the meter      </short>
        [Q_SLOT("void setMaximum(int)")]
        public void SetMaximum(int maximum) {
            interceptor.Invoke("setMaximum$", "setMaximum(int)", typeof(void), typeof(int), maximum);
        }
        /// <remarks>
        ///  Set minimum value for the meter
        ///      </remarks>        <short>    Set minimum value for the meter      </short>
        [Q_SLOT("void setMinimum(int)")]
        public void SetMinimum(int minimum) {
            interceptor.Invoke("setMinimum$", "setMinimum(int)", typeof(void), typeof(int), minimum);
        }
        /// <remarks>
        ///  Set value for the meter
        ///      </remarks>        <short>    Set value for the meter      </short>
        [Q_SLOT("void setValue(int)")]
        public void SetValue(int value) {
            interceptor.Invoke("setValue$", "setValue(int)", typeof(void), typeof(int), value);
        }
        /// <remarks>
        ///  Reimplemented from Plasma.Widget
        ///      </remarks>        <short>    Reimplemented from Plasma.Widget      </short>
        [SmokeMethod("paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)")]
        protected new virtual void Paint(QPainter p, QStyleOptionGraphicsItem option, QWidget widget) {
            interceptor.Invoke("paint###", "paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)", typeof(void), typeof(QPainter), p, typeof(QStyleOptionGraphicsItem), option, typeof(QWidget), widget);
        }
        [SmokeMethod("paint(QPainter*, const QStyleOptionGraphicsItem*)")]
        protected new virtual void Paint(QPainter p, QStyleOptionGraphicsItem option) {
            interceptor.Invoke("paint##", "paint(QPainter*, const QStyleOptionGraphicsItem*)", typeof(void), typeof(QPainter), p, typeof(QStyleOptionGraphicsItem), option);
        }
        ~Meter() {
            interceptor.Invoke("~Meter", "~Meter()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Meter", "~Meter()", typeof(void));
        }
        protected new IMeterSignals Emit {
            get { return (IMeterSignals) Q_EMIT; }
        }
    }

    public interface IMeterSignals : IQGraphicsWidgetSignals {
    }
}
