/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import android.util.LruCache;
import android.view.PointerIcon;
import org.qtproject.qt5.android.CursorShape;

public class QtPointerIcon {
    private static final String TAG = "QtPointerIcon";
    private static QtPointerIcon sQtPointer;
    private final LruCache<Long, PointerIcon> iconCache = new LruCache(10);
    private PointerIcon icon;

    public static QtPointerIcon instance() {
        if (sQtPointer == null) {
            sQtPointer = new QtPointerIcon();
        }
        return sQtPointer;
    }

    public PointerIcon getIcon() {
        return this.icon;
    }

    public void setIcon(int n) {
        if (Build.VERSION.SDK_INT >= 24) {
            this.icon = CursorShape.getPointerIconQt(n);
        }
    }

    public void setCachedBitmapIcon(long l) {
        if (Build.VERSION.SDK_INT >= 24) {
            this.icon = (PointerIcon)this.iconCache.get((Object)l);
        }
    }

    public void setBitmapIcon(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        if (bitmap == null) {
            Log.e((String)TAG, (String)"PointerIcon bitmap is null!");
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.icon = PointerIcon.create((Bitmap)bitmap, (float)n3, (float)n4);
            this.iconCache.put((Object)l, (Object)this.icon);
        }
    }

    public boolean existsInCache(long l) {
        return this.iconCache.get((Object)l) != null;
    }
}

