/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Log;
import org.qtproject.qt5.android.SAFFileManager;
import org.qtproject.qt5.android.SAFUtils;

public class CachedDocumentFile {
    private static final String TAG = "CachedDocumentFile";
    private String name;
    private final String mimeType;
    private final String documentId;
    private Integer size;
    private Uri uri;
    private final Context ctx;
    private Boolean exists = null;
    private Boolean writable = null;

    public CachedDocumentFile(Context context, String string, String string2, String string3, Integer n, Uri uri) {
        this.name = string;
        this.documentId = string2;
        this.mimeType = string3;
        this.size = n;
        this.uri = uri;
        this.ctx = context;
    }

    public CachedDocumentFile(Context context, String string, String string2, String string3, Uri uri) {
        this(context, string, string2, string3, -1, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedDocumentFile fromFileUri(Context context, Uri uri) {
        String[] stringArray = new String[]{"_display_name", "document_id", "mime_type", "_size"};
        try (Cursor cursor = null;){
            ContentResolver contentResolver = context.getContentResolver();
            cursor = contentResolver.query(uri, stringArray, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                CachedDocumentFile cachedDocumentFile = new CachedDocumentFile(context, SAFUtils.getColumnValStringOrNull(cursor, "_display_name"), SAFUtils.getColumnValStringOrNull(cursor, "document_id"), SAFUtils.getColumnValStringOrNull(cursor, "mime_type"), SAFUtils.getColumnValIntegerOrDefault(cursor, "_size", -1), uri);
                return cachedDocumentFile;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Uri getUri() {
        return this.uri;
    }

    public boolean isFile() {
        return !this.isDirectory() && !TextUtils.isEmpty((CharSequence)this.mimeType);
    }

    public boolean isDirectory() {
        return "vnd.android.document/directory".equals(this.mimeType);
    }

    public long getSize() {
        return this.queryForLong("_size", 0L);
    }

    public boolean rename(String string) {
        try {
            Uri uri = DocumentsContract.renameDocument((ContentResolver)this.ctx.getContentResolver(), (Uri)this.uri, (String)string);
            if (uri == null || uri == this.uri) {
                return false;
            }
            this.name = string;
            this.uri = uri;
            return true;
        }
        catch (Exception exception) {
            if (SAFFileManager.isArc()) {
                String string2 = this.uri.toString();
                this.uri = Uri.parse((String)string2.replaceFirst(this.name + "$", string));
                this.exists = null;
                if (this.exists()) {
                    this.name = string;
                    return true;
                }
                this.uri = Uri.parse((String)string2);
                return false;
            }
            Log.e((String)TAG, (String)("rename(): Rename failed: " + exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite() {
        if (this.writable != null) {
            return this.writable;
        }
        this.writable = false;
        try (Cursor cursor = null;){
            ContentResolver contentResolver = this.ctx.getContentResolver();
            String[] stringArray = new String[]{"flags", "mime_type"};
            cursor = contentResolver.query(this.uri, stringArray, null, null, null);
            int n = 0;
            String string = null;
            if (cursor != null && cursor.moveToFirst()) {
                n = SAFUtils.getColumnValIntegerOrDefault(cursor, "flags", 0);
                string = SAFUtils.getColumnValStringOrNull(cursor, "mime_type");
            }
            if ("vnd.android.document/directory".equals(string) && (n & 8) != 0) {
                this.writable = true;
            } else if ((n & 2) != 0) {
                this.writable = true;
            }
        }
        return this.writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        if (this.exists != null) {
            return this.exists;
        }
        try (Cursor cursor = null;){
            ContentResolver contentResolver = this.ctx.getContentResolver();
            String[] stringArray = new String[]{"document_id"};
            cursor = contentResolver.query(this.uri, stringArray, null, null, null);
            this.exists = cursor != null && cursor.getCount() > 0;
        }
        return this.exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long queryForLong(String string, long l) {
        try (Cursor cursor = null;){
            ContentResolver contentResolver = this.ctx.getContentResolver();
            String[] stringArray = new String[]{string};
            cursor = contentResolver.query(this.uri, stringArray, null, null, null);
            if (cursor != null && cursor.moveToFirst() && !cursor.isNull(0)) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CachedDocumentFile) {
            return ((CachedDocumentFile)object).getUri().equals((Object)this.getUri());
        }
        return false;
    }
}

