/*
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kabc/stdaddressbook.h>
#include <kabc/picture.h>

#include "addrview.h"

AddrView::AddrView( QWidget *parent, const char *name )
  : KListView( parent, name )
{
  addColumn( KABC::Addressee::photoLabel() );
  addColumn( KABC::Addressee::givenNameLabel() );
  addColumn( KABC::Addressee::familyNameLabel() );
  addColumn( KABC::Addressee::emailLabel() );
  addColumn( KABC::Addressee::birthdayLabel() );

  setAllColumnsShowFocus( true );

  reload();

  connect( KABC::StdAddressBook::self(), SIGNAL( addressBookChanged( AddressBook* ) ),
           this, SLOT( reload() ) );
}

AddrView::~AddrView()
{
}

void AddrView::reload()
{
  KABC::AddressBook::Iterator it;
  KABC::AddressBook *ab = KABC::StdAddressBook::self();

  // clear view
  clear();

  // insert new items
  for ( it = ab->begin(); it != ab->end(); ++it ) {
    QListViewItem *item = new QListViewItem( this,
                                             "",
                                             (*it).givenName(),
                                             (*it).familyName(),
                                             (*it).preferredEmail(),
                                             (*it).birthday().date().toString() );
    KABC::Picture pic = (*it).photo();
    if ( pic.isIntern() ) // has an image, no url
      item->setPixmap( 0, pic.data().smoothScale( 30, 40 ) );
  }
}

#include "addrview.moc"
