/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.Build;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.By;
import com.jayway.android.robotium.solo.Reflect;
import com.jayway.android.robotium.solo.RobotiumTextView;
import com.jayway.android.robotium.solo.RobotiumWebClient;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.WebElement;
import com.jayway.android.robotium.solo.WebElementCreator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebUtils {
    private ViewFetcher viewFetcher;
    private Instrumentation inst;
    private ActivityUtils activityUtils;
    RobotiumWebClient robotiumWebCLient;
    WebElementCreator webElementCreator;
    WebChromeClient originalWebChromeClient = null;

    public WebUtils(Instrumentation instrumentation, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.inst = instrumentation;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.webElementCreator = new WebElementCreator(sleeper);
        this.robotiumWebCLient = new RobotiumWebClient(instrumentation, this.webElementCreator);
    }

    public ArrayList<TextView> getTextViewsFromWebView() {
        boolean javaScriptWasExecuted = this.executeJavaScriptFunction("allTexts();");
        return this.createAndReturnTextViewsFromWebElements(javaScriptWasExecuted);
    }

    private ArrayList<TextView> createAndReturnTextViewsFromWebElements(boolean javaScriptWasExecuted) {
        ArrayList<TextView> webElementsAsTextViews = new ArrayList<TextView>();
        if (javaScriptWasExecuted) {
            for (WebElement webElement : this.webElementCreator.getWebElementsFromWebViews()) {
                if (!this.isWebElementSufficientlyShown(webElement)) continue;
                RobotiumTextView textView = new RobotiumTextView(this.inst.getContext(), webElement.getText(), webElement.getLocationX(), webElement.getLocationY());
                webElementsAsTextViews.add(textView);
            }
        }
        return webElementsAsTextViews;
    }

    public ArrayList<WebElement> getCurrentWebElements() {
        boolean javaScriptWasExecuted = this.executeJavaScriptFunction("allWebElements();");
        return this.getSufficientlyShownWebElements(javaScriptWasExecuted);
    }

    public ArrayList<WebElement> getCurrentWebElements(By by) {
        boolean javaScriptWasExecuted = this.executeJavaScript(by);
        return this.getSufficientlyShownWebElements(javaScriptWasExecuted);
    }

    private ArrayList<WebElement> getSufficientlyShownWebElements(boolean javaScriptWasExecuted) {
        ArrayList<WebElement> currentWebElements = new ArrayList<WebElement>();
        if (javaScriptWasExecuted) {
            for (WebElement webElement : this.webElementCreator.getWebElementsFromWebViews()) {
                if (!this.isWebElementSufficientlyShown(webElement)) continue;
                currentWebElements.add(webElement);
            }
        }
        return currentWebElements;
    }

    private String prepareForStartOfJavascriptExecution() {
        this.webElementCreator.prepareForStart();
        WebChromeClient currentWebChromeClient = this.getCurrentWebChromeClient();
        if (currentWebChromeClient != null && !currentWebChromeClient.getClass().isAssignableFrom(RobotiumWebClient.class)) {
            this.originalWebChromeClient = this.getCurrentWebChromeClient();
        }
        this.robotiumWebCLient.enableJavascriptAndSetRobotiumWebClient(this.viewFetcher.getCurrentViews(WebView.class), this.originalWebChromeClient);
        return this.getJavaScriptAsString();
    }

    private WebChromeClient getCurrentWebChromeClient() {
        WebChromeClient currentWebChromeClient = null;
        Object currentWebView = this.viewFetcher.getFreshestView(this.viewFetcher.getCurrentViews(WebView.class));
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                currentWebView = new Reflect(currentWebView).field("mProvider").out(Object.class);
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        try {
            Object mCallbackProxy = new Reflect(currentWebView).field("mCallbackProxy").out(Object.class);
            currentWebChromeClient = new Reflect(mCallbackProxy).field("mWebChromeClient").out(WebChromeClient.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentWebChromeClient;
    }

    public void enterTextIntoWebElement(By by, String text) {
        if (by instanceof By.Id) {
            this.executeJavaScriptFunction("enterTextById(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.Xpath) {
            this.executeJavaScriptFunction("enterTextByXpath(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.CssSelector) {
            this.executeJavaScriptFunction("enterTextByCssSelector(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.Name) {
            this.executeJavaScriptFunction("enterTextByName(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.ClassName) {
            this.executeJavaScriptFunction("enterTextByClassName(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.Text) {
            this.executeJavaScriptFunction("enterTextByTextContent(\"" + by.getValue() + "\", \"" + text + "\");");
        } else if (by instanceof By.TagName) {
            this.executeJavaScriptFunction("enterTextByTagName(\"" + by.getValue() + "\", \"" + text + "\");");
        }
    }

    private boolean executeJavaScript(By by) {
        if (by instanceof By.Id) {
            return this.executeJavaScriptFunction("id(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.Xpath) {
            return this.executeJavaScriptFunction("xpath(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.CssSelector) {
            return this.executeJavaScriptFunction("cssSelector(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.Name) {
            return this.executeJavaScriptFunction("name(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.ClassName) {
            return this.executeJavaScriptFunction("className(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.Text) {
            return this.executeJavaScriptFunction("textContent(\"" + by.getValue() + "\");");
        }
        if (by instanceof By.TagName) {
            return this.executeJavaScriptFunction("tagName(\"" + by.getValue() + "\");");
        }
        return false;
    }

    private boolean executeJavaScriptFunction(final String function) {
        final WebView webView = this.viewFetcher.getFreshestView(this.viewFetcher.getCurrentViews(WebView.class));
        if (webView == null) {
            return false;
        }
        final String javaScript = this.prepareForStartOfJavascriptExecution();
        this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

            public void run() {
                if (webView != null) {
                    webView.loadUrl("javascript:" + javaScript + function);
                }
            }
        });
        return true;
    }

    public final boolean isWebElementSufficientlyShown(WebElement webElement) {
        WebView webView = this.viewFetcher.getFreshestView(this.viewFetcher.getCurrentViews(WebView.class));
        int[] xyWebView = new int[2];
        if (webView != null && webElement != null) {
            webView.getLocationOnScreen(xyWebView);
            if (xyWebView[1] + webView.getHeight() > webElement.getLocationY()) {
                return true;
            }
        }
        return false;
    }

    public String splitNameByUpperCase(String name) {
        String[] texts = name.split("(?=\\p{Upper})");
        StringBuilder stringToReturn = new StringBuilder();
        for (String string : texts) {
            if (stringToReturn.length() > 0) {
                stringToReturn.append(" " + string.toLowerCase());
                continue;
            }
            stringToReturn.append(string.toLowerCase());
        }
        return stringToReturn.toString();
    }

    private String getJavaScriptAsString() {
        InputStream fis = this.getClass().getResourceAsStream("RobotiumWeb.js");
        StringBuffer javaScript = new StringBuffer();
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = input.readLine()) != null) {
                javaScript.append(line);
                javaScript.append("\n");
            }
            input.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return javaScript.toString();
    }
}

