/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rfb.CMsgHandler;
import rfb.Decoder;
import rfb.Exception;
import rfb.LogWriter;

public abstract class CMsgReader {
    CMsgHandler handler;
    InStream is;
    Decoder[] decoders;
    int[] imageBuf;
    int imageBufSize;
    static LogWriter vlog = new LogWriter("CMsgReader");

    public abstract void readServerInit();

    public abstract void readMsg();

    public InStream getInStream() {
        return this.is;
    }

    public int[] getImageBuf(int n) {
        if (this.imageBufSize < n) {
            this.imageBufSize = n;
            this.imageBuf = new int[this.imageBufSize];
        }
        return this.imageBuf;
    }

    public final int bpp() {
        return this.handler.cp.pf().bpp;
    }

    protected CMsgReader(CMsgHandler cMsgHandler, InStream inStream) {
        this.handler = cMsgHandler;
        this.is = inStream;
        this.decoders = new Decoder[256];
    }

    protected void readSetColourMapEntries() {
        this.is.skip(1);
        int n = this.is.readU16();
        int n2 = this.is.readU16();
        int[] nArray = new int[n2 * 3];
        for (int i = 0; i < n2 * 3; ++i) {
            nArray[i] = this.is.readU16();
        }
        this.endMsg();
        this.handler.setColourMapEntries(n, n2, nArray);
    }

    protected void readBell() {
        this.endMsg();
        this.handler.bell();
    }

    protected void readServerCutText() {
        this.is.skip(3);
        int n = this.is.readU32();
        if (n > 262144) {
            this.is.skip(n);
            vlog.error("cut text too long (" + n + " bytes) - ignoring");
            return;
        }
        byte[] byArray = new byte[n];
        this.is.readBytes(byArray, 0, n);
        this.endMsg();
        this.handler.serverCutText(new String(byArray, 0, n));
    }

    protected void endMsg() {
    }

    protected void readFramebufferUpdateStart() {
        this.endMsg();
        this.handler.framebufferUpdateStart();
    }

    protected void readFramebufferUpdateEnd() {
        this.endMsg();
        this.handler.framebufferUpdateEnd();
    }

    protected void readRect(int n, int n2, int n3, int n4, int n5) {
        if (n + n3 > this.handler.cp.width || n2 + n4 > this.handler.cp.height) {
            vlog.error("Rect too big: " + n3 + "x" + n4 + " at " + n + "," + n2 + " exceeds " + this.handler.cp.width + "x" + this.handler.cp.height);
            throw new Exception("Rect too big");
        }
        if (n3 * n4 == 0) {
            vlog.info("Ignoring zero size rect");
            return;
        }
        this.handler.beginRect(n, n2, n3, n4, n5);
        if (n5 == 1) {
            this.readCopyRect(n, n2, n3, n4);
        } else {
            if (this.decoders[n5] == null) {
                this.decoders[n5] = Decoder.createDecoder(n5, this);
                if (this.decoders[n5] == null) {
                    vlog.error("Unknown rect encoding " + n5);
                    throw new Exception("Unknown rect encoding");
                }
            }
            this.decoders[n5].readRect(n, n2, n3, n4, this.handler);
        }
        this.handler.endRect(n, n2, n3, n4, n5);
    }

    protected void readCopyRect(int n, int n2, int n3, int n4) {
        int n5 = this.is.readU16();
        int n6 = this.is.readU16();
        this.handler.copyRect(n, n2, n3, n4, n5, n6);
    }

    protected void readSetCursor(int n, int n2, int n3, int n4) {
        int n5 = n3 * n4;
        int n6 = (n3 + 7) / 8 * n4;
        int[] nArray = new int[n5];
        byte[] byArray = new byte[n6];
        this.is.readPixels(nArray, n5);
        this.is.readBytes(byArray, 0, n6);
        this.handler.setCursor(n, n2, n3, n4, nArray, byArray);
    }
}

