/* valaarraymovemethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraymovemethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valavoidtype.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>




enum  {
	VALA_ARRAY_MOVE_METHOD_DUMMY_PROPERTY
};
static gpointer vala_array_move_method_parent_class = NULL;



/**
 * Creates a new array move method.
 *
 * @return newly created method
 */
ValaArrayMoveMethod* vala_array_move_method_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaArrayMoveMethod* self;
	ValaVoidType* _tmp0;
	g_return_val_if_fail (source_reference != NULL, NULL);
	_tmp0 = NULL;
	self = (ValaArrayMoveMethod*) vala_method_construct (object_type, "move", (ValaDataType*) (_tmp0 = vala_void_type_new (NULL)), source_reference);
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL));
	vala_symbol_set_external ((ValaSymbol*) self, TRUE);
	return self;
}


ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference) {
	return vala_array_move_method_construct (VALA_TYPE_ARRAY_MOVE_METHOD, source_reference);
}


static void vala_array_move_method_class_init (ValaArrayMoveMethodClass * klass) {
	vala_array_move_method_parent_class = g_type_class_peek_parent (klass);
}


static void vala_array_move_method_instance_init (ValaArrayMoveMethod * self) {
}


GType vala_array_move_method_get_type (void) {
	static GType vala_array_move_method_type_id = 0;
	if (vala_array_move_method_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayMoveMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_move_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayMoveMethod), 0, (GInstanceInitFunc) vala_array_move_method_instance_init, NULL };
		vala_array_move_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaArrayMoveMethod", &g_define_type_info, 0);
	}
	return vala_array_move_method_type_id;
}




