/* valanamespacereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanamespacereference.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaNamespaceReferencePrivate {
	char* _name;
	ValaSymbol* _namespace_symbol;
};

#define VALA_NAMESPACE_REFERENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE_REFERENCE, ValaNamespaceReferencePrivate))
enum  {
	VALA_NAMESPACE_REFERENCE_DUMMY_PROPERTY,
	VALA_NAMESPACE_REFERENCE_NAME,
	VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL
};
static void vala_namespace_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_namespace_reference_parent_class = NULL;
static void vala_namespace_reference_dispose (GObject * obj);



/**
 * Creates a new namespace reference.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace reference
 */
ValaNamespaceReference* vala_namespace_reference_new (const char* name, ValaSourceReference* source_reference) {
	ValaNamespaceReference * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_NAMESPACE_REFERENCE, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_namespace_reference_set_name (self, name);
	return self;
}


static void vala_namespace_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespaceReference * self;
	self = VALA_NAMESPACE_REFERENCE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_namespace_reference (visitor, self);
}


const char* vala_namespace_reference_get_name (ValaNamespaceReference* self) {
	g_return_val_if_fail (VALA_IS_NAMESPACE_REFERENCE (self), NULL);
	return self->priv->_name;
}


void vala_namespace_reference_set_name (ValaNamespaceReference* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


ValaSymbol* vala_namespace_reference_get_namespace_symbol (ValaNamespaceReference* self) {
	g_return_val_if_fail (VALA_IS_NAMESPACE_REFERENCE (self), NULL);
	return self->priv->_namespace_symbol;
}


void vala_namespace_reference_set_namespace_symbol (ValaNamespaceReference* self, ValaSymbol* value) {
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (self));
	self->priv->_namespace_symbol = value;
}


static void vala_namespace_reference_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaNamespaceReference * self;
	self = VALA_NAMESPACE_REFERENCE (object);
	switch (property_id) {
		case VALA_NAMESPACE_REFERENCE_NAME:
		g_value_set_string (value, vala_namespace_reference_get_name (self));
		break;
		case VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL:
		g_value_set_object (value, vala_namespace_reference_get_namespace_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_namespace_reference_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaNamespaceReference * self;
	self = VALA_NAMESPACE_REFERENCE (object);
	switch (property_id) {
		case VALA_NAMESPACE_REFERENCE_NAME:
		vala_namespace_reference_set_name (self, g_value_get_string (value));
		break;
		case VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL:
		vala_namespace_reference_set_namespace_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_namespace_reference_class_init (ValaNamespaceReferenceClass * klass) {
	vala_namespace_reference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaNamespaceReferencePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_namespace_reference_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_namespace_reference_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_namespace_reference_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_namespace_reference_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMESPACE_REFERENCE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL, g_param_spec_object ("namespace-symbol", "namespace-symbol", "namespace-symbol", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_namespace_reference_instance_init (ValaNamespaceReference * self) {
	self->priv = VALA_NAMESPACE_REFERENCE_GET_PRIVATE (self);
}


static void vala_namespace_reference_dispose (GObject * obj) {
	ValaNamespaceReference * self;
	self = VALA_NAMESPACE_REFERENCE (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	G_OBJECT_CLASS (vala_namespace_reference_parent_class)->dispose (obj);
}


GType vala_namespace_reference_get_type (void) {
	static GType vala_namespace_reference_type_id = 0;
	if (G_UNLIKELY (vala_namespace_reference_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_reference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespaceReference), 0, (GInstanceInitFunc) vala_namespace_reference_instance_init };
		vala_namespace_reference_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaNamespaceReference", &g_define_type_info, 0);
	}
	return vala_namespace_reference_type_id;
}




