/* valainstancecast.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainstancecast.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>




struct _ValaInstanceCastPrivate {
	ValaTypeSymbol* _type_reference;
	ValaCCodeExpression* _inner;
};

#define VALA_INSTANCE_CAST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastPrivate))
enum  {
	VALA_INSTANCE_CAST_DUMMY_PROPERTY,
	VALA_INSTANCE_CAST_TYPE_REFERENCE,
	VALA_INSTANCE_CAST_INNER
};
static GObject * vala_instance_cast_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_instance_cast_parent_class = NULL;
static void vala_instance_cast_dispose (GObject * obj);



/**
 * Creates a new instance cast expression.
 *
 * @param expr an expression
 * @param type the target type
 * @return     newly created instance cast expression
 */
ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaTypeSymbol* type) {
	GParameter * __params;
	GParameter * __params_it;
	ValaInstanceCast * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "inner";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, expr);
	__params_it++;
	__params_it->name = "type-reference";
	g_value_init (&__params_it->value, VALA_TYPE_TYPESYMBOL);
	g_value_set_object (&__params_it->value, type);
	__params_it++;
	self = g_object_newv (VALA_TYPE_INSTANCE_CAST, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ValaTypeSymbol* vala_instance_cast_get_type_reference (ValaInstanceCast* self) {
	g_return_val_if_fail (VALA_IS_INSTANCE_CAST (self), NULL);
	return self->priv->_type_reference;
}


void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaTypeSymbol* value) {
	g_return_if_fail (VALA_IS_INSTANCE_CAST (self));
	self->priv->_type_reference = value;
}


ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self) {
	g_return_val_if_fail (VALA_IS_INSTANCE_CAST (self), NULL);
	return self->priv->_inner;
}


void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_INSTANCE_CAST (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp2);
}


static GObject * vala_instance_cast_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaInstanceCastClass * klass;
	GObjectClass * parent_class;
	ValaInstanceCast * self;
	klass = VALA_INSTANCE_CAST_CLASS (g_type_class_peek (VALA_TYPE_INSTANCE_CAST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_INSTANCE_CAST (obj);
	{
		ValaCCodeIdentifier* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (VALA_CCODE_FUNCTION_CALL (self), VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_upper_case_cname (self->priv->_type_reference, NULL))))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		_tmp0 = (g_free (_tmp0), NULL);
		vala_ccode_function_call_add_argument (VALA_CCODE_FUNCTION_CALL (self), VALA_CCODE_EXPRESSION (self->priv->_inner));
	}
	return obj;
}


static void vala_instance_cast_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (object);
	switch (property_id) {
		case VALA_INSTANCE_CAST_TYPE_REFERENCE:
		g_value_set_object (value, vala_instance_cast_get_type_reference (self));
		break;
		case VALA_INSTANCE_CAST_INNER:
		g_value_set_object (value, vala_instance_cast_get_inner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_instance_cast_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (object);
	switch (property_id) {
		case VALA_INSTANCE_CAST_TYPE_REFERENCE:
		vala_instance_cast_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_INSTANCE_CAST_INNER:
		vala_instance_cast_set_inner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_instance_cast_class_init (ValaInstanceCastClass * klass) {
	vala_instance_cast_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInstanceCastPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_instance_cast_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_instance_cast_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_instance_cast_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_instance_cast_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INSTANCE_CAST_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_TYPESYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INSTANCE_CAST_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_instance_cast_instance_init (ValaInstanceCast * self) {
	self->priv = VALA_INSTANCE_CAST_GET_PRIVATE (self);
}


static void vala_instance_cast_dispose (GObject * obj) {
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	G_OBJECT_CLASS (vala_instance_cast_parent_class)->dispose (obj);
}


GType vala_instance_cast_get_type (void) {
	static GType vala_instance_cast_type_id = 0;
	if (G_UNLIKELY (vala_instance_cast_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInstanceCastClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_instance_cast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInstanceCast), 0, (GInstanceInitFunc) vala_instance_cast_instance_init };
		vala_instance_cast_type_id = g_type_register_static (VALA_TYPE_CCODE_FUNCTION_CALL, "ValaInstanceCast", &g_define_type_info, 0);
	}
	return vala_instance_cast_type_id;
}




