/* valaarraymovemethod.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAARRAYMOVEMETHOD_H__
#define __VALA_VALAARRAYMOVEMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valamethod.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS


#define VALA_TYPE_ARRAY_MOVE_METHOD (vala_array_move_method_get_type ())
#define VALA_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethod))
#define VALA_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))
#define VALA_IS_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_IS_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_ARRAY_MOVE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))

typedef struct _ValaArrayMoveMethod ValaArrayMoveMethod;
typedef struct _ValaArrayMoveMethodClass ValaArrayMoveMethodClass;
typedef struct _ValaArrayMoveMethodPrivate ValaArrayMoveMethodPrivate;

/**
 * Represents the Array.move method.
 */
struct _ValaArrayMoveMethod {
	ValaMethod parent_instance;
	ValaArrayMoveMethodPrivate * priv;
};

struct _ValaArrayMoveMethodClass {
	ValaMethodClass parent_class;
};


ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference);
GType vala_array_move_method_get_type (void);


G_END_DECLS

#endif
