/* valaccodecastexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODECASTEXPRESSION_H__
#define __CCODE_VALACCODECASTEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_CAST_EXPRESSION (vala_ccode_cast_expression_get_type ())
#define VALA_CCODE_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CAST_EXPRESSION, ValaCCodeCastExpression))
#define VALA_CCODE_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CAST_EXPRESSION, ValaCCodeCastExpressionClass))
#define VALA_IS_CCODE_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CAST_EXPRESSION))
#define VALA_IS_CCODE_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CAST_EXPRESSION))
#define VALA_CCODE_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CAST_EXPRESSION, ValaCCodeCastExpressionClass))

typedef struct _ValaCCodeCastExpression ValaCCodeCastExpression;
typedef struct _ValaCCodeCastExpressionClass ValaCCodeCastExpressionClass;
typedef struct _ValaCCodeCastExpressionPrivate ValaCCodeCastExpressionPrivate;

/**
 * Represents a type cast in the generated C code.
 */
struct _ValaCCodeCastExpression {
	ValaCCodeExpression parent_instance;
	ValaCCodeCastExpressionPrivate * priv;
};

struct _ValaCCodeCastExpressionClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeCastExpression* vala_ccode_cast_expression_new (ValaCCodeExpression* expr, const char* type);
ValaCCodeExpression* vala_ccode_cast_expression_get_inner (ValaCCodeCastExpression* self);
void vala_ccode_cast_expression_set_inner (ValaCCodeCastExpression* self, ValaCCodeExpression* value);
const char* vala_ccode_cast_expression_get_type_name (ValaCCodeCastExpression* self);
void vala_ccode_cast_expression_set_type_name (ValaCCodeCastExpression* self, const char* value);
GType vala_ccode_cast_expression_get_type (void);


G_END_DECLS

#endif
