/* valatuple.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatuple.h>
#include <gee/arraylist.h>
#include <gee/collection.h>




struct _ValaTuplePrivate {
	GeeList* expression_list;
};

#define VALA_TUPLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TUPLE, ValaTuplePrivate))
enum  {
	VALA_TUPLE_DUMMY_PROPERTY
};
static gboolean vala_tuple_real_is_pure (ValaExpression* base);
static gpointer vala_tuple_parent_class = NULL;
static void vala_tuple_dispose (GObject * obj);



ValaTuple* vala_tuple_new (void) {
	ValaTuple * self;
	self = g_object_newv (VALA_TYPE_TUPLE, 0, NULL);
	return self;
}


void vala_tuple_add_expression (ValaTuple* self, ValaExpression* expr) {
	g_return_if_fail (VALA_IS_TUPLE (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->expression_list), expr);
}


GeeList* vala_tuple_get_expressions (ValaTuple* self) {
	GeeList* _tmp0;
	g_return_val_if_fail (VALA_IS_TUPLE (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->expression_list, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static gboolean vala_tuple_real_is_pure (ValaExpression* base) {
	ValaTuple * self;
	self = VALA_TUPLE (base);
	return FALSE;
}


static void vala_tuple_class_init (ValaTupleClass * klass) {
	vala_tuple_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTuplePrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_tuple_dispose;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_tuple_real_is_pure;
}


static void vala_tuple_init (ValaTuple * self) {
	self->priv = VALA_TUPLE_GET_PRIVATE (self);
	self->priv->expression_list = GEE_LIST (gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_tuple_dispose (GObject * obj) {
	ValaTuple * self;
	self = VALA_TUPLE (obj);
	(self->priv->expression_list == NULL ? NULL : (self->priv->expression_list = (g_object_unref (self->priv->expression_list), NULL)));
	G_OBJECT_CLASS (vala_tuple_parent_class)->dispose (obj);
}


GType vala_tuple_get_type (void) {
	static GType vala_tuple_type_id = 0;
	if (G_UNLIKELY (vala_tuple_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTupleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tuple_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTuple), 0, (GInstanceInitFunc) vala_tuple_init };
		vala_tuple_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTuple", &g_define_type_info, 0);
	}
	return vala_tuple_type_id;
}




