/* valareferencetype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valareferencetype.h>




enum  {
	VALA_REFERENCE_TYPE_DUMMY_PROPERTY
};
static gpointer vala_reference_type_parent_class = NULL;



/**
 * A reference type, i.e. a class, interface, or array type.
 */
ValaReferenceType* vala_reference_type_new (void) {
	ValaReferenceType * self;
	self = g_object_newv (VALA_TYPE_REFERENCE_TYPE, 0, NULL);
	return self;
}


static void vala_reference_type_class_init (ValaReferenceTypeClass * klass) {
	vala_reference_type_parent_class = g_type_class_peek_parent (klass);
}


static void vala_reference_type_init (ValaReferenceType * self) {
}


GType vala_reference_type_get_type (void) {
	static GType vala_reference_type_type_id = 0;
	if (G_UNLIKELY (vala_reference_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReferenceTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_reference_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReferenceType), 0, (GInstanceInitFunc) vala_reference_type_init };
		vala_reference_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaReferenceType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_reference_type_type_id;
}




