/* valamember.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valamember.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/readonlycollection.h>
#include <vala/valacodevisitor.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>




struct _ValaMemberPrivate {
	GeeList* cheader_filenames;
};

#define VALA_MEMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER, ValaMemberPrivate))
enum  {
	VALA_MEMBER_DUMMY_PROPERTY
};
static void vala_member_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static GeeCollection* vala_member_real_get_cheader_filenames (ValaSymbol* base);
static gpointer vala_member_parent_class = NULL;
static void vala_member_dispose (GObject * obj);



static void vala_member_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMember * self;
	self = VALA_MEMBER (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_member (visitor, self);
}


static GeeCollection* vala_member_real_get_cheader_filenames (ValaSymbol* base) {
	ValaMember * self;
	self = VALA_MEMBER (base);
	if (gee_collection_get_size (GEE_COLLECTION (self->priv->cheader_filenames)) == 0 && vala_symbol_get_parent_symbol (VALA_SYMBOL (self)) != NULL) {
		/* default to header filenames of the namespace */
		{
			GeeCollection* filename_collection;
			GeeIterator* filename_it;
			filename_collection = vala_symbol_get_cheader_filenames (vala_symbol_get_parent_symbol (VALA_SYMBOL (self)));
			filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
			while (gee_iterator_next (filename_it)) {
				char* filename;
				filename = ((char*) gee_iterator_get (filename_it));
				{
					vala_member_add_cheader_filename (self, filename);
					filename = (g_free (filename), NULL);
				}
			}
			(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
			(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
		}
		if (gee_collection_get_size (GEE_COLLECTION (self->priv->cheader_filenames)) == 0 && vala_code_node_get_source_reference (VALA_CODE_NODE (self)) != NULL && !vala_symbol_get_external_package (VALA_SYMBOL (self))) {
			char* _tmp0;
			/* don't add default include directives for VAPI files*/
			_tmp0 = NULL;
			gee_collection_add (GEE_COLLECTION (self->priv->cheader_filenames), (_tmp0 = vala_source_file_get_cinclude_filename (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))));
			_tmp0 = (g_free (_tmp0), NULL);
		}
	}
	return GEE_COLLECTION (gee_read_only_collection_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, GEE_COLLECTION (self->priv->cheader_filenames)));
}


/**
 * Adds a filename to the list of C header filenames users of this data
 * type must include.
 *
 * @param filename a C header filename
 */
void vala_member_add_cheader_filename (ValaMember* self, const char* filename) {
	g_return_if_fail (VALA_IS_MEMBER (self));
	g_return_if_fail (filename != NULL);
	gee_collection_add (GEE_COLLECTION (self->priv->cheader_filenames), filename);
}


/**
 * Represents a general class member.
 */
ValaMember* vala_member_new (void) {
	ValaMember * self;
	self = g_object_newv (VALA_TYPE_MEMBER, 0, NULL);
	return self;
}


static void vala_member_class_init (ValaMemberClass * klass) {
	vala_member_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMemberPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_member_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_member_real_accept;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_member_real_get_cheader_filenames;
}


static void vala_member_init (ValaMember * self) {
	self->priv = VALA_MEMBER_GET_PRIVATE (self);
	self->priv->cheader_filenames = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_direct_equal));
}


static void vala_member_dispose (GObject * obj) {
	ValaMember * self;
	self = VALA_MEMBER (obj);
	(self->priv->cheader_filenames == NULL ? NULL : (self->priv->cheader_filenames = (g_object_unref (self->priv->cheader_filenames), NULL)));
	G_OBJECT_CLASS (vala_member_parent_class)->dispose (obj);
}


GType vala_member_get_type (void) {
	static GType vala_member_type_id = 0;
	if (G_UNLIKELY (vala_member_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMember), 0, (GInstanceInitFunc) vala_member_init };
		vala_member_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaMember", &g_define_type_info, 0);
	}
	return vala_member_type_id;
}



GType member_binding_get_type (void) {
	static GType member_binding_type_id = 0;
	if (G_UNLIKELY (member_binding_type_id == 0)) {
		static const GEnumValue values[] = {{MEMBER_BINDING_INSTANCE, "MEMBER_BINDING_INSTANCE", "instance"}, {MEMBER_BINDING_CLASS, "MEMBER_BINDING_CLASS", "class"}, {MEMBER_BINDING_STATIC, "MEMBER_BINDING_STATIC", "static"}, {0, NULL, NULL}};
		member_binding_type_id = g_enum_register_static ("MemberBinding", values);
	}
	return member_binding_type_id;
}




