/* valafieldprototype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valafieldprototype.h>
#include <vala/valasymbol.h>




struct _ValaFieldPrototypePrivate {
	ValaField* _field_symbol;
};

#define VALA_FIELD_PROTOTYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypePrivate))
enum  {
	VALA_FIELD_PROTOTYPE_DUMMY_PROPERTY,
	VALA_FIELD_PROTOTYPE_FIELD_SYMBOL
};
static ValaDataType* vala_field_prototype_real_copy (ValaDataType* base);
static char* vala_field_prototype_real_to_string (ValaCodeNode* base);
static gpointer vala_field_prototype_parent_class = NULL;
static void vala_field_prototype_dispose (GObject * obj);



ValaFieldPrototype* vala_field_prototype_new (ValaField* field_symbol) {
	ValaFieldPrototype * self;
	g_return_val_if_fail (VALA_IS_FIELD (field_symbol), NULL);
	self = g_object_newv (VALA_TYPE_FIELD_PROTOTYPE, 0, NULL);
	vala_field_prototype_set_field_symbol (self, field_symbol);
	return self;
}


static ValaDataType* vala_field_prototype_real_copy (ValaDataType* base) {
	ValaFieldPrototype * self;
	ValaFieldPrototype* result;
	self = VALA_FIELD_PROTOTYPE (base);
	result = vala_field_prototype_new (self->priv->_field_symbol);
	return VALA_DATA_TYPE (result);
}


static char* vala_field_prototype_real_to_string (ValaCodeNode* base) {
	ValaFieldPrototype * self;
	self = VALA_FIELD_PROTOTYPE (base);
	return vala_symbol_get_full_name (VALA_SYMBOL (self->priv->_field_symbol));
}


ValaField* vala_field_prototype_get_field_symbol (ValaFieldPrototype* self) {
	g_return_val_if_fail (VALA_IS_FIELD_PROTOTYPE (self), NULL);
	return self->priv->_field_symbol;
}


void vala_field_prototype_set_field_symbol (ValaFieldPrototype* self, ValaField* value) {
	ValaField* _tmp2;
	ValaField* _tmp1;
	g_return_if_fail (VALA_IS_FIELD_PROTOTYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_field_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_field_symbol == NULL ? NULL : (self->priv->_field_symbol = (g_object_unref (self->priv->_field_symbol), NULL))), _tmp2);
}


static void vala_field_prototype_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaFieldPrototype * self;
	self = VALA_FIELD_PROTOTYPE (object);
	switch (property_id) {
		case VALA_FIELD_PROTOTYPE_FIELD_SYMBOL:
		g_value_set_object (value, vala_field_prototype_get_field_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_field_prototype_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaFieldPrototype * self;
	self = VALA_FIELD_PROTOTYPE (object);
	switch (property_id) {
		case VALA_FIELD_PROTOTYPE_FIELD_SYMBOL:
		vala_field_prototype_set_field_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_field_prototype_class_init (ValaFieldPrototypeClass * klass) {
	vala_field_prototype_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaFieldPrototypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_field_prototype_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_field_prototype_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_field_prototype_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_field_prototype_real_copy;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_field_prototype_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FIELD_PROTOTYPE_FIELD_SYMBOL, g_param_spec_object ("field-symbol", "field-symbol", "field-symbol", VALA_TYPE_FIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_field_prototype_init (ValaFieldPrototype * self) {
	self->priv = VALA_FIELD_PROTOTYPE_GET_PRIVATE (self);
}


static void vala_field_prototype_dispose (GObject * obj) {
	ValaFieldPrototype * self;
	self = VALA_FIELD_PROTOTYPE (obj);
	(self->priv->_field_symbol == NULL ? NULL : (self->priv->_field_symbol = (g_object_unref (self->priv->_field_symbol), NULL)));
	G_OBJECT_CLASS (vala_field_prototype_parent_class)->dispose (obj);
}


GType vala_field_prototype_get_type (void) {
	static GType vala_field_prototype_type_id = 0;
	if (G_UNLIKELY (vala_field_prototype_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldPrototypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_prototype_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFieldPrototype), 0, (GInstanceInitFunc) vala_field_prototype_init };
		vala_field_prototype_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaFieldPrototype", &g_define_type_info, 0);
	}
	return vala_field_prototype_type_id;
}




