/* valaccodeconstant.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODECONSTANT_H__
#define __CCODE_VALACCODECONSTANT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_CONSTANT (vala_ccode_constant_get_type ())
#define VALA_CCODE_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant))
#define VALA_CCODE_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantClass))
#define VALA_IS_CCODE_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONSTANT))
#define VALA_IS_CCODE_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONSTANT))
#define VALA_CCODE_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstantClass))

typedef struct _ValaCCodeConstant ValaCCodeConstant;
typedef struct _ValaCCodeConstantClass ValaCCodeConstantClass;
typedef struct _ValaCCodeConstantPrivate ValaCCodeConstantPrivate;

/**
 * A constant C expression.
 */
struct _ValaCCodeConstant {
	ValaCCodeExpression parent_instance;
	ValaCCodeConstantPrivate * priv;
};

struct _ValaCCodeConstantClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeConstant* vala_ccode_constant_new (const char* _name);
char* vala_ccode_constant_get_name (ValaCCodeConstant* self);
void vala_ccode_constant_set_name (ValaCCodeConstant* self, const char* value);
GType vala_ccode_constant_get_type (void);


G_END_DECLS

#endif
