/* valaarrayresizemethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAARRAYRESIZEMETHOD_H__
#define __VALA_VALAARRAYRESIZEMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valamethod.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS


#define VALA_TYPE_ARRAY_RESIZE_METHOD (vala_array_resize_method_get_type ())
#define VALA_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethod))
#define VALA_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))
#define VALA_IS_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_IS_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_ARRAY_RESIZE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))

typedef struct _ValaArrayResizeMethod ValaArrayResizeMethod;
typedef struct _ValaArrayResizeMethodClass ValaArrayResizeMethodClass;
typedef struct _ValaArrayResizeMethodPrivate ValaArrayResizeMethodPrivate;

/**
 * Represents the Array.resize method.
 */
struct _ValaArrayResizeMethod {
	ValaMethod parent_instance;
	ValaArrayResizeMethodPrivate * priv;
};
struct _ValaArrayResizeMethodClass {
	ValaMethodClass parent_class;
};

ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* source_reference);
GType vala_array_resize_method_get_type (void);


G_END_DECLS

#endif
