/* valaccodedynamicsignalbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDYNAMICSIGNALBINDING_H__
#define __GOBJECT_VALACCODEDYNAMICSIGNALBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadynamicsignal.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasignal.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING (vala_ccode_dynamic_signal_binding_get_type ())
#define VALA_CCODE_DYNAMIC_SIGNAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, ValaCCodeDynamicSignalBinding))
#define VALA_CCODE_DYNAMIC_SIGNAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, ValaCCodeDynamicSignalBindingClass))
#define VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING))
#define VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING))
#define VALA_CCODE_DYNAMIC_SIGNAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, ValaCCodeDynamicSignalBindingClass))

typedef struct _ValaCCodeDynamicSignalBindingPrivate ValaCCodeDynamicSignalBindingPrivate;

/**
 * The link between a dynamic signal and generated code.
 */
struct _ValaCCodeDynamicSignalBinding {
	ValaCCodeBinding parent_instance;
	ValaCCodeDynamicSignalBindingPrivate * priv;
};
struct _ValaCCodeDynamicSignalBindingClass {
	ValaCCodeBindingClass parent_class;
};

ValaCCodeDynamicSignalBinding* vala_ccode_dynamic_signal_binding_new (ValaCCodeGenerator* codegen, ValaDynamicSignal* node);
char* vala_ccode_dynamic_signal_binding_get_connect_wrapper_name (ValaCCodeDynamicSignalBinding* self);
char* vala_ccode_dynamic_signal_binding_get_disconnect_wrapper_name (ValaCCodeDynamicSignalBinding* self);
ValaSignal* vala_ccode_dynamic_signal_binding_get_node (ValaCCodeDynamicSignalBinding* self);
void vala_ccode_dynamic_signal_binding_set_node (ValaCCodeDynamicSignalBinding* self, ValaSignal* value);
GType vala_ccode_dynamic_signal_binding_get_type (void);


G_END_DECLS

#endif
