/* valaccodedeclaration.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodedeclaration.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodevariabledeclarator.h>




struct _ValaCCodeDeclarationPrivate {
	char* _type_name;
	ValaCCodeModifiers _modifiers;
	GeeList* declarators;
};
#define VALA_CCODE_DECLARATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationPrivate))
enum  {
	VALA_CCODE_DECLARATION_DUMMY_PROPERTY,
	VALA_CCODE_DECLARATION_TYPE_NAME,
	VALA_CCODE_DECLARATION_MODIFIERS
};
static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gboolean vala_ccode_declaration_has_initializer (ValaCCodeDeclaration* self);
static void vala_ccode_declaration_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_declaration_parent_class = NULL;
static void vala_ccode_declaration_dispose (GObject * obj);



ValaCCodeDeclaration* vala_ccode_declaration_new (const char* type_name) {
	ValaCCodeDeclaration * self;
	g_return_val_if_fail (type_name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DECLARATION, 0, NULL);
	vala_ccode_declaration_set_type_name (self, type_name);
	return self;
}


/**
 * Adds the specified declarator to this declaration.
 *
 * @param decl a declarator
 */
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl) {
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	g_return_if_fail (VALA_IS_CCODE_DECLARATOR (decl));
	gee_collection_add (GEE_COLLECTION (self->priv->declarators), decl);
}


static void vala_ccode_declaration_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDeclaration * self;
	self = VALA_CCODE_DECLARATION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if ((self->priv->_modifiers & (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_EXTERN)) != 0) {
		gboolean first;
		/* combined declaration and initialization for static and extern variables*/
		vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_STATIC) != 0) {
			vala_ccode_writer_write_string (writer, "static ");
		}
		if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_EXTERN) != 0 && !vala_ccode_declaration_has_initializer (self)) {
			vala_ccode_writer_write_string (writer, "extern ");
		}
		vala_ccode_writer_write_string (writer, self->priv->_type_name);
		vala_ccode_writer_write_string (writer, " ");
		first = TRUE;
		{
			GeeList* decl_collection;
			GeeIterator* decl_it;
			decl_collection = self->priv->declarators;
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaCCodeDeclarator* decl;
				decl = ((ValaCCodeDeclarator*) gee_iterator_get (decl_it));
				{
					if (!first) {
						vala_ccode_writer_write_string (writer, ", ");
					} else {
						first = FALSE;
					}
					vala_ccode_node_write (VALA_CCODE_NODE (decl), writer);
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
		vala_ccode_writer_write_string (writer, ";");
		vala_ccode_writer_write_newline (writer);
	} else {
		{
			GeeList* decl_collection;
			GeeIterator* decl_it;
			decl_collection = self->priv->declarators;
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaCCodeDeclarator* decl;
				decl = ((ValaCCodeDeclarator*) gee_iterator_get (decl_it));
				{
					vala_ccode_declarator_write_initialization (decl, writer);
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
}


static gboolean vala_ccode_declaration_has_initializer (ValaCCodeDeclaration* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DECLARATION (self), FALSE);
	{
		GeeList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->declarators;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaCCodeDeclarator* decl;
			decl = ((ValaCCodeDeclarator*) gee_iterator_get (decl_it));
			{
				ValaCCodeVariableDeclarator* _tmp1;
				ValaCCodeDeclarator* _tmp0;
				ValaCCodeVariableDeclarator* var_decl;
				_tmp1 = NULL;
				_tmp0 = NULL;
				var_decl = (_tmp1 = (_tmp0 = decl, (VALA_IS_CCODE_VARIABLE_DECLARATOR (_tmp0) ? ((ValaCCodeVariableDeclarator*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				if (var_decl != NULL && vala_ccode_variable_declarator_get_initializer (var_decl) == NULL) {
					gboolean _tmp2;
					return (_tmp2 = FALSE, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), (decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL))), _tmp2);
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	return TRUE;
}


static void vala_ccode_declaration_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDeclaration * self;
	gboolean first;
	self = VALA_CCODE_DECLARATION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if ((self->priv->_modifiers & (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_EXTERN)) != 0) {
		/* no separate declaration for static variables*/
		return;
	}
	vala_ccode_writer_write_indent (writer, NULL);
	if ((self->priv->_modifiers & VALA_CCODE_MODIFIERS_REGISTER) == VALA_CCODE_MODIFIERS_REGISTER) {
		vala_ccode_writer_write_string (writer, "register ");
	}
	vala_ccode_writer_write_string (writer, self->priv->_type_name);
	vala_ccode_writer_write_string (writer, " ");
	first = TRUE;
	{
		GeeList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->declarators;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaCCodeDeclarator* decl;
			decl = ((ValaCCodeDeclarator*) gee_iterator_get (decl_it));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write_declaration (VALA_CCODE_NODE (decl), writer);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_declaration_get_type_name (ValaCCodeDeclaration* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DECLARATION (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_declaration_set_type_name (ValaCCodeDeclaration* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


ValaCCodeModifiers vala_ccode_declaration_get_modifiers (ValaCCodeDeclaration* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DECLARATION (self), 0);
	return self->priv->_modifiers;
}


void vala_ccode_declaration_set_modifiers (ValaCCodeDeclaration* self, ValaCCodeModifiers value) {
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (self));
	self->priv->_modifiers = value;
}


static void vala_ccode_declaration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeDeclaration * self;
	self = VALA_CCODE_DECLARATION (object);
	switch (property_id) {
		case VALA_CCODE_DECLARATION_TYPE_NAME:
		g_value_set_string (value, vala_ccode_declaration_get_type_name (self));
		break;
		case VALA_CCODE_DECLARATION_MODIFIERS:
		g_value_set_flags (value, vala_ccode_declaration_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_declaration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeDeclaration * self;
	self = VALA_CCODE_DECLARATION (object);
	switch (property_id) {
		case VALA_CCODE_DECLARATION_TYPE_NAME:
		vala_ccode_declaration_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_DECLARATION_MODIFIERS:
		vala_ccode_declaration_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_declaration_class_init (ValaCCodeDeclarationClass * klass) {
	vala_ccode_declaration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDeclarationPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_declaration_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_declaration_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_declaration_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_declaration_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_declaration_real_write_declaration;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DECLARATION_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DECLARATION_MODIFIERS, g_param_spec_flags ("modifiers", "modifiers", "modifiers", VALA_TYPE_CCODE_MODIFIERS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_declaration_init (ValaCCodeDeclaration * self) {
	self->priv = VALA_CCODE_DECLARATION_GET_PRIVATE (self);
	self->priv->declarators = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_ccode_declaration_dispose (GObject * obj) {
	ValaCCodeDeclaration * self;
	self = VALA_CCODE_DECLARATION (obj);
	self->priv->_type_name = (g_free (self->priv->_type_name), NULL);
	(self->priv->declarators == NULL ? NULL : (self->priv->declarators = (g_object_unref (self->priv->declarators), NULL)));
	G_OBJECT_CLASS (vala_ccode_declaration_parent_class)->dispose (obj);
}


GType vala_ccode_declaration_get_type (void) {
	static GType vala_ccode_declaration_type_id = 0;
	if (G_UNLIKELY (vala_ccode_declaration_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDeclarationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_declaration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDeclaration), 0, (GInstanceInitFunc) vala_ccode_declaration_init };
		vala_ccode_declaration_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDeclaration", &g_define_type_info, 0);
	}
	return vala_ccode_declaration_type_id;
}




