/* valamethodtype.c generated by valac, the Vala compiler
 * generated from valamethodtype.vala, do not modify */

/* valamethodtype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_METHOD_TYPE (vala_method_type_get_type ())
#define VALA_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodType))
#define VALA_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))
#define VALA_IS_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_TYPE))
#define VALA_IS_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_TYPE))
#define VALA_METHOD_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))

typedef struct _ValaMethodType ValaMethodType;
typedef struct _ValaMethodTypeClass ValaMethodTypeClass;
typedef struct _ValaMethodTypePrivate ValaMethodTypePrivate;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cname) (ValaDataType* self);
	char* (*get_cdeclarator_suffix) (ValaDataType* self);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	ValaList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	ValaList* (*get_symbols) (ValaDataType* self);
	ValaSymbol* (*get_member) (ValaDataType* self, const char* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const char* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
	ValaDataType* (*get_actual_type) (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
};

struct _ValaMethodType {
	ValaDataType parent_instance;
	ValaMethodTypePrivate * priv;
};

struct _ValaMethodTypeClass {
	ValaDataTypeClass parent_class;
};

struct _ValaMethodTypePrivate {
	ValaMethod* _method_symbol;
};

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;


static gpointer vala_method_type_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_access_get_type (void) G_GNUC_CONST;
GType vala_method_type_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
#define VALA_METHOD_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_TYPE, ValaMethodTypePrivate))
enum  {
	VALA_METHOD_TYPE_DUMMY_PROPERTY
};
ValaMethodType* vala_method_type_new (ValaMethod* method_symbol);
ValaMethodType* vala_method_type_construct (GType object_type, ValaMethod* method_symbol);
ValaDataType* vala_data_type_construct (GType object_type);
void vala_method_type_set_method_symbol (ValaMethodType* self, ValaMethod* value);
static gboolean vala_method_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base);
ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
static ValaList* vala_method_type_real_get_parameters (ValaDataType* base);
ValaList* vala_method_get_parameters (ValaMethod* self);
static ValaDataType* vala_method_type_real_copy (ValaDataType* base);
static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
GType vala_delegate_type_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt);
static char* vala_method_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
char* vala_symbol_get_full_name (ValaSymbol* self);
static char* vala_method_type_real_get_cname (ValaDataType* base);
static ValaSymbol* vala_method_type_real_get_member (ValaDataType* base, const char* member_name);
gboolean vala_method_get_coroutine (ValaMethod* self);
ValaMethod* vala_method_get_callback_method (ValaMethod* self);
char* vala_method_type_to_prototype_string (ValaMethodType* self, gboolean with_type_parameters);
ValaDataType* vala_data_type_get_return_type (ValaDataType* self);
char* vala_code_node_to_string (ValaCodeNode* self);
ValaList* vala_data_type_get_parameters (ValaDataType* self);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
GType vala_parameter_direction_get_type (void) G_GNUC_CONST;
ValaParameterDirection vala_formal_parameter_get_direction (ValaFormalParameter* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
gboolean vala_data_type_is_weak (ValaDataType* self);
char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
const char* vala_symbol_get_name (ValaSymbol* self);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
static void vala_method_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaMethodType* vala_method_type_construct (GType object_type, ValaMethod* method_symbol) {
	ValaMethodType* self = NULL;
	g_return_val_if_fail (method_symbol != NULL, NULL);
	self = (ValaMethodType*) vala_data_type_construct (object_type);
	vala_method_type_set_method_symbol (self, method_symbol);
	return self;
}


ValaMethodType* vala_method_type_new (ValaMethod* method_symbol) {
	return vala_method_type_construct (VALA_TYPE_METHOD_TYPE, method_symbol);
}


static gboolean vala_method_type_real_is_invokable (ValaDataType* base) {
	ValaMethodType * self;
	gboolean result = FALSE;
	self = (ValaMethodType*) base;
	result = TRUE;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base) {
	ValaMethodType * self;
	ValaDataType* result = NULL;
	self = (ValaMethodType*) base;
	result = _vala_code_node_ref0 (vala_method_get_return_type (self->priv->_method_symbol));
	return result;
}


static ValaList* vala_method_type_real_get_parameters (ValaDataType* base) {
	ValaMethodType * self;
	ValaList* result = NULL;
	self = (ValaMethodType*) base;
	result = vala_method_get_parameters (self->priv->_method_symbol);
	return result;
}


static ValaDataType* vala_method_type_real_copy (ValaDataType* base) {
	ValaMethodType * self;
	ValaDataType* result = NULL;
	self = (ValaMethodType*) base;
	result = (ValaDataType*) vala_method_type_new (self->priv->_method_symbol);
	return result;
}


static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaMethodType * self;
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDelegateType* dt;
	self = (ValaMethodType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	dt = _vala_code_node_ref0 ((_tmp0_ = target_type, VALA_IS_DELEGATE_TYPE (_tmp0_) ? ((ValaDelegateType*) _tmp0_) : NULL));
	if (dt == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		return result;
	}
	result = vala_delegate_matches_method (vala_delegate_type_get_delegate_symbol (dt), self->priv->_method_symbol, (ValaDataType*) dt);
	_vala_code_node_unref0 (dt);
	return result;
}


static char* vala_method_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaMethodType * self;
	char* result = NULL;
	self = (ValaMethodType*) base;
	result = vala_symbol_get_full_name ((ValaSymbol*) self->priv->_method_symbol);
	return result;
}


static char* vala_method_type_real_get_cname (ValaDataType* base) {
	ValaMethodType * self;
	char* result = NULL;
	self = (ValaMethodType*) base;
	result = g_strdup ("gpointer");
	return result;
}


static ValaSymbol* vala_method_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaMethodType * self;
	ValaSymbol* result = NULL;
	gboolean _tmp0_ = FALSE;
	self = (ValaMethodType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if (vala_method_get_coroutine (self->priv->_method_symbol)) {
		_tmp0_ = _vala_strcmp0 (member_name, "begin") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _vala_code_node_ref0 ((ValaSymbol*) self->priv->_method_symbol);
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (vala_method_get_coroutine (self->priv->_method_symbol)) {
			_tmp1_ = _vala_strcmp0 (member_name, "end") == 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = _vala_code_node_ref0 ((ValaSymbol*) self->priv->_method_symbol);
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (vala_method_get_coroutine (self->priv->_method_symbol)) {
				_tmp2_ = _vala_strcmp0 (member_name, "callback") == 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = (ValaSymbol*) vala_method_get_callback_method (self->priv->_method_symbol);
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


char* vala_method_type_to_prototype_string (ValaMethodType* self, gboolean with_type_parameters) {
	char* result = NULL;
	ValaDataType* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* proto;
	gint i;
	g_return_val_if_fail (self != NULL, NULL);
	proto = (_tmp3_ = g_strdup_printf ("%s %s (", _tmp1_ = vala_code_node_to_string ((ValaCodeNode*) (_tmp0_ = vala_data_type_get_return_type ((ValaDataType*) self))), _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) self)), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _vala_code_node_unref0 (_tmp0_), _tmp3_);
	i = 1;
	{
		ValaList* _tmp4_;
		ValaIterator* _tmp5_;
		ValaIterator* _param_it;
		_param_it = (_tmp5_ = vala_iterable_iterator ((ValaIterable*) (_tmp4_ = vala_data_type_get_parameters ((ValaDataType*) self))), _vala_collection_object_unref0 (_tmp4_), _tmp5_);
		while (TRUE) {
			ValaFormalParameter* param;
			char* _tmp12_;
			char* _tmp13_;
			if (!vala_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) vala_iterator_get (_param_it);
			if (i > 1) {
				char* _tmp6_;
				proto = (_tmp6_ = g_strconcat (proto, ", ", NULL), _g_free0 (proto), _tmp6_);
			}
			if (vala_formal_parameter_get_ellipsis (param)) {
				char* _tmp7_;
				proto = (_tmp7_ = g_strconcat (proto, "...", NULL), _g_free0 (proto), _tmp7_);
				_vala_code_node_unref0 (param);
				continue;
			}
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
				if (vala_data_type_get_value_owned (vala_variable_get_variable_type ((ValaVariable*) param))) {
					char* _tmp8_;
					proto = (_tmp8_ = g_strconcat (proto, "owned ", NULL), _g_free0 (proto), _tmp8_);
				}
			} else {
				if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
					char* _tmp9_;
					proto = (_tmp9_ = g_strconcat (proto, "ref ", NULL), _g_free0 (proto), _tmp9_);
				} else {
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						char* _tmp10_;
						proto = (_tmp10_ = g_strconcat (proto, "out ", NULL), _g_free0 (proto), _tmp10_);
					}
				}
				if (vala_data_type_is_weak (vala_variable_get_variable_type ((ValaVariable*) param))) {
					char* _tmp11_;
					proto = (_tmp11_ = g_strconcat (proto, "unowned ", NULL), _g_free0 (proto), _tmp11_);
				}
			}
			proto = (_tmp13_ = g_strdup_printf ("%s%s %s", proto, _tmp12_ = vala_data_type_to_qualified_string (vala_variable_get_variable_type ((ValaVariable*) param), NULL), vala_symbol_get_name ((ValaSymbol*) param)), _g_free0 (proto), _tmp13_);
			_g_free0 (_tmp12_);
			if (vala_variable_get_initializer ((ValaVariable*) param) != NULL) {
				char* _tmp14_;
				char* _tmp15_;
				proto = (_tmp15_ = g_strdup_printf ("%s = %s", proto, _tmp14_ = vala_code_node_to_string ((ValaCodeNode*) vala_variable_get_initializer ((ValaVariable*) param))), _g_free0 (proto), _tmp15_);
				_g_free0 (_tmp14_);
			}
			i++;
			_vala_code_node_unref0 (param);
		}
		_vala_collection_object_unref0 (_param_it);
	}
	result = g_strconcat (proto, ")", NULL);
	_g_free0 (proto);
	return result;
}


ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_method_symbol;
	return result;
}


void vala_method_type_set_method_symbol (ValaMethodType* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_method_symbol = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_method_symbol), _tmp0_);
}


static void vala_method_type_class_init (ValaMethodTypeClass * klass) {
	vala_method_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_method_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_method_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_method_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_method_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_method_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_method_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_method_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_method_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_method_type_real_get_member;
}


static void vala_method_type_instance_init (ValaMethodType * self) {
	self->priv = VALA_METHOD_TYPE_GET_PRIVATE (self);
}


static void vala_method_type_finalize (ValaCodeNode* obj) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (obj);
	_vala_code_node_unref0 (self->priv->_method_symbol);
	VALA_CODE_NODE_CLASS (vala_method_type_parent_class)->finalize (obj);
}


/**
 * The type of a method referencea.
 */
GType vala_method_type_get_type (void) {
	static volatile gsize vala_method_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodType), 0, (GInstanceInitFunc) vala_method_type_instance_init, NULL };
		GType vala_method_type_type_id;
		vala_method_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaMethodType", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_type_type_id__volatile, vala_method_type_type_id);
	}
	return vala_method_type_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




