/* rygel-user-config.c generated by valac, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

struct _RygelUserConfigPrivate {
	gboolean read_only;
	DBusGProxy* dbus_obj;
	DBusGProxy* rygel_obj;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static gpointer rygel_user_config_parent_class = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void);
GType rygel_configuration_get_type (void);
GType rygel_user_config_get_type (void);
#define RYGEL_USER_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_USER_CONFIG, RygelUserConfigPrivate))
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_LOG_LEVEL_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_DBUS_SERVICE "org.freedesktop.DBus"
#define RYGEL_USER_CONFIG_DBUS_PATH "/org/freedesktop/DBus"
#define RYGEL_USER_CONFIG_DBUS_INTERFACE "org.freedesktop.DBus"
#define RYGEL_USER_CONFIG_RYGEL_SERVICE "org.gnome.Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_PATH "/org/gnome/Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_INTERFACE "org.gnome.Rygel1"
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const char* section, const char* key, GError** error);
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable);
void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value);
char* rygel_configuration_get_string (RygelConfiguration* self, const char* section, const char* key, GError** error);
static char* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
void rygel_user_config_set_string (RygelUserConfig* self, const char* section, const char* key, const char* value);
void rygel_user_config_set_interface (RygelUserConfig* self, const char* value);
gint rygel_configuration_get_int (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
void rygel_user_config_set_int (RygelUserConfig* self, const char* section, const char* key, gint value);
void rygel_user_config_set_port (RygelUserConfig* self, gint value);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
void rygel_user_config_set_bool (RygelUserConfig* self, const char* section, const char* key, gboolean value);
void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value);
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error);
static char* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
void rygel_user_config_save (RygelUserConfig* self);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error);
static char* rygel_user_config_real_get_title (RygelConfiguration* base, const char* section, GError** error);
GQuark rygel_configuration_error_quark (void);
static char* rygel_user_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error);
void rygel_user_config_set_string_list (RygelUserConfig* self, const char* section, const char* key, GeeArrayList* str_list);
static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const char* dir_path, GError** error);
static void _dynamic_StartServiceByName0 (DBusGProxy* self, const char* param1, guint32 param2, guint32* param3, GError** error);
static void _dynamic_Shutdown1 (DBusGProxy* self, GError** error);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 63 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
#line 201 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 64 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 210 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 64 "rygel-user-config.vala"
	return result;
#line 218 "rygel-user-config.c"
}


#line 67 "rygel-user-config.vala"
void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value) {
#line 224 "rygel-user-config.c"
	GError * _inner_error_;
	gboolean enabled;
#line 67 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 229 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 68 "rygel-user-config.vala"
	enabled = FALSE;
#line 233 "rygel-user-config.c"
	{
		gboolean _tmp0_;
#line 71 "rygel-user-config.vala"
		_tmp0_ = rygel_configuration_get_upnp_enabled ((RygelConfiguration*) self, &_inner_error_);
#line 238 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
#line 71 "rygel-user-config.vala"
		enabled = _tmp0_;
#line 244 "rygel-user-config.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 74 "rygel-user-config.vala"
	if (value != enabled) {
#line 75 "rygel-user-config.vala"
		rygel_user_config_enable_upnp (self, value);
#line 266 "rygel-user-config.c"
	}
}


#line 79 "rygel-user-config.vala"
static char* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
#line 273 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 80 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
#line 282 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 80 "rygel-user-config.vala"
	return result;
#line 290 "rygel-user-config.c"
}


#line 83 "rygel-user-config.vala"
void rygel_user_config_set_interface (RygelUserConfig* self, const char* value) {
#line 83 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 83 "rygel-user-config.vala"
	g_return_if_fail (value != NULL);
#line 84 "rygel-user-config.vala"
	rygel_user_config_set_string (self, "general", RYGEL_USER_CONFIG_IFACE_KEY, value);
#line 302 "rygel-user-config.c"
}


#line 87 "rygel-user-config.vala"
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
#line 308 "rygel-user-config.c"
	RygelUserConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 88 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PORT_KEY, (gint) 0U, (gint) G_MAXUINT16, &_inner_error_);
#line 317 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
#line 88 "rygel-user-config.vala"
	return result;
#line 325 "rygel-user-config.c"
}


#line 91 "rygel-user-config.vala"
void rygel_user_config_set_port (RygelUserConfig* self, gint value) {
#line 91 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 92 "rygel-user-config.vala"
	rygel_user_config_set_int (self, "general", RYGEL_USER_CONFIG_PORT_KEY, value);
#line 335 "rygel-user-config.c"
}


#line 95 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
#line 341 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 96 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
#line 350 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 96 "rygel-user-config.vala"
	return result;
#line 358 "rygel-user-config.c"
}


#line 99 "rygel-user-config.vala"
void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value) {
#line 99 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 100 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, value);
#line 368 "rygel-user-config.c"
}


#line 103 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
#line 374 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 104 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, &_inner_error_);
#line 383 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 104 "rygel-user-config.vala"
	return result;
#line 391 "rygel-user-config.c"
}


#line 107 "rygel-user-config.vala"
void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value) {
#line 107 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 108 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, value);
#line 401 "rygel-user-config.c"
}


#line 111 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
#line 407 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 112 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, &_inner_error_);
#line 416 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 112 "rygel-user-config.vala"
	return result;
#line 424 "rygel-user-config.c"
}


#line 115 "rygel-user-config.vala"
void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value) {
#line 115 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 116 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, value);
#line 434 "rygel-user-config.c"
}


#line 119 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
#line 440 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 120 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, &_inner_error_);
#line 449 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 120 "rygel-user-config.vala"
	return result;
#line 457 "rygel-user-config.c"
}


#line 123 "rygel-user-config.vala"
void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value) {
#line 123 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 124 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, value);
#line 467 "rygel-user-config.c"
}


#line 127 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
#line 473 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 128 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, &_inner_error_);
#line 482 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 128 "rygel-user-config.vala"
	return result;
#line 490 "rygel-user-config.c"
}


#line 131 "rygel-user-config.vala"
void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value) {
#line 131 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 132 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, value);
#line 500 "rygel-user-config.c"
}


#line 135 "rygel-user-config.vala"
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error) {
#line 506 "rygel-user-config.c"
	RygelUserConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 136 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LOG_LEVEL_KEY, (gint) RYGEL_LOG_LEVEL_INVALID, (gint) RYGEL_LOG_LEVEL_DEBUG, &_inner_error_);
#line 515 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = (RygelLogLevel) _tmp0_;
#line 136 "rygel-user-config.vala"
	return result;
#line 523 "rygel-user-config.c"
}


#line 142 "rygel-user-config.vala"
static char* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
#line 529 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 143 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
#line 538 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 143 "rygel-user-config.vala"
	return result;
#line 546 "rygel-user-config.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 146 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_get_default (GError** error) {
#line 557 "rygel-user-config.c"
	RygelUserConfig* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 147 "rygel-user-config.vala"
	if (rygel_user_config_config == NULL) {
#line 563 "rygel-user-config.c"
		RygelUserConfig* _tmp0_;
		RygelUserConfig* _tmp1_;
#line 148 "rygel-user-config.vala"
		_tmp0_ = rygel_user_config_new (TRUE, &_inner_error_);
#line 568 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
#line 148 "rygel-user-config.vala"
		rygel_user_config_config = (_tmp1_ = _tmp0_, _g_object_unref0 (rygel_user_config_config), _tmp1_);
#line 575 "rygel-user-config.c"
	}
	result = _g_object_ref0 (rygel_user_config_config);
#line 151 "rygel-user-config.vala"
	return result;
#line 580 "rygel-user-config.c"
}


#line 154 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error) {
#line 586 "rygel-user-config.c"
	GError * _inner_error_;
	RygelUserConfig * self;
	GKeyFile* _tmp0_;
	char** _tmp1_;
	gint _dirs_size_;
	gint dirs_length1;
	char** dirs;
	char* _tmp2_;
	char* _tmp3_;
	char* path;
	char* _tmp5_;
	char* _tmp4_ = NULL;
	_inner_error_ = NULL;
#line 154 "rygel-user-config.vala"
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
#line 155 "rygel-user-config.vala"
	self->priv->read_only = read_only;
#line 156 "rygel-user-config.vala"
	self->key_file = (_tmp0_ = g_key_file_new (), _g_key_file_free0 (self->key_file), _tmp0_);
#line 606 "rygel-user-config.c"
	dirs = (_tmp1_ = g_new0 (char*, 2 + 1), dirs_length1 = 2, _dirs_size_ = dirs_length1, _tmp1_);
#line 159 "rygel-user-config.vala"
	dirs[0] = (_tmp2_ = g_strdup (g_get_user_config_dir ()), _g_free0 (dirs[0]), _tmp2_);
#line 160 "rygel-user-config.vala"
	dirs[1] = (_tmp3_ = g_strdup (SYS_CONFIG_DIR), _g_free0 (dirs[1]), _tmp3_);
#line 612 "rygel-user-config.c"
	path = NULL;
#line 163 "rygel-user-config.vala"
	g_key_file_load_from_dirs (self->key_file, RYGEL_USER_CONFIG_CONFIG_FILE, dirs, &_tmp4_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 163 "rygel-user-config.vala"
	path = (_tmp5_ = _tmp4_, _g_free0 (path), _tmp5_);
#line 618 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (path);
		g_object_unref (self);
		return NULL;
	}
#line 168 "rygel-user-config.vala"
	g_debug (_ ("Loaded user configuration from file '%s'"), path);
#line 628 "rygel-user-config.c"
	{
		DBusGConnection* connection;
		DBusGProxy* _tmp6_;
		DBusGProxy* _tmp7_;
#line 171 "rygel-user-config.vala"
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 635 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 174 "rygel-user-config.vala"
		self->priv->rygel_obj = (_tmp6_ = dbus_g_proxy_new_for_name (connection, RYGEL_USER_CONFIG_RYGEL_SERVICE, RYGEL_USER_CONFIG_RYGEL_PATH, RYGEL_USER_CONFIG_RYGEL_INTERFACE), _g_object_unref0 (self->priv->rygel_obj), _tmp6_);
#line 178 "rygel-user-config.vala"
		self->priv->dbus_obj = (_tmp7_ = dbus_g_proxy_new_for_name (connection, RYGEL_USER_CONFIG_DBUS_SERVICE, RYGEL_USER_CONFIG_DBUS_PATH, RYGEL_USER_CONFIG_DBUS_INTERFACE), _g_object_unref0 (self->priv->dbus_obj), _tmp7_);
#line 650 "rygel-user-config.c"
		_dbus_g_connection_unref0 (connection);
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 182 "rygel-user-config.vala"
			g_debug (_ ("Failed to connect to session bus: %s"), err->message);
#line 662 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (path);
		g_object_unref (self);
		return NULL;
	}
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	return self;
}


#line 154 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error) {
#line 154 "rygel-user-config.vala"
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, read_only, error);
#line 684 "rygel-user-config.c"
}


#line 186 "rygel-user-config.vala"
void rygel_user_config_save (RygelUserConfig* self) {
#line 690 "rygel-user-config.c"
	GError * _inner_error_;
	char* path;
	gsize length = 0UL;
	char* data;
#line 186 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 697 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 187 "rygel-user-config.vala"
	g_return_if_fail (!self->priv->read_only);
#line 190 "rygel-user-config.vala"
	path = g_build_filename (g_get_user_config_dir (), RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 194 "rygel-user-config.vala"
	data = g_key_file_to_data (self->key_file, &length, NULL);
#line 705 "rygel-user-config.c"
	{
#line 197 "rygel-user-config.vala"
		g_file_set_contents (path, data, (gssize) ((glong) length), &_inner_error_);
#line 709 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 199 "rygel-user-config.vala"
			g_critical (_ ("Failed to save configuration data to file '%s': %s"), path, err->message);
#line 730 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
	_g_free0 (data);
}


#line 205 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error) {
#line 749 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
#line 205 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 757 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 206 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 761 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 206 "rygel-user-config.vala"
	return result;
#line 769 "rygel-user-config.c"
}


#line 209 "rygel-user-config.vala"
static char* rygel_user_config_real_get_title (RygelConfiguration* base, const char* section, GError** error) {
#line 775 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelUserConfig*) base;
#line 209 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 783 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 210 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
#line 787 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 210 "rygel-user-config.vala"
	return result;
#line 795 "rygel-user-config.c"
}


#line 213 "rygel-user-config.vala"
static char* rygel_user_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 801 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* val;
	gboolean _tmp0_ = FALSE;
	self = (RygelUserConfig*) base;
#line 213 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 213 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 812 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 215 "rygel-user-config.vala"
	val = g_key_file_get_string (self->key_file, section, key, &_inner_error_);
#line 816 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 217 "rygel-user-config.vala"
	if (val == NULL) {
#line 217 "rygel-user-config.vala"
		_tmp0_ = TRUE;
#line 825 "rygel-user-config.c"
	} else {
#line 217 "rygel-user-config.vala"
		_tmp0_ = _vala_strcmp0 (val, "") == 0;
#line 829 "rygel-user-config.c"
	}
#line 217 "rygel-user-config.vala"
	if (_tmp0_) {
#line 833 "rygel-user-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available for '%s'"), key);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return NULL;
		}
	}
	result = val;
#line 223 "rygel-user-config.vala"
	return result;
#line 844 "rygel-user-config.c"
}


#line 226 "rygel-user-config.vala"
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 850 "rygel-user-config.c"
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* str_list;
	char** _tmp1_;
	gint _strings_size_;
	gint strings_length1;
	gsize _tmp0_;
	char** strings;
	self = (RygelUserConfig*) base;
#line 226 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 226 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 865 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 229 "rygel-user-config.vala"
	str_list = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 869 "rygel-user-config.c"
	strings = (_tmp1_ = g_key_file_get_string_list (self->key_file, section, key, &_tmp0_, &_inner_error_), strings_length1 = _tmp0_, _strings_size_ = strings_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (str_list);
		return NULL;
	}
	{
		char** str_collection;
		int str_collection_length1;
		int str_it;
#line 232 "rygel-user-config.vala"
		str_collection = strings;
#line 882 "rygel-user-config.c"
		str_collection_length1 = strings_length1;
		for (str_it = 0; str_it < strings_length1; str_it = str_it + 1) {
			char* str;
			str = g_strdup (str_collection[str_it]);
			{
#line 233 "rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) str_list, str);
#line 890 "rygel-user-config.c"
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 236 "rygel-user-config.vala"
	return result;
#line 899 "rygel-user-config.c"
}


#line 239 "rygel-user-config.vala"
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error) {
#line 905 "rygel-user-config.c"
	RygelUserConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint val;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (RygelUserConfig*) base;
#line 239 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 239 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 917 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 244 "rygel-user-config.vala"
	val = g_key_file_get_integer (self->key_file, section, key, &_inner_error_);
#line 921 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
#line 246 "rygel-user-config.vala"
	if (val == 0) {
#line 246 "rygel-user-config.vala"
		_tmp1_ = TRUE;
#line 930 "rygel-user-config.c"
	} else {
#line 246 "rygel-user-config.vala"
		_tmp1_ = val < min;
#line 934 "rygel-user-config.c"
	}
#line 246 "rygel-user-config.vala"
	if (_tmp1_) {
#line 246 "rygel-user-config.vala"
		_tmp0_ = TRUE;
#line 940 "rygel-user-config.c"
	} else {
#line 246 "rygel-user-config.vala"
		_tmp0_ = val > max;
#line 944 "rygel-user-config.c"
	}
#line 246 "rygel-user-config.vala"
	if (_tmp0_) {
#line 948 "rygel-user-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _ ("Value of '%s' out of range"), key);
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = val;
#line 252 "rygel-user-config.vala"
	return result;
#line 958 "rygel-user-config.c"
}


#line 255 "rygel-user-config.vala"
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 964 "rygel-user-config.c"
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* int_list;
	gint* _tmp1_;
	gint _ints_size_;
	gint ints_length1;
	gsize _tmp0_;
	gint* ints;
	self = (RygelUserConfig*) base;
#line 255 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 255 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 979 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 258 "rygel-user-config.vala"
	int_list = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
#line 983 "rygel-user-config.c"
	ints = (_tmp1_ = g_key_file_get_integer_list (self->key_file, section, key, &_tmp0_, &_inner_error_), ints_length1 = _tmp0_, _ints_size_ = ints_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (int_list);
		return NULL;
	}
	{
		gint* num_collection;
		int num_collection_length1;
		int num_it;
#line 261 "rygel-user-config.vala"
		num_collection = ints;
#line 996 "rygel-user-config.c"
		num_collection_length1 = ints_length1;
		for (num_it = 0; num_it < ints_length1; num_it = num_it + 1) {
			gint num;
			num = num_collection[num_it];
			{
#line 262 "rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) int_list, GINT_TO_POINTER (num));
#line 1004 "rygel-user-config.c"
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
#line 265 "rygel-user-config.vala"
	return result;
#line 1012 "rygel-user-config.c"
}


#line 268 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1018 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
#line 268 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 268 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1028 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 271 "rygel-user-config.vala"
	_tmp0_ = g_key_file_get_boolean (self->key_file, section, key, &_inner_error_);
#line 1032 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 271 "rygel-user-config.vala"
	return result;
#line 1040 "rygel-user-config.c"
}


#line 274 "rygel-user-config.vala"
void rygel_user_config_set_string (RygelUserConfig* self, const char* section, const char* key, const char* value) {
#line 274 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 274 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 274 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 274 "rygel-user-config.vala"
	g_return_if_fail (value != NULL);
#line 277 "rygel-user-config.vala"
	g_key_file_set_string (self->key_file, section, key, value);
#line 1056 "rygel-user-config.c"
}


#line 280 "rygel-user-config.vala"
void rygel_user_config_set_string_list (RygelUserConfig* self, const char* section, const char* key, GeeArrayList* str_list) {
#line 1062 "rygel-user-config.c"
	char** _tmp1_;
	gint _strings_size_;
	gint strings_length1;
	gint _tmp0_;
	char** strings;
	gint i;
#line 280 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 280 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 280 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 280 "rygel-user-config.vala"
	g_return_if_fail (str_list != NULL);
#line 1077 "rygel-user-config.c"
	strings = (_tmp1_ = g_new0 (char*, (_tmp0_ = gee_collection_get_size ((GeeCollection*) str_list)) + 1), strings_length1 = _tmp0_, _strings_size_ = strings_length1, _tmp1_);
#line 285 "rygel-user-config.vala"
	i = 0;
#line 1081 "rygel-user-config.c"
	{
		GeeIterator* _str_it;
		_str_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) str_list);
#line 287 "rygel-user-config.vala"
		while (TRUE) {
#line 1087 "rygel-user-config.c"
			char* str;
#line 287 "rygel-user-config.vala"
			if (!gee_iterator_next (_str_it)) {
#line 287 "rygel-user-config.vala"
				break;
#line 1093 "rygel-user-config.c"
			}
#line 287 "rygel-user-config.vala"
			str = (char*) gee_iterator_get (_str_it);
#line 288 "rygel-user-config.vala"
			if (_vala_strcmp0 (str, "") != 0) {
#line 1099 "rygel-user-config.c"
				char* _tmp3_;
				char* *_tmp2_;
#line 289 "rygel-user-config.vala"
				_tmp2_ = &strings[i++];
#line 289 "rygel-user-config.vala"
				(*_tmp2_) = (_tmp3_ = g_strdup (str), _g_free0 ((*_tmp2_)), _tmp3_);
#line 1106 "rygel-user-config.c"
			}
			_g_free0 (str);
		}
		_g_object_unref0 (_str_it);
	}
#line 293 "rygel-user-config.vala"
	g_key_file_set_string_list (self->key_file, section, key, strings, strings_length1);
#line 1114 "rygel-user-config.c"
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
}


#line 296 "rygel-user-config.vala"
void rygel_user_config_set_int (RygelUserConfig* self, const char* section, const char* key, gint value) {
#line 296 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 296 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 296 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 299 "rygel-user-config.vala"
	g_key_file_set_integer (self->key_file, section, key, value);
#line 1129 "rygel-user-config.c"
}


#line 302 "rygel-user-config.vala"
void rygel_user_config_set_bool (RygelUserConfig* self, const char* section, const char* key, gboolean value) {
#line 302 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 302 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 302 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 305 "rygel-user-config.vala"
	g_key_file_set_boolean (self->key_file, section, key, value);
#line 1143 "rygel-user-config.c"
}


static void _dynamic_StartServiceByName0 (DBusGProxy* self, const char* param1, guint32 param2, guint32* param3, GError** error) {
	dbus_g_proxy_call (self, "StartServiceByName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, param3, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void _dynamic_Shutdown1 (DBusGProxy* self, GError** error) {
	dbus_g_proxy_call (self, "Shutdown", error, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


#line 308 "rygel-user-config.vala"
static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable) {
#line 1165 "rygel-user-config.c"
	GError * _inner_error_;
	char* dest_dir;
#line 308 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 1170 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 309 "rygel-user-config.vala"
	dest_dir = g_build_filename (g_get_user_config_dir (), "autostart", NULL);
#line 1174 "rygel-user-config.c"
	{
		char* dest_path;
		GFile* dest;
#line 312 "rygel-user-config.vala"
		rygel_user_config_ensure_dir_exists (self, dest_dir, &_inner_error_);
#line 1180 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
#line 314 "rygel-user-config.vala"
		dest_path = g_build_filename (dest_dir, "rygel.desktop", NULL);
#line 315 "rygel-user-config.vala"
		dest = g_file_new_for_path (dest_path);
#line 317 "rygel-user-config.vala"
		if (enable) {
#line 1190 "rygel-user-config.c"
			guint32 res = 0U;
			char* source_path;
#line 321 "rygel-user-config.vala"
			if (self->priv->dbus_obj != NULL) {
#line 322 "rygel-user-config.vala"
				_dynamic_StartServiceByName0 (self->priv->dbus_obj, RYGEL_USER_CONFIG_RYGEL_SERVICE, (guint32) 0, &res, &_inner_error_);
#line 1197 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					_g_free0 (dest_path);
					_g_object_unref0 (dest);
					goto __catch3_g_error;
				}
			}
#line 328 "rygel-user-config.vala"
			source_path = g_build_filename (DESKTOP_DIR, "rygel.desktop", NULL);
#line 1206 "rygel-user-config.c"
			{
#line 331 "rygel-user-config.vala"
				g_file_make_symbolic_link (dest, source_path, NULL, &_inner_error_);
#line 1210 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						goto __catch4_g_io_error_exists;
					}
					goto __finally4;
				}
			}
			goto __finally4;
			__catch4_g_io_error_exists:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (source_path);
				_g_free0 (dest_path);
				_g_object_unref0 (dest);
				goto __catch3_g_error;
			}
#line 334 "rygel-user-config.vala"
			rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, TRUE);
#line 1237 "rygel-user-config.c"
			_g_free0 (source_path);
		} else {
#line 337 "rygel-user-config.vala"
			if (self->priv->rygel_obj != NULL) {
#line 338 "rygel-user-config.vala"
				_dynamic_Shutdown1 (self->priv->rygel_obj, &_inner_error_);
#line 1244 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					_g_free0 (dest_path);
					_g_object_unref0 (dest);
					goto __catch3_g_error;
				}
			}
			{
#line 343 "rygel-user-config.vala"
				g_file_delete (dest, NULL, &_inner_error_);
#line 1254 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						goto __catch5_g_io_error_not_found;
					}
					goto __finally5;
				}
			}
			goto __finally5;
			__catch5_g_io_error_not_found:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (dest_path);
				_g_object_unref0 (dest);
				goto __catch3_g_error;
			}
#line 346 "rygel-user-config.vala"
			rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, FALSE);
#line 1280 "rygel-user-config.c"
		}
		_g_free0 (dest_path);
		_g_object_unref0 (dest);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			const char* _tmp0_;
			_tmp0_ = NULL;
#line 351 "rygel-user-config.vala"
			if (enable) {
#line 351 "rygel-user-config.vala"
				_tmp0_ = "start";
#line 1298 "rygel-user-config.c"
			} else {
#line 351 "rygel-user-config.vala"
				_tmp0_ = "stop";
#line 1302 "rygel-user-config.c"
			}
#line 350 "rygel-user-config.vala"
			g_warning (_ ("Failed to %s Rygel service: %s"), _tmp0_, err->message);
#line 1306 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (dest_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (dest_dir);
}


#line 356 "rygel-user-config.vala"
static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const char* dir_path, GError** error) {
#line 1323 "rygel-user-config.c"
	GError * _inner_error_;
	GFile* dir;
#line 356 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 356 "rygel-user-config.vala"
	g_return_if_fail (dir_path != NULL);
#line 1330 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 357 "rygel-user-config.vala"
	dir = g_file_new_for_path (dir_path);
#line 1334 "rygel-user-config.c"
	{
#line 360 "rygel-user-config.vala"
		g_file_make_directory (dir, NULL, &_inner_error_);
#line 1338 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch6_g_io_error_exists;
			}
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_io_error_exists:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	_g_object_unref0 (dir);
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelUserConfigPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = rygel_user_config_real_get_upnp_enabled;
	iface->get_interface = rygel_user_config_real_get_interface;
	iface->get_port = rygel_user_config_real_get_port;
	iface->get_transcoding = rygel_user_config_real_get_transcoding;
	iface->get_mp3_transcoder = rygel_user_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = rygel_user_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = rygel_user_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = rygel_user_config_real_get_wmv_transcoder;
	iface->get_log_level = rygel_user_config_real_get_log_level;
	iface->get_plugin_path = rygel_user_config_real_get_plugin_path;
	iface->get_enabled = rygel_user_config_real_get_enabled;
	iface->get_title = rygel_user_config_real_get_title;
	iface->get_string = rygel_user_config_real_get_string;
	iface->get_string_list = rygel_user_config_real_get_string_list;
	iface->get_int = rygel_user_config_real_get_int;
	iface->get_int_list = rygel_user_config_real_get_int_list;
	iface->get_bool = rygel_user_config_real_get_bool;
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
	self->priv = RYGEL_USER_CONFIG_GET_PRIVATE (self);
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
	self = RYGEL_USER_CONFIG (obj);
	_g_key_file_free0 (self->key_file);
	_g_object_unref0 (self->priv->dbus_obj);
	_g_object_unref0 (self->priv->rygel_obj);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}


GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




