/* rygel-thumbnailer.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
	gchar* directory;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, GError** error);
static void rygel_thumbnailer_finalize (GObject* obj);


GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
	RygelThumbnailer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	GFile* _tmp2_ = NULL;
	GFile* file;
	RygelThumbnail* _tmp3_ = NULL;
	gboolean _tmp4_;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ".thumbnails", "cropped", NULL);
	dir = _tmp1_;
	_tmp2_ = g_file_new_for_path (dir);
	file = _tmp2_;
	_tmp3_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	_rygel_icon_info_unref0 (self->priv->template);
	self->priv->template = _tmp3_;
	_tmp4_ = g_file_query_exists (file, NULL);
	if (!_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gboolean _tmp8_;
		_tmp5_ = g_get_home_dir ();
		_tmp6_ = g_build_filename (_tmp5_, ".thumbnails", "normal", NULL);
		_g_free0 (dir);
		dir = _tmp6_;
		_tmp7_ = g_file_new_for_path (dir);
		_g_object_unref0 (file);
		file = _tmp7_;
		_tmp8_ = g_file_query_exists (file, NULL);
		if (!_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* message;
			GError* _tmp11_ = NULL;
			_tmp9_ = _ ("Failed to find thumbnails folder.");
			_tmp10_ = g_strdup (_tmp9_);
			message = _tmp10_;
			_tmp11_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_DIR, message);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == THUMBNAILER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_object_unref0 (file);
				_g_free0 (dir);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (message);
				_g_object_unref0 (file);
				_g_free0 (dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (message);
		} else {
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = g_strdup ("image/png");
			_g_free0 (((RygelIconInfo*) self->priv->template)->mime_type);
			((RygelIconInfo*) self->priv->template)->mime_type = _tmp12_;
			_tmp13_ = g_strdup ("PNG_TN");
			_g_free0 (self->priv->template->dlna_profile);
			self->priv->template->dlna_profile = _tmp13_;
			((RygelIconInfo*) self->priv->template)->width = 128;
			((RygelIconInfo*) self->priv->template)->height = 128;
			((RygelIconInfo*) self->priv->template)->depth = 32;
			_tmp14_ = g_strdup (".png");
			_g_free0 (self->priv->extension);
			self->priv->extension = _tmp14_;
		}
	} else {
		gchar* _tmp15_;
		((RygelIconInfo*) self->priv->template)->width = 124;
		((RygelIconInfo*) self->priv->template)->height = 124;
		((RygelIconInfo*) self->priv->template)->depth = 24;
		_tmp15_ = g_strdup (".jpeg");
		_g_free0 (self->priv->extension);
		self->priv->extension = _tmp15_;
	}
	_tmp16_ = g_strdup (dir);
	_g_free0 (self->directory);
	self->directory = _tmp16_;
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelThumbnailer* rygel_thumbnailer_get_default (void) {
	RygelThumbnailer* result = NULL;
	RygelThumbnailer* _tmp3_;
	GError * _inner_error_ = NULL;
	if (rygel_thumbnailer_first_time) {
		RygelThumbnailer* _tmp0_ = NULL;
		RygelThumbnailer* _tmp1_;
		_tmp0_ = rygel_thumbnailer_new (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == THUMBNAILER_ERROR) {
				goto __catch51_thumbnailer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (rygel_thumbnailer_thumbnailer);
		rygel_thumbnailer_thumbnailer = _tmp1_;
		goto __finally51;
		__catch51_thumbnailer_error:
		{
			GError * err;
			const gchar* _tmp2_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = _ ("No thumbnailer available: %s");
			g_warning (_tmp2_, err->message);
			_g_error_free0 (err);
		}
		__finally51:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		rygel_thumbnailer_first_time = FALSE;
	}
	_tmp3_ = _g_object_ref0 (rygel_thumbnailer_thumbnailer);
	result = _tmp3_;
	return result;
}


RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* thumbnail;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* path;
	gchar* _tmp4_ = NULL;
	gchar* full_path;
	GFile* _tmp5_ = NULL;
	GFile* file;
	GFileInfo* _tmp6_ = NULL;
	GFileInfo* info;
	gboolean _tmp7_;
	RygelThumbnail* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	guint64 _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	thumbnail = NULL;
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, uri, (gsize) (-1));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, self->priv->extension, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	path = _tmp3_;
	_tmp4_ = g_build_filename (self->directory, path, NULL);
	full_path = _tmp4_;
	_tmp5_ = g_file_new_for_path (full_path);
	file = _tmp5_;
	_tmp6_ = g_file_query_info (file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_tmp7_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp7_) {
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp8_ = _ ("No thumbnail available");
		_tmp9_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_tmp10_ = rygel_thumbnail_new (((RygelIconInfo*) self->priv->template)->mime_type, self->priv->template->dlna_profile, ((RygelIconInfo*) self->priv->template)->file_extension);
	_rygel_icon_info_unref0 (thumbnail);
	thumbnail = _tmp10_;
	((RygelIconInfo*) thumbnail)->width = ((RygelIconInfo*) self->priv->template)->width;
	((RygelIconInfo*) thumbnail)->height = ((RygelIconInfo*) self->priv->template)->height;
	((RygelIconInfo*) thumbnail)->depth = ((RygelIconInfo*) self->priv->template)->depth;
	_tmp11_ = g_filename_to_uri (full_path, NULL, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
	_g_free0 (((RygelIconInfo*) thumbnail)->uri);
	((RygelIconInfo*) thumbnail)->uri = _tmp12_;
	_tmp13_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	((RygelIconInfo*) thumbnail)->size = (gint64) _tmp13_;
	result = thumbnail;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	_g_free0 (full_path);
	_g_free0 (path);
	return result;
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
	self = RYGEL_THUMBNAILER (obj);
	_g_free0 (self->directory);
	_rygel_icon_info_unref0 (self->priv->template);
	_g_free0 (self->priv->extension);
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
}


/**
 * Provides thumbnails for images and vidoes.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



