// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 4 -*-

/*
 *  PaperBox - document-tile.hh
 *
 *  Copyright (C) 2007 Marko Anastasov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PAPER_BOX_DOCUMENT_TILE_HH__
#define __PAPER_BOX_DOCUMENT_TILE_HH__

#include <map>
#include <string>
#include <boost/shared_ptr.hpp>
#include <gtkmm/button.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/linkbutton.h>
#include <gtkmm-utils/tile.h>
#include "document.hh"
#include "tag-link-button.hh"
#include "thumbnailer.hh"

namespace paperbox {

    // Definition of the hash map where we'll store dynamically created
    // tag link widgets. Thus we use one widget per tag.
    typedef std::map<std::string,
                     boost::shared_ptr<Gtk::Widget>,
                     std::less<std::string> >
    tag_link_map;

    class DocumentTile : public Gtk::Util::Tile
    {
    public:
        typedef sigc::signal<void, const Glib::ustring&> SignalTagClicked;

        explicit DocumentTile(Thumbnailer& thumbnailer,
                              const boost::shared_ptr<Document>& doc);
        ~DocumentTile();

        virtual Glib::ustring get_document_uri() const;
        virtual std::string   get_document_uri_raw() const;

        // The signal that forwards the event of clicking on a tag
        // within the tile to the view (DocumentTileView).
        SignalTagClicked& signal_tag_clicked();

        // Hides additional containers and widgets.
        void hide_extra_info();

    protected:
        virtual void connect_thumbnailer_signals(Thumbnailer& thumbnailer);
        virtual void connect_signals();

        virtual Gtk::Widget* get_tag_link(const std::string& tag);

        virtual void pack_tag_links();
        virtual void unpack_tag_links();

        virtual void refresh_tag_links(
            const std::vector<Glib::ustring>& tags_added,
            const std::vector<Glib::ustring>& tags_removed);

        // Tile overrides
        virtual void on_selected();
        virtual void on_unselected();

        // Browser's signal handler
        void on_tags_changed(const std::string& uri,
                             const std::vector<Glib::ustring>& tags_added,
                             const std::vector<Glib::ustring>& tags_removed);

        // Handler for Thumbnailer's signal
        void on_large_thumbnail_ready(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
        void on_small_thumbnail_ready(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

        // Handler for the "+" button for adding tags
        virtual void on_tag_add_clicked();

        // Handler for all linkbutton tag clicks
        virtual void on_taglink(Gtk::LinkButton* button,
                                const Glib::ustring& uri);

        virtual void on_tag_link_tag_remove_request(const Glib::ustring& tag);

        Glib::ustring uri_;

        SignalTagClicked signal_tag_clicked_;

        Glib::RefPtr<Gdk::Pixbuf> thumbnail_small_;
        Glib::RefPtr<Gdk::Pixbuf> thumbnail_large_;
        Gtk::HBox   extra_hbox_;
        Gtk::Label  pages_label_;
        Gtk::HBox   time_hbox_;
        Gtk::Label  modtime_label_;
        Gtk::HBox   tag_hbox_;
        Gtk::HBox   tag_tools_hbox_;
        Gtk::Label  tags_caption_;
        Gtk::Button button_add_tags_;
        Gtk::Image  image_add_;

        tag_link_map tag_links_;

        bool first_boot_;
    };

} // namespace paperbox

#endif // __PAPER_BOX_DOCUMENT_TILE_HH__
