//  Copyright (C) 2008-2009 Andoni Morales Alastruey
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//

namespace LongoMatch.Video.Handlers {

	using System;

	public delegate void TickHandler(object o, TickArgs args);

	public class TickArgs : GLib.SignalArgs {
		public long CurrentTime{
			get {
				return (long) Args[0];
			}
			
			
		}

		public long StreamLength{
			get {
				return (long) Args[1];
			}
			
		}

		public float CurrentPosition{
			get {
				return (float) Args[2];
			}
			
		}

		public bool Seekable{
			get {
				return (bool) Args[3];
			}
			
		}

	}
}
