Summary:         Library for writing gnome database programs
Name:            libgnomedb
Version:         1.3.91
Release:         1
Source:          %{name}-%{version}.tar.gz
URL:             http://www.gnome-db.org/
Group:           System Environment/Libraries
License:         LGPL
BuildRoot:       %{_tmppath}/%{name}-%{version}-root
BuildRequires:   pkgconfig >= 0.8
Requires:        libgnomeui >= 1.103.0
Requires:        libgda >= 1.3.91
Requires:        gtk2 >= 2.6.0
Requires:        libglade2
BuildRequires:   libgnomeui-devel >= 1.103.0
BuildRequires:   libgda-devel >= 1.3.91
BuildRequires:   gtk2-devel >= 2.6.0
BuildRequires:   libglade2-devel
BuildRequires:   scrollkeeper

%description
libgnomedb is a library that eases the task of writing
gnome database programs.

%package devel
Summary:         Development libraries and header files for libgnomedb.
Group:           Development/Libraries
Requires:	 %{name} = %{version}-%{release}
Requires:        pkgconfig >= 0.8
Requires:        libgnomeui >= 1.103.0
Requires:        libgnomeui-devel >= 1.103.0
Requires:        libgda >= 1.3.91
Requires:        libgda-devel >= 1.3.91
Requires:        gtk2 >= 2.6.0
Requires:        gtk2-devel >= 2.6.0
Requires:        libglade2
Requires:        libglade2-devel

%description devel
This package contains the header files and libraries needed to write
or compile programs that use libgda.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall

%find_lang libgnomedb-2

%post
/sbin/ldconfig
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

for SCHEMA in %{_sysconfdir}/gconf/schemas/libgnomedb.schemas; do
/usr/bin/gconftool-2 --makefile-install-rule $SCHEMA > /dev/null 2>&1
done

%postun -p /sbin/ldconfig

%post devel
if which scrollkeeper-update >/dev/null 2>&1; then scrollkeeper-update; fi

%postun devel
if which scrollkeeper-update >/dev/null 2>&1; then scrollkeeper-update; fi

%clean
rm -rf %{buildroot}

%files -f libgnomedb-2.lang
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README NEWS
%{_bindir}/*
%{_datadir}/control-center-2.0/capplets/*
%{_datadir}/mime-info/*
%{_datadir}/pixmaps/libgnomedb
%{_datadir}/gnome-db
%{_libdir}/*.so.*
%{_libdir}/libglade/2.0/*
%config(noreplace) %{_sysconfdir}/gconf/schemas/*

%files devel
%defattr(-,root,root)
%doc %{_datadir}/gtk-doc/html/libgnomedb
%{_datadir}/omf/*
%dir %{_includedir}/libgnomedb-1.3/
%{_includedir}/libgnomedb-1.3/*
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%changelog
* Tue Oct 12 2004 David Hollis <dhollis@davehollis.com> 1.1.99-1
- Update to 1.1.99
- Merge RH spec changes

* Fri Oct 08 2004 Caolan McNamara <caolanm@redhat.com> 1.0.4-2
- #rh135044# BuildRequires

* Thu Aug 12 2004 Caolan McNamara <caolanm@redhat.com>
- Initial Red Hat import
- patch for missing break statement
- fixup devel package requirement pickiness

* Tue Jan 28 2003 Yanko Kaneti <yaneti@delcera.com>
- Package and add the omf/scrollkeeper bits.
- --disable-gtk-doc to configure because the generated docs are in the tarball

* Mon Aug 19 2002 Ben Liblit <liblit@acm.org>
- Fixed version number substitutions
- Updated files list to match what "make install" actually installs
- Added URL tag pointing to GNOME-DB project's web site

* Mon Feb 25 2002 Chris Chabot <chabotc@reviewboard.com>
- Cleaned up formatting
- Added requirements

* Thu Feb 21 2002 Chris Chabot <chabotc@reviewboard.com>
- Initial spec file
