%{
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <string.h>

#include "gnome-db-sql-parser.h"
#include "gnome-db-sql-tree.h"

int gnome_db_sqlerror (char *);
int gnome_db_sqllex ();

extern GnomeDbSqlStatement *sql_result;
%}

%union{
void            *v;
char            *str;
GList           *list;
GnomeDbParamSpec     *ps;
}

%token L_SELECT 
%token L_INSERT L_UPDATE
%token L_IDENT
%token L_STRING L_TEXTUAL
%token L_DELETE

%token L_LSBRACKET L_RSBRACKET
%token L_PNAME L_PTYPE L_PISPARAM L_PDESCR L_PNULLOK
%token L_UNSPECVAL

%token L_EQ

%type <v> select_statement insert_statement update_statement delete_statement expr
%type <str> L_IDENT L_STRING L_TEXTUAL
%type <list> param_spec param_spec_list expr_list
%type <ps> param_spec_item

%%

statement: select_statement     {sql_result = $1;}
        | insert_statement      {sql_result = $1;}
        | update_statement      {sql_result = $1;}
        | delete_statement      {sql_result = $1;}
        ;

select_statement: L_SELECT expr_list {$$ = gnome_db_sql_statement_build (GNOME_DB_SQL_SELECT, $2);}
	;

insert_statement: L_INSERT expr_list {$$ = gnome_db_sql_statement_build (GNOME_DB_SQL_INSERT, $2);}
	;

update_statement: L_UPDATE expr_list {$$ = gnome_db_sql_statement_build (GNOME_DB_SQL_UPDATE, $2);}
	;

delete_statement: L_DELETE expr_list {$$ = gnome_db_sql_statement_build (GNOME_DB_SQL_DELETE, $2);}
        ;

expr_list: expr           {$$ = g_list_prepend (NULL, $1);}
	| expr expr_list  {$$ = g_list_prepend ($2, $1);}
        ;

expr: L_TEXTUAL                   {$$ = gnome_db_sql_expr_build (g_strdup_printf ("\"%s\"", $1), NULL); g_free ($1);}
        | L_STRING                {$$ = gnome_db_sql_expr_build ($1, NULL);}
        | L_IDENT                 {$$ = gnome_db_sql_expr_build ($1, NULL);}
        | L_UNSPECVAL param_spec  {$$ = gnome_db_sql_expr_build (NULL, $2);}
        ;

param_spec: L_LSBRACKET param_spec_list L_RSBRACKET {$$ = $2;}
	;

param_spec_list: param_spec_item 			{$$ = g_list_append (NULL, $1);}
	| param_spec_item param_spec_list		{$$ = g_list_prepend ($2, $1);}
	;


param_spec_item: L_PNAME L_EQ L_TEXTUAL      	{$$ = gnome_db_sql_param_spec_build (GNOME_DB_PARAM_NAME, $3);}
	| L_PDESCR L_EQ L_TEXTUAL		{$$ = gnome_db_sql_param_spec_build (GNOME_DB_PARAM_DESCR, $3);}
	| L_PTYPE L_EQ L_TEXTUAL		{$$ = gnome_db_sql_param_spec_build (GNOME_DB_PARAM_TYPE, $3);}
	| L_PISPARAM L_EQ L_TEXTUAL		{$$ = gnome_db_sql_param_spec_build (GNOME_DB_PARAM_ISPARAM, $3);}
	| L_PNULLOK L_EQ L_TEXTUAL		{$$ = gnome_db_sql_param_spec_build (GNOME_DB_PARAM_NULLOK, $3);}
	;
%%
