
#include <libgnomecanvasmm/text.h>
#include <libgnomecanvasmm/private/text_p.h>

/* $Id: text.ccg,v 1.1 2002/02/24 20:41:19 murrayc Exp $ */

/* text.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace Canvas
{

Text::Text(Group& parentx, double x, double y, const Glib::ustring& text)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(), 0)))
{
  item_construct(parentx);
  set("x", x, "y", y, "text", text.c_str(), 0);
}

Text::Text(Group& parentx)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(), 0)))
{
  item_construct(parentx);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Text* wrap(GnomeCanvasText* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Text *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Text_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_text_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Text_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Text_Class::wrap_new(GObject* o)
{
  return manage(new Text((GnomeCanvasText*)(o)));
}


/* The implementation: */

Text::Text(GnomeCanvasText* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

Text::~Text()
{
  destroy_();
}

Text::CppClassType Text::text_class_; //Initialize static member.

GType Text::get_type()
{
  return text_class_.get_type();
}

GType Text::get_base_type()
{
  return gnome_canvas_text_get_type();
}


Glib::PropertyProxy<Glib::ustring> Text::property_text()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> Text::property_markup()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "markup");
}

Glib::PropertyProxy<double> Text::property_x()
{
  return Glib::PropertyProxy<double>(this, "x");
}

Glib::PropertyProxy<double> Text::property_y()
{
  return Glib::PropertyProxy<double>(this, "y");
}

Glib::PropertyProxy<Glib::ustring> Text::property_font()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "font");
}

Glib::PropertyProxy<Pango::FontDescription> Text::property_font_desc()
{
  return Glib::PropertyProxy<Pango::FontDescription>(this, "font_desc");
}

Glib::PropertyProxy<Glib::ustring> Text::property_family()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "family");
}

Glib::PropertyProxy<bool> Text::property_family_set()
{
  return Glib::PropertyProxy<bool>(this, "family_set");
}

Glib::PropertyProxy<Pango::AttrList> Text::property_attributes()
{
  return Glib::PropertyProxy<Pango::AttrList>(this, "attributes");
}

Glib::PropertyProxy<PangoStyle> Text::property_style()
{
  return Glib::PropertyProxy<PangoStyle>(this, "style");
}

Glib::PropertyProxy<bool> Text::property_style_set()
{
  return Glib::PropertyProxy<bool>(this, "style_set");
}

Glib::PropertyProxy<PangoVariant> Text::property_variant()
{
  return Glib::PropertyProxy<PangoVariant>(this, "variant");
}

Glib::PropertyProxy<bool> Text::property_variant_set()
{
  return Glib::PropertyProxy<bool>(this, "variant_set");
}

Glib::PropertyProxy<int> Text::property_weight()
{
  return Glib::PropertyProxy<int>(this, "weight");
}

Glib::PropertyProxy<bool> Text::property_weight_set()
{
  return Glib::PropertyProxy<bool>(this, "weight_set");
}

Glib::PropertyProxy<PangoWeight> Text::property_stretch()
{
  return Glib::PropertyProxy<PangoWeight>(this, "stretch");
}

Glib::PropertyProxy<bool> Text::property_stretch_set()
{
  return Glib::PropertyProxy<bool>(this, "stretch_set");
}

Glib::PropertyProxy<int> Text::property_size()
{
  return Glib::PropertyProxy<int>(this, "size");
}

Glib::PropertyProxy<bool> Text::property_size_set()
{
  return Glib::PropertyProxy<bool>(this, "size_set");
}

Glib::PropertyProxy<double> Text::property_size_points()
{
  return Glib::PropertyProxy<double>(this, "size_points");
}

Glib::PropertyProxy<bool> Text::property_strikethrough()
{
  return Glib::PropertyProxy<bool>(this, "strikethrough");
}

Glib::PropertyProxy<bool> Text::property_strikethrough_set()
{
  return Glib::PropertyProxy<bool>(this, "strikethrough_set");
}

Glib::PropertyProxy<PangoUnderline> Text::property_underline()
{
  return Glib::PropertyProxy<PangoUnderline>(this, "underline");
}

Glib::PropertyProxy<bool> Text::property_underline_set()
{
  return Glib::PropertyProxy<bool>(this, "underline_set");
}

Glib::PropertyProxy<int> Text::property_rise()
{
  return Glib::PropertyProxy<int>(this, "rise");
}

Glib::PropertyProxy<bool> Text::property_rise_set()
{
  return Glib::PropertyProxy<bool>(this, "rise_set");
}

Glib::PropertyProxy<double> Text::property_scale()
{
  return Glib::PropertyProxy<double>(this, "scale");
}

Glib::PropertyProxy<bool> Text::property_scale_set()
{
  return Glib::PropertyProxy<bool>(this, "scale_set");
}

Glib::PropertyProxy<Gtk::AnchorType> Text::property_anchor()
{
  return Glib::PropertyProxy<Gtk::AnchorType>(this, "anchor");
}

Glib::PropertyProxy<Gtk::Justification> Text::property_justification()
{
  return Glib::PropertyProxy<Gtk::Justification>(this, "justification");
}

Glib::PropertyProxy<double> Text::property_clip_width()
{
  return Glib::PropertyProxy<double>(this, "clip_width");
}

Glib::PropertyProxy<double> Text::property_clip_height()
{
  return Glib::PropertyProxy<double>(this, "clip_height");
}

Glib::PropertyProxy<bool> Text::property_clip()
{
  return Glib::PropertyProxy<bool>(this, "clip");
}

Glib::PropertyProxy<double> Text::property_x_offset()
{
  return Glib::PropertyProxy<double>(this, "x_offset");
}

Glib::PropertyProxy<double> Text::property_y_offset()
{
  return Glib::PropertyProxy<double>(this, "y_offset");
}

Glib::PropertyProxy<Glib::ustring> Text::property_fill_color()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "fill_color");
}

Glib::PropertyProxy<Gdk::Color> Text::property_fill_color_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "fill_color_gdk");
}

Glib::PropertyProxy<guint> Text::property_fill_color_rgba()
{
  return Glib::PropertyProxy<guint>(this, "fill_color_rgba");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> > Text::property_fill_stipple()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> >(this, "fill_stipple");
}

Glib::PropertyProxy<double> Text::property_text_width()
{
  return Glib::PropertyProxy<double>(this, "text_width");
}

Glib::PropertyProxy<double> Text::property_text_height()
{
  return Glib::PropertyProxy<double>(this, "text_height");
}


} // namespace Canvas

} // namespace Gnome

