// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/statement.h>
#include <libgdamm/private/statement_p.h>

// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* statement.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/statement.h>
#include <libgdamm/connection.h>
#include <libgda/gda-enum-types.h>
#include <libgda/gda-holder.h>
#include <sql-parser/gda-sql-parser-enum-types.h>

namespace Gnome
{

namespace Gda
{

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Statement::get_parameters(Glib::RefPtr<Set>& params)
#else
bool Statement::get_parameters(Glib::RefPtr<Set>& params, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GdaSet* set = 0;
  const bool retval = gda_statement_get_parameters(gobj(), &set, &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  if(set)
  {
    params = Glib::wrap(set);
    params->reference();
  }

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Statement::to_sql() const
#else
Glib::ustring Statement::to_sql(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  const Glib::ustring retval = 
    Glib::convert_return_gchar_ptr_to_ustring(
      gda_statement_to_sql(const_cast<GdaStatement*>(gobj()), 0, &gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Statement::to_sql(const Glib::RefPtr<const Set>& params) const
#else
Glib::ustring Statement::to_sql(const Glib::RefPtr<const Set>& params, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  const Glib::ustring retval = 
    Glib::convert_return_gchar_ptr_to_ustring(
      gda_statement_to_sql(const_cast<GdaStatement*>(gobj()), const_cast<GdaSet*>(Glib::unwrap(params)), &gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  return retval;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Statement::to_sql(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<const Set>& params, 
                              StatementSqlFlag flags, const HolderSList&) const
#else
Glib::ustring Statement::to_sql(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<const Set>& params, 
                              StatementSqlFlag flags, const HolderSList&,
                              std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  GSList* list = 0;
  const Glib::ustring retval = 
    Glib::convert_return_gchar_ptr_to_ustring(
      gda_statement_to_sql_extended(const_cast<GdaStatement*>(gobj()), Glib::unwrap(cnc), const_cast<GdaSet*>(Glib::unwrap(params)), (GdaStatementSqlFlag) flags, &list, &gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED
  if (list)
  {
    // FIXME: Set params_used somehow
    // Nope, no way.  The wrapper prototype is just broken.  --danielk
  }
  return retval;
}

} // namespace Gda


} /* namespace Gnome */


namespace
{


static void Statement_signal_checked_callback(GdaStatement* self, GdaConnection* p0,gboolean p1,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Glib::RefPtr<Connection>&,bool > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Statement_signal_checked_info =
{
  "checked",
  (GCallback) &Statement_signal_checked_callback,
  (GCallback) &Statement_signal_checked_callback
};


static const Glib::SignalProxyInfo Statement_signal_reset_info =
{
  "reset",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gnome::Gda::SqlStatementType>::value_type()
{
  return gda_sql_statement_type_get_type();
}

// static
GType Glib::Value<Gnome::Gda::StatementModelUsage>::value_type()
{
  return gda_statement_model_usage_get_type();
}

// static
GType Glib::Value<Gnome::Gda::StatementSqlFlag>::value_type()
{
  return gda_statement_sql_flag_get_type();
}


Gnome::Gda::StatementError::StatementError(Gnome::Gda::StatementError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_STATEMENT_ERROR, error_code, error_message)
{}

Gnome::Gda::StatementError::StatementError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::StatementError::Code Gnome::Gda::StatementError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::StatementError::throw_func(GError* gobject)
{
  throw Gnome::Gda::StatementError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::StatementError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::StatementError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::StatementError::Code>::value_type()
{
  return gda_statement_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Statement> wrap(GdaStatement* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Statement>( dynamic_cast<Gnome::Gda::Statement*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Statement_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Statement_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_statement_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Statement_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->checked = &checked_callback;
  klass->reset = &reset_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Statement_Class::checked_callback(GdaStatement* self, GdaConnection* p0, gboolean p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_checked(Glib::wrap(p0, true)
, p1
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->checked)
    (*base->checked)(self, p0, p1);
}
void Statement_Class::reset_callback(GdaStatement* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_reset();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->reset)
    (*base->reset)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Statement_Class::wrap_new(GObject* object)
{
  return new Statement((GdaStatement*)object);
}


/* The implementation: */

GdaStatement* Statement::gobj_copy()
{
  reference();
  return gobj();
}

Statement::Statement(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Statement::Statement(GdaStatement* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Statement::~Statement()
{}


Statement::CppClassType Statement::statement_class_; // initialize static member

GType Statement::get_type()
{
  return statement_class_.init().get_type();
}


GType Statement::get_base_type()
{
  return gda_statement_get_type();
}


Statement::Statement()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(statement_class_.init()))
{
  

}

Glib::RefPtr<Statement> Statement::create()
{
  return Glib::RefPtr<Statement>( new Statement() );
}
Glib::RefPtr<Statement> Statement::copy() const
{
  return Glib::wrap(gda_statement_copy(const_cast<GdaStatement*>(gobj())));
}

Glib::ustring Statement::serialize() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_statement_serialize(const_cast<GdaStatement*>(gobj())));
}

SqlStatementType Statement::get_statement_type() const
{
  return ((SqlStatementType)(gda_statement_get_statement_type(const_cast<GdaStatement*>(gobj()))));
}

bool Statement::is_useless() const
{
  return gda_statement_is_useless(const_cast<GdaStatement*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Statement::check_structure() const
#else
bool Statement::check_structure(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_statement_check_structure(const_cast<GdaStatement*>(gobj()), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Statement::check_validity(const Glib::RefPtr<Connection>& cnc) const
#else
bool Statement::check_validity(const Glib::RefPtr<Connection>& cnc, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_statement_check_validity(const_cast<GdaStatement*>(gobj()), Glib::unwrap(cnc), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Statement::normalize(const Glib::RefPtr<Connection>& cnc)
#else
bool Statement::normalize(const Glib::RefPtr<Connection>& cnc, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_statement_normalize(gobj(), Glib::unwrap(cnc), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


Glib::SignalProxy2< void,const Glib::RefPtr<Connection>&,bool > Statement::signal_checked()
{
  return Glib::SignalProxy2< void,const Glib::RefPtr<Connection>&,bool >(this, &Statement_signal_checked_info);
}


Glib::SignalProxy0< void > Statement::signal_reset()
{
  return Glib::SignalProxy0< void >(this, &Statement_signal_reset_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<gpointer> Statement::property_structure() 
{
  return Glib::PropertyProxy<gpointer>(this, "structure");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<gpointer> Statement::property_structure() const
{
  return Glib::PropertyProxy_ReadOnly<gpointer>(this, "structure");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Gda::Statement::on_checked(const Glib::RefPtr<Connection>& cnc, bool valid)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->checked)
    (*base->checked)(gobj(),Glib::unwrap(cnc),static_cast<int>(valid));
}
void Gnome::Gda::Statement::on_reset()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->reset)
    (*base->reset)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


