// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/sqlbuilder.h>
#include <libgdamm/private/sqlbuilder_p.h>

// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* sqlparser.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/sqlbuilder.h>
#include <libgda/gda-sql-builder.h>
#include <libgda/gda-enum-types.h>
#include <sql-parser/gda-sql-parser-enum-types.h>

namespace Gnome
{

namespace Gda
{

SqlBuilder::SqlBuilder(SqlStatementType type)
  : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(sqlbuilder_class_.init(), "stmt-type",type, static_cast<char*>(0)))
{
  
}

guint SqlBuilder::add_id(const Glib::ustring& string)
{
  return gda_sql_builder_add_id(gobj(), 0, string.c_str());
}

guint SqlBuilder::add_expr_as_value(const Glib::RefPtr<DataHandler>& dh, const Value& value)
{
  return gda_sql_builder_add_expr_value(gobj(), 0, dh->gobj(), const_cast<GValue*>(value.gobj()));
}

guint SqlBuilder::add_expr_as_value(const Value& value)
{
  return gda_sql_builder_add_expr_value(gobj(), 0, 0, const_cast<GValue*>(value.gobj()));
}

guint SqlBuilder::add_param(const Glib::ustring& param_name, GType type, bool nullok)
{
  return gda_sql_builder_add_param(gobj(), 0, param_name.c_str(), type, nullok);
}

guint SqlBuilder::add_cond(SqlOperatorType op, guint op1, guint op2, guint op3)
{
  return gda_sql_builder_add_cond(gobj(), 0, (GdaSqlOperatorType) op, op1, op2, op3);
}

guint SqlBuilder::add_cond(SqlOperatorType op, const Glib::ArrayHandle<uint>& op_ids)
{
  return gda_sql_builder_add_cond_v(gobj(), 0, (GdaSqlOperatorType) op, op_ids.data(), op_ids.size());
}

guint SqlBuilder::add_function(const Glib::ustring& function_name, const Glib::ArrayHandle<guint>& args)
{
  return gda_sql_builder_add_function_v(gobj(), 0, function_name.c_str(), args.data(), args.size());
}

guint SqlBuilder::select_add_target(const Glib::ustring& table_name, const Glib::ustring& alias)
{
  return gda_sql_builder_select_add_target(gobj(), table_name.c_str(), alias.c_str());
}


guint SqlBuilder::select_join_targets(guint left_target_id, guint right_target_id, SqlSelectJoinType join_type, guint join_expr)
{
  return gda_sql_builder_select_join_targets(gobj(), 0, left_target_id, right_target_id, (GdaSqlSelectJoinType) join_type, join_expr);
}

} /* namespace Gda */

} /* namespace Gnome */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gnome::Gda::SqlOperatorType>::value_type()
{
  return gda_sql_operator_type_get_type();
}

// static
GType Glib::Value<Gnome::Gda::SqlSelectJoinType>::value_type()
{
  return gda_sql_select_join_type_get_type();
}


Gnome::Gda::SqlBuilderError::SqlBuilderError(Gnome::Gda::SqlBuilderError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_SQL_BUILDER_ERROR, error_code, error_message)
{}

Gnome::Gda::SqlBuilderError::SqlBuilderError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::SqlBuilderError::Code Gnome::Gda::SqlBuilderError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Gnome::Gda::SqlBuilderError::throw_func(GError* gobject)
{
  throw Gnome::Gda::SqlBuilderError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Gnome::Gda::SqlBuilderError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Gnome::Gda::SqlBuilderError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Gnome::Gda::SqlBuilderError::Code>::value_type()
{
  return gda_sql_builder_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::SqlBuilder> wrap(GdaSqlBuilder* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::SqlBuilder>( dynamic_cast<Gnome::Gda::SqlBuilder*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& SqlBuilder_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &SqlBuilder_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_sql_builder_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void SqlBuilder_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* SqlBuilder_Class::wrap_new(GObject* object)
{
  return new SqlBuilder((GdaSqlBuilder*)object);
}


/* The implementation: */

GdaSqlBuilder* SqlBuilder::gobj_copy()
{
  reference();
  return gobj();
}

SqlBuilder::SqlBuilder(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

SqlBuilder::SqlBuilder(GdaSqlBuilder* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


SqlBuilder::~SqlBuilder()
{}


SqlBuilder::CppClassType SqlBuilder::sqlbuilder_class_; // initialize static member

GType SqlBuilder::get_type()
{
  return sqlbuilder_class_.init().get_type();
}


GType SqlBuilder::get_base_type()
{
  return gda_sql_builder_get_type();
}


Glib::RefPtr<SqlBuilder> SqlBuilder::create(SqlStatementType type)
{
  return Glib::RefPtr<SqlBuilder>( new SqlBuilder(type) );
}
#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Statement> SqlBuilder::get_statement() const
#else
Glib::RefPtr<Statement> SqlBuilder::get_statement(std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<Statement> retvalue = Glib::wrap(gda_sql_builder_get_statement(const_cast<GdaSqlBuilder*>(gobj()), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void SqlBuilder::select_add_field(const Glib::ustring& field_name, const Glib::ustring& table_name, const Glib::ustring& alias)
{
gda_sql_builder_select_add_field(gobj(), field_name.c_str(), table_name.c_str(), alias.c_str()); 
}

void SqlBuilder::join_add_field(guint join_id, const Glib::ustring& field_name)
{
gda_sql_builder_join_add_field(gobj(), join_id, field_name.c_str()); 
}

void SqlBuilder::select_order_by(guint expr_id, bool asc, const Glib::ustring& collation_name)
{
gda_sql_builder_select_order_by(gobj(), expr_id, static_cast<int>(asc), collation_name.c_str()); 
}

void SqlBuilder::set_table(const Glib::ustring& table_name)
{
gda_sql_builder_set_table(gobj(), table_name.c_str()); 
}

void SqlBuilder::set_where(guint cond_id)
{
gda_sql_builder_set_where(gobj(), cond_id); 
}

void SqlBuilder::add_field_id(guint field_id, guint value_id)
{
gda_sql_builder_add_field_id(gobj(), field_id, value_id); 
}

void SqlBuilder::add_field_value_as_value(const Glib::ustring& field_name, const Value& value)
{
gda_sql_builder_add_field_value(gobj(), field_name.c_str(), (value).gobj()); 
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


