/* document.c generated by valac 0.12.1, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksourceiter.h>
#include <pango/pango.h>


#define TYPE_SELECTION_TYPE (selection_type_get_type ())

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
	GtkTextTag* found_tag;
	GtkTextTag* found_tag_selected;
	gchar* search_text;
	guint search_nb_matches;
	guint search_num_match;
	gboolean search_case_sensitive;
	gboolean search_entire_word;
	gboolean stop_cursor_moved_emission;
};

struct _Block3Data {
	int _ref_count_;
	Document * self;
	GtkSourceCompletion* completion;
};

struct _Block4Data {
	int _ref_count_;
	Document * self;
	TabInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};


static gpointer document_parent_class = NULL;

GType selection_type_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
enum  {
	DOCUMENT_DUMMY_PROPERTY,
	DOCUMENT_LOCATION,
	DOCUMENT_READONLY,
	DOCUMENT_PROJECT_ID
};
Document* document_new (void);
Document* document_construct (GType object_type);
static void _lambda128_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void __lambda128__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda129_ (GtkTextIter* location, GtkTextMark* mark, Document* self);
static void document_emit_cursor_moved (Document* self);
static void __lambda129__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void _lambda130_ (Document* self);
static void __lambda130__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void document_sync_found_tags (Document* self);
static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean document_get_modified (Document* self);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean _lambda62_ (Block3Data* _data3_);
static gboolean __lambda62__gsource_func (gpointer self);
void document_load (Document* self, GFile* location);
void document_set_location (Document* self, GFile* value);
void document_set_contents (Document* self, const gchar* contents);
static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GFile* document_get_location (Document* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const gchar* text, const gchar* stock_id, gint response_id);
static void _lambda13_ (gint response_id, Block4Data* _data4_);
static void __lambda13__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void tab_info_bar_add_ok_button (TabInfoBar* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self, gint value);
gchar* document_get_uri_for_display (Document* self);
static gchar* document_get_unsaved_document_name (Document* self);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gchar* document_get_short_name_for_display (Document* self);
static guint document_get_unsaved_document_num (Document* self);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GList* application_get_documents (Application* self);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
void document_uncomment_selected_lines (Document* self);
void document_select_lines (Document* self, gint start, gint end);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
SelectionType document_get_selection_type (Document* self);
gboolean document_goto_line (Document* self, gint line);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self, gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
gchar* document_get_current_indentation (Document* self, gint line);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static void document_search_cursor_moved_handler (Document* self);
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self);
static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end);
static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location);
static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location);
static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self);
static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const gchar* text, gint len);
static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self);
static void document_invalidate_search_selected_marks (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor);
static void document_clear_search_tags (Document* self);
void document_select_selected_search_text (Document* self);
void document_search_forward (Document* self);
static void document_replace_found_tag_selected (Document* self);
static void document_find_num_match (Document* self);
void document_search_backward (Document* self);
static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static GtkSourceSearchFlags document_get_search_flags (Document* self);
static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search);
static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag);
void document_replace (Document* self, const gchar* text);
gboolean document_get_readonly (Document* self);
void document_replace_all (Document* self, const gchar* text);
void document_set_readonly (Document* self, gboolean value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void document_finalize (GObject* obj);
static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

GType selection_type_get_type (void) {
	static volatile gsize selection_type_type_id__volatile = 0;
	if (g_once_init_enter (&selection_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SELECTION_TYPE_NO_SELECTION, "SELECTION_TYPE_NO_SELECTION", "no-selection"}, {SELECTION_TYPE_ONE_LINE, "SELECTION_TYPE_ONE_LINE", "one-line"}, {SELECTION_TYPE_MULTIPLE_LINES, "SELECTION_TYPE_MULTIPLE_LINES", "multiple-lines"}, {0, NULL, NULL}};
		GType selection_type_type_id;
		selection_type_type_id = g_enum_register_static ("SelectionType", values);
		g_once_init_leave (&selection_type_type_id__volatile, selection_type_type_id);
	}
	return selection_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda128_ (Document* self) {
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}


static void __lambda128__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda128_ (self);
}


static void _lambda129_ (GtkTextIter* location, GtkTextMark* mark, Document* self) {
	GtkTextMark* _tmp0_ = NULL;
	g_return_if_fail (mark != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	if (mark == _tmp0_) {
		document_emit_cursor_moved (self);
	}
}


static void __lambda129__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	_lambda129_ (location, mark, self);
}


static void _lambda130_ (Document* self) {
	self->priv->new_file = FALSE;
	document_emit_cursor_moved (self);
}


static void __lambda130__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda130_ (self);
}


static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_sync_found_tags (self);
}


Document* document_construct (GType object_type) {
	Document * self = NULL;
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguageManager* lm;
	GtkSourceLanguage* _tmp2_ = NULL;
	GtkTextTag* _tmp3_ = NULL;
	GtkTextTag* _tmp4_ = NULL;
	GtkTextTagTable* _tmp5_ = NULL;
	GtkTextTagTable* _tmp6_;
	GtkTextTagTable* tag_table;
	GtkTextIter iter = {0};
	GtkTextIter _tmp7_ = {0};
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) __lambda128__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "mark-set", (GCallback) __lambda129__gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) __lambda130__gtk_text_buffer_changed, self, 0);
	_tmp3_ = gtk_text_tag_new ("found");
	_g_object_unref0 (self->priv->found_tag);
	self->priv->found_tag = _tmp3_;
	_tmp4_ = gtk_text_tag_new ("found_selected");
	_g_object_unref0 (self->priv->found_tag_selected);
	self->priv->found_tag_selected = _tmp4_;
	document_sync_found_tags (self);
	_tmp5_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	tag_table = _tmp6_;
	gtk_text_tag_table_add (tag_table, self->priv->found_tag);
	gtk_text_tag_table_add (tag_table, self->priv->found_tag_selected);
	g_signal_connect_object ((GObject*) self, "notify::style-scheme", (GCallback) _document_sync_found_tags_g_object_notify, self, 0);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp7_, 0);
	iter = _tmp7_;
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_start", &iter, TRUE);
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_end", &iter, TRUE);
	_g_object_unref0 (tag_table);
	_g_object_unref0 (lm);
	return self;
}


Document* document_new (void) {
	return document_construct (TYPE_DOCUMENT);
}


gboolean document_get_modified (Document* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->new_file) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) GTK_SOURCE_BUFFER (self));
	result = _tmp0_;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->completion);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda62_ (Block3Data* _data3_) {
	Document * self;
	gboolean result = FALSE;
	self = _data3_->self;
	gtk_source_completion_unblock_interactive (_data3_->completion);
	result = FALSE;
	return result;
}


static gboolean __lambda62__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda62_ (self);
	return result;
}


void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len) {
	Block3Data* _data3_;
	DocumentView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GtkSourceCompletion* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = document_tab_get_view (self->tab);
	_tmp1_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data3_->completion = _tmp2_;
	gtk_source_completion_block_interactive (_data3_->completion);
	gtk_text_buffer_insert ((GtkTextBuffer*) GTK_SOURCE_BUFFER (self), iter, text, len);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda62__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


void document_load (Document* self, GFile* location) {
	gchar* text = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GtkRecentManager* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	document_set_location (self, location);
	g_file_load_contents (location, NULL, &_tmp0_, NULL, &_tmp1_, &_inner_error_);
	_g_free0 (text);
	text = _tmp0_;
	_g_free0 (self->priv->_etag);
	self->priv->_etag = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		goto __catch2_g_error;
	}
	_tmp2_ = g_utf8_validate (text, (gssize) (-1), NULL);
	if (_tmp2_) {
		document_set_contents (self, text);
	} else {
		gchar* _tmp3_ = NULL;
		gchar* utf8_text;
		_tmp3_ = document_to_utf8 (self, text, &_inner_error_);
		utf8_text = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch2_g_error;
		}
		document_set_contents (self, utf8_text);
		_g_free0 (utf8_text);
	}
	document_update_syntax_highlighting (self);
	_tmp4_ = gtk_recent_manager_get_default ();
	_tmp5_ = g_file_get_uri (location);
	_tmp6_ = _tmp5_;
	gtk_recent_manager_add_item (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (text);
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* primary_msg;
		TabInfoBar* _tmp12_ = NULL;
		TabInfoBar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("document.vala:141: %s", e->message);
		_tmp7_ = _ ("Impossible to load the file '%s'.");
		_tmp8_ = g_file_get_parse_name (location);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		primary_msg = _tmp11_;
		_tmp12_ = document_tab_add_message (self->tab, primary_msg, e->message, GTK_MESSAGE_ERROR);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_g_free0 (primary_msg);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


void document_set_contents (Document* self, const gchar* contents) {
	gchar* contents2;
	gint _tmp0_;
	gchar _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	_tmp0_ = strlen (contents);
	_tmp1_ = string_get (contents, (glong) (_tmp0_ - 1));
	if (_tmp1_ == '\n') {
		gchar* _tmp2_ = NULL;
		_tmp2_ = string_slice (contents, (glong) 0, (glong) (-1));
		_g_free0 (contents2);
		contents2 = _tmp2_;
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp3_ = g_strdup (contents2);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (contents);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	}
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp4_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp6_);
	iter = _tmp6_;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &iter);
	_g_free0 (_tmp4_);
	_g_free0 (contents2);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->infobar);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda13_ (gint response_id, Block4Data* _data4_) {
	Document * self;
	self = _data4_->self;
	if (response_id == GTK_RESPONSE_YES) {
		document_save (self, FALSE, FALSE);
	}
	gtk_object_destroy ((GtkObject*) _data4_->infobar);
}


static void __lambda13__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda13_ (response_id, self);
}


void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gchar* text;
	gint _tmp6_;
	gchar _tmp7_;
	GSettings* _tmp10_ = NULL;
	GSettings* settings;
	gboolean _tmp11_ = FALSE;
	gboolean make_backup;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* etag;
	GFile* _tmp21_ = NULL;
	GFile* parent;
	gboolean _tmp22_ = FALSE;
	gint _tmp24_;
	gchar* _tmp25_ = NULL;
	GtkRecentManager* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->_location != NULL);
	if (!force) {
		_tmp1_ = !self->priv->new_file;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = document_get_modified (self);
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start, &end, FALSE);
	text = _tmp5_;
	_tmp6_ = strlen (text);
	_tmp7_ = string_get (text, (glong) (_tmp6_ - 1));
	if (_tmp7_ != '\n') {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = string_to_string (text);
		_tmp9_ = g_strconcat (_tmp8_, "\n", NULL);
		_g_free0 (text);
		text = _tmp9_;
	}
	_tmp10_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp10_;
	if (!self->priv->backup_made) {
		gboolean _tmp12_;
		_tmp12_ = g_settings_get_boolean (settings, "create-backup-copy");
		_tmp11_ = _tmp12_;
	} else {
		_tmp11_ = FALSE;
	}
	make_backup = _tmp11_;
	if (check_file_changed_on_disk) {
		_tmp13_ = self->priv->_etag;
	} else {
		_tmp13_ = NULL;
	}
	_tmp14_ = g_strdup (_tmp13_);
	etag = _tmp14_;
	if (self->priv->encoding != NULL) {
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp15_ = strlen (text);
		_tmp16_ = g_convert (text, (gssize) _tmp15_, self->priv->encoding, "UTF-8", NULL, NULL, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch3_g_error;
		}
		_g_free0 (text);
		text = _tmp17_;
	} else {
		gint _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		_tmp18_ = strlen (text);
		_tmp19_ = g_filename_from_utf8 (text, (gssize) _tmp18_, NULL, NULL, &_inner_error_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch3_g_error;
		}
		_g_free0 (text);
		text = _tmp20_;
	}
	_tmp21_ = g_file_get_parent (self->priv->_location);
	parent = _tmp21_;
	if (parent != NULL) {
		gboolean _tmp23_;
		_tmp23_ = g_file_query_exists (parent, NULL);
		_tmp22_ = !_tmp23_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch3_g_error;
		}
	}
	_tmp24_ = strlen (text);
	g_file_replace_contents (self->priv->_location, text, (gsize) _tmp24_, etag, make_backup, G_FILE_CREATE_NONE, &_tmp25_, NULL, &_inner_error_);
	_g_free0 (self->priv->_etag);
	self->priv->_etag = _tmp25_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		_g_free0 (etag);
		_g_object_unref0 (settings);
		goto __catch3_g_error;
	}
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	_tmp26_ = gtk_recent_manager_get_default ();
	_tmp27_ = g_file_get_uri (self->priv->_location);
	_tmp28_ = _tmp27_;
	gtk_recent_manager_add_item (_tmp26_, _tmp28_);
	_g_free0 (_tmp28_);
	self->priv->backup_made = TRUE;
	_g_object_unref0 (parent);
	_g_free0 (etag);
	_g_object_unref0 (settings);
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (g_error_matches (e, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
			Block4Data* _data4_;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* primary_msg;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* secondary_msg;
			TabInfoBar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			_data4_ = g_slice_new0 (Block4Data);
			_data4_->_ref_count_ = 1;
			_data4_->self = g_object_ref (self);
			_tmp29_ = _ ("The file %s has been modified since reading it.");
			_tmp30_ = g_file_get_parse_name (self->priv->_location);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup_printf (_tmp29_, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp31_);
			primary_msg = _tmp33_;
			_tmp34_ = _ ("If you save it, all the external changes could be lost. Save it anyway" \
"?");
			_tmp35_ = g_strdup (_tmp34_);
			secondary_msg = _tmp35_;
			_tmp36_ = document_tab_add_message (self->tab, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
			_data4_->infobar = _tmp36_;
			_tmp37_ = _ ("Save Anyway");
			tab_info_bar_add_stock_button_with_text (_data4_->infobar, _tmp37_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
			_tmp38_ = _ ("Don't Save");
			gtk_info_bar_add_button ((GtkInfoBar*) _data4_->infobar, _tmp38_, (gint) GTK_RESPONSE_CANCEL);
			g_signal_connect_data ((GtkInfoBar*) _data4_->infobar, "response", (GCallback) __lambda13__gtk_info_bar_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
			_g_free0 (secondary_msg);
			_g_free0 (primary_msg);
			block4_data_unref (_data4_);
			_data4_ = NULL;
		} else {
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar* primary_msg;
			TabInfoBar* _tmp41_ = NULL;
			TabInfoBar* infobar;
			g_warning ("document.vala:237: %s", e->message);
			_tmp39_ = _ ("Impossible to save the file.");
			_tmp40_ = g_strdup (_tmp39_);
			primary_msg = _tmp40_;
			_tmp41_ = document_tab_add_message (self->tab, primary_msg, e->message, GTK_MESSAGE_ERROR);
			infobar = _tmp41_;
			tab_info_bar_add_ok_button (infobar);
			_g_object_unref0 (infobar);
			_g_free0 (primary_msg);
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (text);
}


static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp4_ = NULL;
	GError* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const gchar** charset_collection;
		int charset_collection_length1;
		int charset_it;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
			gchar* _tmp0_;
			gchar* charset;
			_tmp0_ = g_strdup (charset_collection[charset_it]);
			charset = _tmp0_;
			{
				gint _tmp1_;
				gchar* _tmp2_ = NULL;
				gchar* utf8_text;
				gchar* _tmp3_;
				_tmp1_ = strlen (text);
				_tmp2_ = g_convert (text, (gssize) _tmp1_, "UTF-8", charset, NULL, NULL, &_inner_error_);
				utf8_text = _tmp2_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch4_g_convert_error;
					}
					_g_free0 (charset);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp3_ = g_strdup (charset);
				_g_free0 (self->priv->encoding);
				self->priv->encoding = _tmp3_;
				result = utf8_text;
				_g_free0 (charset);
				return result;
				_g_free0 (utf8_text);
				goto __finally4;
				__catch4_g_convert_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					_g_free0 (charset);
					continue;
				}
				__finally4:
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (charset);
					return NULL;
				} else {
					_g_free0 (charset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (charset);
			}
		}
	}
	_tmp4_ = _ ("Error trying to convert the document to UTF-8");
	_tmp5_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp4_);
	_inner_error_ = _tmp5_;
	if (_inner_error_->domain == G_CONVERT_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void document_update_syntax_highlighting (Document* self) {
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguageManager* lm;
	gchar* content_type;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* info;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GtkSourceLanguage* _tmp7_ = NULL;
	GtkSourceLanguage* _tmp8_;
	GtkSourceLanguage* _tmp9_;
	GtkSourceLanguage* lang;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	content_type = NULL;
	_tmp2_ = g_file_query_info (self->priv->_location, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_tmp3_ = g_file_info_get_content_type (info);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (content_type);
	content_type = _tmp4_;
	_g_object_unref0 (info);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = g_file_get_parse_name (self->priv->_location);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_source_language_manager_guess_language (lm, _tmp6_, content_type);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp6_);
	lang = _tmp9_;
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	_g_free0 (content_type);
	_g_object_unref0 (lm);
}


static void document_update_project_id (Document* self) {
	gint i;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		Projects* _tmp0_ = NULL;
		Projects* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _project_it;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			Project* _tmp6_;
			Project _tmp7_;
			Project _tmp8_ = {0};
			Project _tmp9_;
			Project project;
			gboolean _tmp10_;
			_tmp4_ = gee_iterator_next (_project_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_project_it);
			_tmp6_ = (Project*) _tmp5_;
			project_copy (_tmp6_, &_tmp8_);
			_tmp7_ = _tmp8_;
			_tmp9_ = _tmp7_;
			_project_free0 (_tmp6_);
			project = _tmp9_;
			_tmp10_ = g_file_has_prefix (self->priv->_location, project.directory);
			if (_tmp10_) {
				document_set_project_id (self, i);
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return;
			}
			i++;
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	document_set_project_id (self, -1);
}


gchar* document_get_uri_for_display (Document* self) {
	gchar* result = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = document_get_unsaved_document_name (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_file_get_parse_name (self->priv->_location);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_replace_home_dir_with_tilde (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


gchar* document_get_short_name_for_display (Document* self) {
	gchar* result = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = document_get_unsaved_document_name (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_file_get_basename (self->priv->_location);
	result = _tmp1_;
	return result;
}


static gchar* document_get_unsaved_document_name (Document* self) {
	gchar* result = NULL;
	guint _tmp0_;
	guint num;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_unsaved_document_num (self);
	num = _tmp0_;
	_tmp1_ = _ ("Unsaved Document");
	_tmp2_ = g_strdup_printf ("%u", num);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static guint document_get_unsaved_document_num (Document* self) {
	guint result = 0U;
	guint* _tmp0_ = NULL;
	guint* all_nums;
	gint all_nums_length1;
	gint _all_nums_size_;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	guint num = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (self->priv->_location == NULL, 0);
	if (self->_unsaved_doc_num > 0) {
		result = self->_unsaved_doc_num;
		return result;
	}
	_tmp0_ = g_new0 (guint, 0);
	all_nums = _tmp0_;
	all_nums_length1 = 0;
	_all_nums_size_ = 0;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_documents (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp4_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp5_;
			Document* doc;
			_tmp5_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp5_;
			{
				if (doc == self) {
					_g_object_unref0 (doc);
					continue;
				}
				if (doc->priv->_location == NULL) {
					guint _tmp6_;
					_tmp6_ = document_get_unsaved_document_num (doc);
					_vala_array_add1 (&all_nums, &all_nums_length1, &_all_nums_size_, _tmp6_);
				}
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
	{
		gboolean _tmp7_;
		num = (guint) 1;
		_tmp7_ = TRUE;
		while (TRUE) {
			if (!_tmp7_) {
				num++;
			}
			_tmp7_ = FALSE;
			if (!_vala_uint_array_contains (all_nums, all_nums_length1, num)) {
				break;
			}
		}
	}
	self->_unsaved_doc_num = num;
	result = num;
	all_nums = (g_free (all_nums), NULL);
	return result;
}


gboolean document_is_local (Document* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_location == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_file_has_uri_scheme (self->priv->_location, "file");
	result = _tmp0_;
	return result;
}


gboolean document_is_externally_modified (Document* self) {
	gboolean result = FALSE;
	gchar* current_etag;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* file_info;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_location == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	_tmp0_ = g_file_query_info (self->priv->_location, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	file_info = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	_tmp1_ = g_file_info_get_etag (file_info);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (current_etag);
	current_etag = _tmp2_;
	_g_object_unref0 (file_info);
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (current_etag);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (current_etag != NULL) {
		_tmp3_ = g_strcmp0 (current_etag, self->priv->_etag) != 0;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_free0 (current_etag);
	return result;
}


void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id) {
	GtkSourceStyleSchemeManager* _tmp0_ = NULL;
	GtkSourceStyleSchemeManager* _tmp1_;
	GtkSourceStyleSchemeManager* manager;
	GtkSourceStyleScheme* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme_id != NULL);
	_tmp0_ = gtk_source_style_scheme_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = gtk_source_style_scheme_manager_get_scheme (manager, scheme_id);
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, _tmp2_);
	_g_object_unref0 (manager);
}


static void document_emit_cursor_moved (Document* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->stop_cursor_moved_emission) {
		g_signal_emit_by_name (self, "cursor-moved");
	}
}


void document_comment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	document_comment_between (self, &start, &end);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	gint _tmp0_;
	gint start_line;
	gint end_line;
	GtkTextIter cur_iter = {0};
	GtkTextIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_iter_get_line (start_iter);
	start_line = _tmp0_;
	end_line = start_line;
	if (end_iter != NULL) {
		gint _tmp1_;
		_tmp1_ = gtk_text_iter_get_line (end_iter);
		end_line = _tmp1_;
	}
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, start_line);
	cur_iter = _tmp2_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i;
		i = start_line;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				GtkTextIter end_line_iter;
				gchar* _tmp5_ = NULL;
				gchar* line_contents;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp3_) {
					i++;
					gtk_text_iter_forward_line (&cur_iter);
				}
				_tmp3_ = FALSE;
				if (!(i <= end_line)) {
					break;
				}
				_tmp4_ = gtk_text_iter_ends_line (&cur_iter);
				if (_tmp4_) {
					continue;
				}
				end_line_iter = cur_iter;
				gtk_text_iter_forward_to_line_end (&end_line_iter);
				_tmp5_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &cur_iter, &end_line_iter, FALSE);
				line_contents = _tmp5_;
				_tmp6_ = string_strip (line_contents);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (_tmp7_, "") != 0;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					document_insert (self, &cur_iter, "% ", -1);
				}
				_g_free0 (line_contents);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_uncomment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	gint start_line;
	gint _tmp3_;
	gint end_line;
	gint _tmp4_;
	gint line_count;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&start);
	start_line = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&end);
	end_line = _tmp3_;
	_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	line_count = _tmp4_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i;
		i = start_line;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkTextIter _tmp6_ = {0};
				gchar* _tmp9_ = NULL;
				gchar* line;
				gint j;
				gint start_delete;
				gint stop_delete;
				GtkTextIter _tmp16_ = {0};
				GtkTextIter _tmp17_ = {0};
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i <= end_line)) {
					break;
				}
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp6_, i);
				start = _tmp6_;
				if (i == (line_count - 1)) {
					GtkTextIter _tmp7_ = {0};
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp7_);
					end = _tmp7_;
				} else {
					GtkTextIter _tmp8_ = {0};
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp8_, i + 1);
					end = _tmp8_;
				}
				_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start, &end, FALSE);
				line = _tmp9_;
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					gchar _tmp10_;
					gchar _tmp11_;
					_tmp10_ = string_get (line, (glong) j);
					if (!(_tmp10_ != '\0')) {
						break;
					}
					_tmp11_ = string_get (line, (glong) j);
					if (_tmp11_ == '%') {
						gchar _tmp12_;
						start_delete = j;
						stop_delete = j + 1;
						_tmp12_ = string_get (line, (glong) (j + 1));
						if (_tmp12_ == ' ') {
							stop_delete++;
						}
						break;
					} else {
						gboolean _tmp13_ = FALSE;
						gchar _tmp14_;
						_tmp14_ = string_get (line, (glong) j);
						if (_tmp14_ != ' ') {
							gchar _tmp15_;
							_tmp15_ = string_get (line, (glong) j);
							_tmp13_ = _tmp15_ != '\t';
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							break;
						}
					}
					j++;
				}
				if (start_delete == (-1)) {
					_g_free0 (line);
					continue;
				}
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp16_, i, start_delete);
				start = _tmp16_;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp17_, i, stop_delete);
				end = _tmp17_;
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				_g_free0 (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_select_lines (Document* self, gint start, gint end) {
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	DocumentView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, start);
	start_iter = _tmp0_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp1_, end);
	end_iter = _tmp1_;
	gtk_text_buffer_select_range ((GtkTextBuffer*) self, &start_iter, &end_iter);
	_tmp2_ = document_tab_get_view (self->tab);
	document_view_scroll_to_cursor (_tmp2_, 0.25);
}


SelectionType document_get_selection_type (Document* self) {
	SelectionType result = 0;
	gboolean _tmp0_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	if (!_tmp0_) {
		result = SELECTION_TYPE_NO_SELECTION;
		return result;
	}
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&start);
	_tmp4_ = gtk_text_iter_get_line (&end);
	if (_tmp3_ == _tmp4_) {
		result = SELECTION_TYPE_ONE_LINE;
		return result;
	}
	result = SELECTION_TYPE_MULTIPLE_LINES;
	return result;
}


gboolean document_goto_line (Document* self, gint line) {
	gboolean result = FALSE;
	gboolean ret;
	GtkTextIter iter = {0};
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line >= (-1), FALSE);
	ret = TRUE;
	_tmp0_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	if (line >= _tmp0_) {
		GtkTextIter _tmp1_ = {0};
		ret = FALSE;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp1_);
		iter = _tmp1_;
	} else {
		GtkTextIter _tmp2_ = {0};
		gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, line);
		iter = _tmp2_;
	}
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &iter);
	result = ret;
	return result;
}


Project* document_get_project (Document* self) {
	Project* result = NULL;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	Project* _tmp2_ = NULL;
	Project* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_project_id == (-1)) {
		result = NULL;
		return result;
	}
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = projects_get (_tmp1_, self->priv->_project_id);
	_tmp3_ = _tmp2_;
	_projects_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


GFile* document_get_main_file (Document* self) {
	GFile* result = NULL;
	Project* _tmp0_ = NULL;
	Project* project;
	GFile* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_location == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = document_get_project (self);
	project = _tmp0_;
	if (project == NULL) {
		GFile* _tmp1_;
		_tmp1_ = _g_object_ref0 (self->priv->_location);
		result = _tmp1_;
		_project_free0 (project);
		return result;
	}
	_tmp2_ = _g_object_ref0 ((*project).main_file);
	result = _tmp2_;
	_project_free0 (project);
	return result;
}


gboolean document_is_main_file_a_tex_file (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* main_file;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_main_file (self);
	main_file = _tmp0_;
	if (main_file == NULL) {
		result = FALSE;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp1_ = g_file_get_parse_name (main_file);
	path = _tmp1_;
	_tmp2_ = g_str_has_suffix (path, ".tex");
	result = _tmp2_;
	_g_free0 (path);
	_g_object_unref0 (main_file);
	return result;
}


gchar* document_get_current_indentation (Document* self, gint line) {
	gchar* result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gchar* text;
	gchar* _tmp3_;
	gchar* current_indent;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, line);
	start_iter = _tmp0_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp1_, line + 1);
	end_iter = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &start_iter, &end_iter, FALSE);
	text = _tmp2_;
	_tmp3_ = g_strdup ("");
	current_indent = _tmp3_;
	{
		glong i;
		i = (glong) 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gboolean _tmp6_ = FALSE;
				gchar _tmp7_;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				_tmp5_ = strlen (text);
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp7_ = string_get (text, i);
				if (_tmp7_ == ' ') {
					_tmp6_ = TRUE;
				} else {
					gchar _tmp8_;
					_tmp8_ = string_get (text, i);
					_tmp6_ = _tmp8_ == '\t';
				}
				if (_tmp6_) {
					gchar _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp9_ = string_get (text, i);
					_tmp10_ = g_strdup_printf ("%c", _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (current_indent, _tmp11_, NULL);
					_g_free0 (current_indent);
					current_indent = _tmp12_;
					_g_free0 (_tmp11_);
				} else {
					break;
				}
			}
		}
	}
	result = current_indent;
	_g_free0 (text);
	return result;
}


DocumentStructure* document_get_structure (Document* self) {
	DocumentStructure* result = NULL;
	DocumentStructure* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_structure == NULL) {
		DocumentStructure* _tmp0_ = NULL;
		_tmp0_ = document_structure_new (self);
		_g_object_unref0 (self->priv->_structure);
		self->priv->_structure = _tmp0_;
		document_structure_parse (self->priv->_structure);
	}
	_tmp1_ = _g_object_ref0 (self->priv->_structure);
	result = _tmp1_;
	return result;
}


/***************
     *    SEARCH
     ***************/
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self) {
	document_search_cursor_moved_handler (self);
}


static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_before_handler (self, start, end);
}


static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_after_handler (self, start);
}


static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self) {
	document_search_insert_text_before_handler (self, pos);
}


static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* text, gint length, gpointer self) {
	document_search_insert_text_after_handler (self, pos, text, length);
}


void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select) {
	guint _nb_matches = 0U;
	guint _num_match = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter match_start;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter match_end;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter insert;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter try_match_start;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter try_match_end;
	GtkTextIter _tmp9_ = {0};
	GtkTextMark* _tmp10_ = NULL;
	GtkTextIter _tmp11_ = {0};
	gboolean next_match_after_cursor_found;
	guint i;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->search_text == NULL) {
		g_signal_connect_object (self, "cursor-moved", (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self, G_CONNECT_AFTER);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self, G_CONNECT_AFTER);
	}
	if (g_strcmp0 (self->priv->search_text, text) == 0) {
		_tmp1_ = self->priv->search_case_sensitive == case_sensitive;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->search_entire_word == entire_word;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_nb_matches = self->priv->search_nb_matches;
		_num_match = self->priv->search_num_match;
		if (nb_matches) {
			*nb_matches = _nb_matches;
		}
		if (num_match) {
			*num_match = _num_match;
		}
		return;
	}
	document_invalidate_search_selected_marks (self);
	document_clear_search (self, FALSE);
	_tmp2_ = g_strdup (text);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = _tmp2_;
	self->priv->search_case_sensitive = case_sensitive;
	self->priv->search_entire_word = entire_word;
	start = _tmp3_;
	match_start = _tmp4_;
	match_end = _tmp5_;
	insert = _tmp6_;
	try_match_start = _tmp7_;
	try_match_end = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp9_);
	start = _tmp9_;
	_tmp10_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
	insert = _tmp11_;
	next_match_after_cursor_found = !select;
	i = (guint) 0;
	while (TRUE) {
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		gboolean _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = document_iter_forward_search (self, &start, NULL, &_tmp12_, &_tmp13_);
		try_match_start = _tmp12_;
		try_match_end = _tmp13_;
		if (!_tmp14_) {
			break;
		}
		match_start = try_match_start;
		match_end = try_match_end;
		if (!next_match_after_cursor_found) {
			gint _tmp16_;
			_tmp16_ = gtk_text_iter_compare (&insert, &match_end);
			_tmp15_ = _tmp16_ <= 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			next_match_after_cursor_found = TRUE;
			_num_match = i;
			self->priv->search_num_match = _num_match;
			document_move_search_marks (self, &match_start, &match_end, TRUE);
		} else {
			gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
		}
		start = match_end;
		i++;
	}
	if (!next_match_after_cursor_found) {
		_tmp17_ = i > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_num_match = i;
		self->priv->search_num_match = _num_match;
		document_move_search_marks (self, &match_start, &match_end, TRUE);
	}
	_nb_matches = i;
	self->priv->search_nb_matches = _nb_matches;
	if (self->priv->search_nb_matches == 0) {
		document_clear_search_tags (self);
	}
	if (nb_matches) {
		*nb_matches = _nb_matches;
	}
	if (num_match) {
		*num_match = _num_match;
	}
}


void document_select_selected_search_text (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextMark* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &start);
	_tmp4_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "selection_bound");
	gtk_text_buffer_move_mark ((GtkTextBuffer*) self, _tmp4_, &end);
}


void document_search_forward (Document* self) {
	GtkTextIter start_search = {0};
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean increment;
	gboolean _tmp3_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	if (self->priv->search_nb_matches == 0) {
		return;
	}
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start_search = _tmp1_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp2_);
	start = _tmp2_;
	increment = FALSE;
	_tmp3_ = gtk_text_iter_has_tag (&start_search, self->priv->found_tag_selected);
	if (_tmp3_) {
		GtkTextMark* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		_tmp4_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		start_search = _tmp5_;
		increment = TRUE;
	}
	document_replace_found_tag_selected (self);
	_tmp8_ = document_iter_forward_search (self, &start_search, NULL, &_tmp6_, &_tmp7_);
	match_start = _tmp6_;
	match_end = _tmp7_;
	if (_tmp8_) {
		document_move_search_marks (self, &match_start, &match_end, TRUE);
		if (increment) {
			self->priv->search_num_match++;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	} else {
		GtkTextIter _tmp9_ = {0};
		GtkTextIter _tmp10_ = {0};
		gboolean _tmp11_;
		_tmp11_ = document_iter_forward_search (self, &start, NULL, &_tmp9_, &_tmp10_);
		match_start = _tmp9_;
		match_end = _tmp10_;
		if (_tmp11_) {
			document_move_search_marks (self, &match_start, &match_end, TRUE);
			self->priv->search_num_match = (guint) 1;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	}
	document_find_num_match (self);
}


void document_search_backward (Document* self) {
	GtkTextIter start_search = {0};
	GtkTextIter end = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean decrement;
	gboolean move_cursor;
	GtkTextIter start_prev;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_ = {0};
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	if (self->priv->search_nb_matches == 0) {
		return;
	}
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start_search = _tmp1_;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp2_);
	end = _tmp2_;
	decrement = FALSE;
	move_cursor = TRUE;
	start_prev = start_search;
	gtk_text_iter_backward_char (&start_prev);
	_tmp4_ = gtk_text_iter_has_tag (&start_search, self->priv->found_tag_selected);
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = gtk_text_iter_has_tag (&start_prev, self->priv->found_tag_selected);
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		GtkTextMark* _tmp6_ = NULL;
		GtkTextIter _tmp7_ = {0};
		_tmp6_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp7_, _tmp6_);
		start_search = _tmp7_;
		decrement = TRUE;
	} else {
		gboolean _tmp8_;
		_tmp8_ = gtk_text_iter_has_tag (&start_search, self->priv->found_tag);
		if (_tmp8_) {
			gint _tmp9_;
			move_cursor = FALSE;
			_tmp9_ = strlen (self->priv->search_text);
			gtk_text_iter_forward_chars (&start_search, (gint) _tmp9_);
		} else {
			gboolean _tmp10_;
			_tmp10_ = gtk_text_iter_has_tag (&start_prev, self->priv->found_tag);
			if (_tmp10_) {
				move_cursor = FALSE;
			}
		}
	}
	document_replace_found_tag_selected (self);
	_tmp13_ = document_iter_backward_search (self, &start_search, NULL, &_tmp11_, &_tmp12_);
	match_start = _tmp11_;
	match_end = _tmp12_;
	if (_tmp13_) {
		document_move_search_marks (self, &match_start, &match_end, move_cursor);
		if (decrement) {
			self->priv->search_num_match--;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	} else {
		GtkTextIter _tmp14_ = {0};
		GtkTextIter _tmp15_ = {0};
		gboolean _tmp16_;
		_tmp16_ = document_iter_backward_search (self, &end, NULL, &_tmp14_, &_tmp15_);
		match_start = _tmp14_;
		match_end = _tmp15_;
		if (_tmp16_) {
			document_move_search_marks (self, &match_start, &match_end, TRUE);
			self->priv->search_num_match = self->priv->search_nb_matches;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
			return;
		}
	}
	document_find_num_match (self);
}


static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	GtkTextIter _match_start = {0};
	GtkTextIter _match_end = {0};
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		GtkSourceSearchFlags _tmp0_;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter _tmp2_ = {0};
		gboolean _tmp3_;
		gboolean _tmp4_ = FALSE;
		if (!(!found)) {
			break;
		}
		_tmp0_ = document_get_search_flags (self);
		_tmp3_ = gtk_source_iter_forward_search (start, self->priv->search_text, _tmp0_, &_tmp1_, &_tmp2_, end);
		_match_start = _tmp1_;
		_match_end = _tmp2_;
		found = _tmp3_;
		if (found) {
			_tmp4_ = self->priv->search_entire_word;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp6_ = gtk_text_iter_starts_word (&_match_start);
			if (_tmp6_) {
				gboolean _tmp7_;
				_tmp7_ = gtk_text_iter_ends_word (&_match_end);
				_tmp5_ = _tmp7_;
			} else {
				_tmp5_ = FALSE;
			}
			found = _tmp5_;
			if (!found) {
				*start = _match_end;
			}
		} else {
			break;
		}
	}
	result = found;
	if (match_start) {
		*match_start = _match_start;
	}
	if (match_end) {
		*match_end = _match_end;
	}
	return result;
}


static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	GtkTextIter _match_start = {0};
	GtkTextIter _match_end = {0};
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		GtkSourceSearchFlags _tmp0_;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter _tmp2_ = {0};
		gboolean _tmp3_;
		gboolean _tmp4_ = FALSE;
		if (!(!found)) {
			break;
		}
		_tmp0_ = document_get_search_flags (self);
		_tmp3_ = gtk_source_iter_backward_search (start, self->priv->search_text, _tmp0_, &_tmp1_, &_tmp2_, end);
		_match_start = _tmp1_;
		_match_end = _tmp2_;
		found = _tmp3_;
		if (found) {
			_tmp4_ = self->priv->search_entire_word;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp6_ = gtk_text_iter_starts_word (&_match_start);
			if (_tmp6_) {
				gboolean _tmp7_;
				_tmp7_ = gtk_text_iter_ends_word (&_match_end);
				_tmp5_ = _tmp7_;
			} else {
				_tmp5_ = FALSE;
			}
			found = _tmp5_;
			if (!found) {
				*start = _match_start;
			}
		} else {
			break;
		}
	}
	result = found;
	if (match_start) {
		*match_start = _match_start;
	}
	if (match_end) {
		*match_end = _match_end;
	}
	return result;
}


void document_clear_search (Document* self, gboolean disconnect_signals) {
	g_return_if_fail (self != NULL);
	document_clear_search_tags (self);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = NULL;
	if (disconnect_signals) {
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		g_signal_parse_name ("cursor-moved", TYPE_DOCUMENT, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self);
	}
}


static void document_clear_search_tags (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	document_invalidate_search_selected_marks (self);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &start, &end);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &start, &end);
}


static void document_search_cursor_moved_handler (Document* self) {
	GtkTextIter insert = {0};
	GtkTextIter insert_previous = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	insert = _tmp1_;
	insert_previous = insert;
	gtk_text_iter_backward_char (&insert_previous);
	_tmp3_ = gtk_text_iter_has_tag (&insert, self->priv->found_tag_selected);
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = gtk_text_iter_has_tag (&insert_previous, self->priv->found_tag_selected);
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		return;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	_tmp6_ = gtk_text_iter_has_tag (&insert, self->priv->found_tag);
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_;
		_tmp7_ = gtk_text_iter_has_tag (&insert_previous, self->priv->found_tag);
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		document_search_backward (self);
	} else {
		g_signal_emit_by_name (self, "search-info-updated", FALSE, self->priv->search_nb_matches, (guint) 0);
	}
}


static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	start_search = *start;
	_tmp0_ = strlen (self->priv->search_text);
	gtk_text_iter_backward_chars (&start_search, ((gint) _tmp0_) - 1);
	stop_search = *end;
	_tmp1_ = strlen (self->priv->search_text);
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp1_) - 1);
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	while (TRUE) {
		GtkTextIter _tmp2_ = {0};
		GtkTextIter _tmp3_ = {0};
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
		gint _tmp6_;
		_tmp4_ = document_iter_forward_search (self, &start_search, &stop_search, &_tmp2_, &_tmp3_);
		match_start = _tmp2_;
		match_end = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp6_ = gtk_text_iter_compare (&match_start, start);
		if (_tmp6_ < 0) {
			_tmp5_ = TRUE;
		} else {
			gint _tmp7_;
			_tmp7_ = gtk_text_iter_compare (&match_end, end);
			_tmp5_ = _tmp7_ > 0;
		}
		if (_tmp5_) {
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &match_start, &match_end);
		}
		self->priv->search_nb_matches--;
		start_search = match_end;
	}
}


static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	stop_search = *location;
	start_search = stop_search;
	_tmp0_ = strlen (self->priv->search_text);
	gtk_text_iter_backward_chars (&start_search, ((gint) _tmp0_) - 1);
	_tmp1_ = strlen (self->priv->search_text);
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp1_) - 1);
	document_search_matches_between (self, &start_search, &stop_search);
}


static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gtk_text_iter_has_tag (location, self->priv->found_tag);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = gtk_text_iter_has_tag (location, self->priv->found_tag_selected);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		GtkTextIter start_search = {0};
		GtkTextIter match_start = {0};
		GtkTextIter match_end = {0};
		gint _tmp3_;
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_;
		document_replace_found_tag_selected (self);
		document_invalidate_search_selected_marks (self);
		start_search = *location;
		_tmp3_ = strlen (self->priv->search_text);
		gtk_text_iter_forward_chars (&start_search, ((gint) _tmp3_) - 1);
		_tmp6_ = document_iter_backward_search (self, &start_search, NULL, &_tmp4_, &_tmp5_);
		match_start = _tmp4_;
		match_end = _tmp5_;
		if (_tmp6_) {
			gint _tmp7_;
			_tmp7_ = gtk_text_iter_compare (location, &match_end);
			if (_tmp7_ < 0) {
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &match_start, &match_end);
				self->priv->search_nb_matches--;
			}
		}
	}
}


static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const gchar* text, gint len) {
	GtkTextIter left_text;
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	left_text = *location;
	gtk_text_iter_backward_chars (&left_text, len);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, &left_text, location);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &left_text, location);
	stop_search = *location;
	start_search = stop_search;
	_tmp0_ = strlen (self->priv->search_text);
	gtk_text_iter_backward_chars (&start_search, (len + ((gint) _tmp0_)) - 1);
	_tmp1_ = strlen (self->priv->search_text);
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp1_) - 1);
	document_search_matches_between (self, &start_search, &stop_search);
}


static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search) {
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter _tmp1_ = {0};
		gboolean _tmp2_;
		_tmp2_ = document_iter_forward_search (self, start_search, stop_search, &_tmp0_, &_tmp1_);
		match_start = _tmp0_;
		match_end = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &match_start, &match_end);
		self->priv->search_nb_matches++;
		*start_search = match_end;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	document_search_cursor_moved_handler (self);
}


static GtkSourceSearchFlags document_get_search_flags (Document* self) {
	GtkSourceSearchFlags result = 0;
	GtkSourceSearchFlags flags;
	g_return_val_if_fail (self != NULL, 0);
	flags = GTK_SOURCE_SEARCH_TEXT_ONLY | GTK_SOURCE_SEARCH_VISIBLE_ONLY;
	if (!self->priv->search_case_sensitive) {
		flags = flags | GTK_SOURCE_SEARCH_CASE_INSENSITIVE;
	}
	result = flags;
	return result;
}


static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag, start, end);
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, start, end);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", start);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", end);
	if (move_cursor) {
		DocumentView* _tmp0_ = NULL;
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, start);
		_tmp0_ = document_tab_get_view (self->tab);
		document_view_scroll_to_cursor (_tmp0_, 0.25);
	}
}


static void document_replace_found_tag_selected (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, self->priv->found_tag_selected, &start, &end);
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, self->priv->found_tag, &start, &end);
}


static void document_find_num_match (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter stop = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextMark* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	guint i;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	_tmp1_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	stop = _tmp2_;
	i = (guint) 0;
	while (TRUE) {
		GtkTextIter _tmp3_ = {0};
		gboolean _tmp4_;
		_tmp4_ = document_iter_forward_search (self, &start, &stop, NULL, &_tmp3_);
		match_end = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		i++;
		start = match_end;
	}
	self->priv->search_num_match = i + 1;
	g_signal_emit_by_name (self, "search-info-updated", TRUE, self->priv->search_nb_matches, self->priv->search_num_match);
}


static void document_invalidate_search_selected_marks (Document* self) {
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	iter = _tmp0_;
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", &iter);
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", &iter);
}


static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag) {
	GtkSourceStyleScheme* _tmp0_ = NULL;
	GtkSourceStyleScheme* _tmp1_;
	GtkSourceStyleScheme* style_scheme;
	GtkSourceStyle* style;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	PangoWeight _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_;
	PangoStyle _tmp27_ = 0;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_;
	PangoUnderline _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text_tag != NULL);
	_tmp0_ = gtk_source_buffer_get_style_scheme ((GtkSourceBuffer*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_scheme = _tmp1_;
	style = NULL;
	if (style_scheme != NULL) {
		GtkSourceStyle* _tmp2_ = NULL;
		GtkSourceStyle* _tmp3_;
		_tmp2_ = gtk_source_style_scheme_get_style (style_scheme, "search-match");
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (style);
		style = _tmp3_;
	}
	if (style_scheme == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = style == NULL;
	}
	if (_tmp4_) {
		g_object_set (text_tag, "background", "#FFFF78", NULL);
		_g_object_unref0 (style);
		_g_object_unref0 (style_scheme);
		return;
	}
	g_object_get (style, "foreground-set", &_tmp6_, NULL);
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		g_object_get (style, "foreground", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_ != NULL;
		_g_free0 (_tmp8_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		g_object_get (style, "foreground", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		g_object_set (text_tag, "foreground", _tmp10_, NULL);
		_g_free0 (_tmp10_);
	} else {
		g_object_set (text_tag, "foreground", NULL, NULL);
	}
	g_object_get (style, "background-set", &_tmp12_, NULL);
	if (_tmp12_) {
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		g_object_get (style, "background", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_ != NULL;
		_g_free0 (_tmp14_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		g_object_get (style, "background", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		g_object_set (text_tag, "background", _tmp16_, NULL);
		_g_free0 (_tmp16_);
	} else {
		g_object_set (text_tag, "background", NULL, NULL);
	}
	g_object_get (style, "line-background-set", &_tmp18_, NULL);
	if (_tmp18_) {
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		g_object_get (style, "line-background", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		_tmp17_ = _tmp20_ != NULL;
		_g_free0 (_tmp20_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		g_object_get (style, "line-background", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		g_object_set (text_tag, "paragraph-background", _tmp22_, NULL);
		_g_free0 (_tmp22_);
	} else {
		g_object_set (text_tag, "paragraph-background", NULL, NULL);
	}
	g_object_get (style, "bold-set", &_tmp25_, NULL);
	if (_tmp25_) {
		gboolean _tmp26_;
		g_object_get (style, "bold", &_tmp26_, NULL);
		_tmp24_ = _tmp26_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		_tmp23_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp23_ = PANGO_WEIGHT_NORMAL;
	}
	g_object_set (text_tag, "weight", (gint) _tmp23_, NULL);
	g_object_get (style, "italic-set", &_tmp29_, NULL);
	if (_tmp29_) {
		gboolean _tmp30_;
		g_object_get (style, "italic", &_tmp30_, NULL);
		_tmp28_ = _tmp30_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		_tmp27_ = PANGO_STYLE_ITALIC;
	} else {
		_tmp27_ = PANGO_STYLE_NORMAL;
	}
	g_object_set (text_tag, "style", _tmp27_, NULL);
	g_object_get (style, "underline-set", &_tmp33_, NULL);
	if (_tmp33_) {
		gboolean _tmp34_;
		g_object_get (style, "underline", &_tmp34_, NULL);
		_tmp32_ = _tmp34_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		_tmp31_ = PANGO_UNDERLINE_SINGLE;
	} else {
		_tmp31_ = PANGO_UNDERLINE_NONE;
	}
	g_object_set (text_tag, "underline", _tmp31_, NULL);
	g_object_get (style, "strikethrough-set", &_tmp36_, NULL);
	if (_tmp36_) {
		gboolean _tmp37_;
		g_object_get (style, "strikethrough", &_tmp37_, NULL);
		_tmp35_ = _tmp37_;
	} else {
		_tmp35_ = FALSE;
	}
	g_object_set (text_tag, "strikethrough", _tmp35_, NULL);
	_g_object_unref0 (style);
	_g_object_unref0 (style_scheme);
}


static void document_sync_found_tags (Document* self) {
	g_return_if_fail (self != NULL);
	document_set_search_match_colors (self, self->priv->found_tag);
	document_set_search_match_colors (self, self->priv->found_tag_selected);
	g_object_set (self->priv->found_tag_selected, "background", "#FF8C00", NULL);
}


/****************
     *    REPLACE
     ****************/
void document_replace (Document* self, const gchar* text) {
	GtkTextIter insert = {0};
	GtkTextIter insert_prev = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextMark* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	g_return_if_fail (!self->priv->_readonly);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	insert = _tmp1_;
	insert_prev = insert;
	gtk_text_iter_backward_char (&insert_prev);
	_tmp3_ = gtk_text_iter_has_tag (&insert, self->priv->found_tag_selected);
	if (!_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = gtk_text_iter_has_tag (&insert_prev, self->priv->found_tag_selected);
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		document_search_forward (self);
		return;
	}
	_tmp5_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp6_, _tmp5_);
	start = _tmp6_;
	_tmp7_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp8_, _tmp7_);
	end = _tmp8_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
	document_insert (self, &start, text, -1);
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	_tmp9_ = gtk_text_iter_has_tag (&start, self->priv->found_tag_selected);
	if (!_tmp9_) {
		document_search_forward (self);
	}
}


void document_replace_all (Document* self, const gchar* text) {
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (self->priv->search_text != NULL);
	g_return_if_fail (!self->priv->_readonly);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	self->priv->stop_cursor_moved_emission = TRUE;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	while (TRUE) {
		GtkTextIter _tmp1_ = {0};
		GtkTextIter _tmp2_ = {0};
		gboolean _tmp3_;
		_tmp3_ = document_iter_forward_search (self, &start, NULL, &_tmp1_, &_tmp2_);
		match_start = _tmp1_;
		match_end = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &match_start, &match_end);
		document_insert (self, &match_start, text, -1);
		start = match_start;
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	self->priv->stop_cursor_moved_emission = FALSE;
	document_emit_cursor_moved (self);
}


GFile* document_get_location (Document* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_location;
	return result;
}


void document_set_location (Document* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_location);
	self->priv->_location = _tmp0_;
	g_object_notify ((GObject *) self, "location");
}


gboolean document_get_readonly (Document* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readonly;
	return result;
}


void document_set_readonly (Document* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_readonly = value;
	g_object_notify ((GObject *) self, "readonly");
}


gint document_get_project_id (Document* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_project_id;
	return result;
}


void document_set_project_id (Document* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_project_id = value;
	g_object_notify ((GObject *) self, "project-id");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (gpointer data1, gboolean arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void document_class_init (DocumentClass * klass) {
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY, g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID, g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("search_info_updated", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("cursor_moved", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_instance_init (Document * self) {
	self->priv = DOCUMENT_GET_PRIVATE (self);
	self->priv->_readonly = FALSE;
	self->_unsaved_doc_num = (guint) 0;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->_structure = NULL;
	self->priv->stop_cursor_moved_emission = FALSE;
}


static void document_finalize (GObject* obj) {
	Document * self;
	self = DOCUMENT (obj);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->tab);
	_g_free0 (self->priv->_etag);
	_g_free0 (self->priv->encoding);
	_g_object_unref0 (self->priv->_structure);
	_g_object_unref0 (self->priv->found_tag);
	_g_object_unref0 (self->priv->found_tag_selected);
	_g_free0 (self->priv->search_text);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}


GType document_get_type (void) {
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (GTK_TYPE_SOURCE_BUFFER, "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Document * self;
	self = DOCUMENT (object);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_PROJECT_ID:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Document * self;
	self = DOCUMENT (object);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_PROJECT_ID:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



