/* build_tools.c generated by valac 0.12.1, the Vala compiler
 * generated from build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_DOC_TYPE (doc_type_get_type ())

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
typedef struct _BuildToolsPrivate BuildToolsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBuildTools ParamSpecBuildTools;

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};

typedef enum  {
	DOC_TYPE_DVI,
	DOC_TYPE_PDF,
	DOC_TYPE_PS,
	DOC_TYPE_LAST
} DocType;

struct _BuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BuildToolsPrivate * priv;
};

struct _BuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (BuildTools *self);
};

struct _BuildToolsPrivate {
	GeeLinkedList* build_tools;
	BuildTool cur_tool;
	BuildJob cur_job;
	gboolean modified;
};

struct _ParamSpecBuildTools {
	GParamSpec parent_instance;
};


static gpointer build_tools_parent_class = NULL;
static BuildTools* build_tools_instance;
static BuildTools* build_tools_instance = NULL;
static gchar** build_tools__post_processor_names;
static gint build_tools__post_processor_names_length1;
static gchar** build_tools__post_processor_names = NULL;
static gint build_tools__post_processor_names_length1 = 0;
static gint _build_tools__post_processor_names_size_ = 0;

GType post_processor_type_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GType doc_type_get_type (void) G_GNUC_CONST;
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS, BuildToolsPrivate))
enum  {
	BUILD_TOOLS_DUMMY_PROPERTY
};
static BuildTools* build_tools_new (void);
static BuildTools* build_tools_construct (GType object_type);
static void build_tools_load (BuildTools* self);
BuildTools* build_tools_get_default (void);
BuildTool* build_tools_get (BuildTools* self, gint id);
GeeIterator* build_tools_iterator (BuildTools* self);
BuildTool* build_tools_get_view_doc (BuildTools* self, DocType type);
gboolean build_tools_is_empty (BuildTools* self);
void build_tools_move_up (BuildTools* self, gint num);
static void build_tools_swap (BuildTools* self, gint num1, gint num2);
void build_tools_move_down (BuildTools* self, gint num);
static void build_tools_update_all_menus (BuildTools* self);
void build_tools_delete (BuildTools* self, gint num);
void build_tools_add (BuildTools* self, BuildTool* tool);
void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool);
static gboolean build_tools_is_compilation (BuildTools* self, const gchar* icon);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static gboolean build_tools_is_equal (BuildTools* self, BuildTool* tool1, BuildTool* tool2);
void build_tools_reset_all (BuildTools* self);
static GFile* build_tools_get_user_config_file (BuildTools* self);
void utils_delete_file (GFile* file);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
GList* application_get_windows (Application* self);
void main_window_update_build_tools_menu (MainWindow* self);
static void _vala_array_add7 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value);
static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
void build_tools_save (BuildTools* self);
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
static PostProcessorType* _post_processor_type_dup (PostProcessorType* self);
static void build_tools_finalize (BuildTools* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType post_processor_type_get_type (void) {
	static volatile gsize post_processor_type_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_type_id__volatile)) {
		static const GEnumValue values[] = {{POST_PROCESSOR_TYPE_ALL_OUTPUT, "POST_PROCESSOR_TYPE_ALL_OUTPUT", "all-output"}, {POST_PROCESSOR_TYPE_LATEX, "POST_PROCESSOR_TYPE_LATEX", "latex"}, {POST_PROCESSOR_TYPE_LATEXMK, "POST_PROCESSOR_TYPE_LATEXMK", "latexmk"}, {POST_PROCESSOR_TYPE_NO_OUTPUT, "POST_PROCESSOR_TYPE_NO_OUTPUT", "no-output"}, {POST_PROCESSOR_TYPE_RUBBER, "POST_PROCESSOR_TYPE_RUBBER", "rubber"}, {POST_PROCESSOR_TYPE_N_POST_PROCESSORS, "POST_PROCESSOR_TYPE_N_POST_PROCESSORS", "n-post-processors"}, {0, NULL, NULL}};
		GType post_processor_type_type_id;
		post_processor_type_type_id = g_enum_register_static ("PostProcessorType", values);
		g_once_init_leave (&post_processor_type_type_id__volatile, post_processor_type_type_id);
	}
	return post_processor_type_type_id__volatile;
}


void build_job_copy (const BuildJob* self, BuildJob* dest) {
	dest->must_succeed = self->must_succeed;
	dest->post_processor = self->post_processor;
	dest->command = g_strdup (self->command);
}


void build_job_destroy (BuildJob* self) {
	_g_free0 ((*self).command);
}


BuildJob* build_job_dup (const BuildJob* self) {
	BuildJob* dup;
	dup = g_new0 (BuildJob, 1);
	build_job_copy (self, dup);
	return dup;
}


void build_job_free (BuildJob* self) {
	build_job_destroy (self);
	g_free (self);
}


GType build_job_get_type (void) {
	static volatile gsize build_job_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_type_id__volatile)) {
		GType build_job_type_id;
		build_job_type_id = g_boxed_type_register_static ("BuildJob", (GBoxedCopyFunc) build_job_dup, (GBoxedFreeFunc) build_job_free);
		g_once_init_leave (&build_job_type_id__volatile, build_job_type_id);
	}
	return build_job_type_id__volatile;
}


void build_tool_copy (const BuildTool* self, BuildTool* dest) {
	dest->description = g_strdup (self->description);
	dest->extensions = g_strdup (self->extensions);
	dest->label = g_strdup (self->label);
	dest->icon = g_strdup (self->icon);
	dest->show = self->show;
	dest->compilation = self->compilation;
	dest->jobs = self->jobs;
}


void build_tool_destroy (BuildTool* self) {
	_g_free0 ((*self).description);
	_g_free0 ((*self).extensions);
	_g_free0 ((*self).label);
	_g_free0 ((*self).icon);
}


BuildTool* build_tool_dup (const BuildTool* self) {
	BuildTool* dup;
	dup = g_new0 (BuildTool, 1);
	build_tool_copy (self, dup);
	return dup;
}


void build_tool_free (BuildTool* self) {
	build_tool_destroy (self);
	g_free (self);
}


GType build_tool_get_type (void) {
	static volatile gsize build_tool_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_type_id__volatile)) {
		GType build_tool_type_id;
		build_tool_type_id = g_boxed_type_register_static ("BuildTool", (GBoxedCopyFunc) build_tool_dup, (GBoxedFreeFunc) build_tool_free);
		g_once_init_leave (&build_tool_type_id__volatile, build_tool_type_id);
	}
	return build_tool_type_id__volatile;
}


GType doc_type_get_type (void) {
	static volatile gsize doc_type_type_id__volatile = 0;
	if (g_once_init_enter (&doc_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DOC_TYPE_DVI, "DOC_TYPE_DVI", "dvi"}, {DOC_TYPE_PDF, "DOC_TYPE_PDF", "pdf"}, {DOC_TYPE_PS, "DOC_TYPE_PS", "ps"}, {DOC_TYPE_LAST, "DOC_TYPE_LAST", "last"}, {0, NULL, NULL}};
		GType doc_type_type_id;
		doc_type_type_id = g_enum_register_static ("DocType", values);
		g_once_init_leave (&doc_type_type_id__volatile, doc_type_type_id);
	}
	return doc_type_type_id__volatile;
}


static BuildTools* build_tools_construct (GType object_type) {
	BuildTools* self = NULL;
	self = (BuildTools*) g_type_create_instance (object_type);
	build_tools_load (self);
	return self;
}


static BuildTools* build_tools_new (void) {
	return build_tools_construct (TYPE_BUILD_TOOLS);
}


static gpointer _build_tools_ref0 (gpointer self) {
	return self ? build_tools_ref (self) : NULL;
}


BuildTools* build_tools_get_default (void) {
	BuildTools* result = NULL;
	BuildTools* _tmp1_;
	if (build_tools_instance == NULL) {
		BuildTools* _tmp0_ = NULL;
		_tmp0_ = build_tools_new ();
		_build_tools_unref0 (build_tools_instance);
		build_tools_instance = _tmp0_;
	}
	_tmp1_ = _build_tools_ref0 (build_tools_instance);
	result = _tmp1_;
	return result;
}


BuildTool* build_tools_get (BuildTools* self, gint id) {
	BuildTool* result = NULL;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (id >= 0) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = id < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, id);
	result = (BuildTool*) _tmp2_;
	return result;
}


GeeIterator* build_tools_iterator (BuildTools* self) {
	GeeIterator* result = NULL;
	GeeIterator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->build_tools);
	result = GEE_ITERATOR (_tmp0_);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _build_tool_dup0 (gpointer self) {
	return self ? build_tool_dup (self) : NULL;
}


BuildTool* build_tools_get_view_doc (BuildTools* self, DocType type) {
	BuildTool* result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** icon;
	gint icon_length1;
	gint _icon_size_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, DOC_TYPE_LAST + 1);
	icon = _tmp0_;
	icon_length1 = DOC_TYPE_LAST;
	_icon_size_ = DOC_TYPE_LAST;
	_tmp1_ = g_strdup ("view_dvi");
	_tmp2_ = _tmp1_;
	_g_free0 (icon[DOC_TYPE_DVI]);
	icon[DOC_TYPE_DVI] = _tmp2_;
	_tmp3_ = g_strdup ("view_pdf");
	_tmp4_ = _tmp3_;
	_g_free0 (icon[DOC_TYPE_PDF]);
	icon[DOC_TYPE_PDF] = _tmp4_;
	_tmp5_ = g_strdup ("view_ps");
	_tmp6_ = _tmp5_;
	_g_free0 (icon[DOC_TYPE_PS]);
	icon[DOC_TYPE_PS] = _tmp6_;
	{
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _build_tool_list;
		gint _tmp8_;
		gint _build_tool_size;
		gint _build_tool_index;
		_tmp7_ = _g_object_ref0 (self->priv->build_tools);
		_build_tool_list = _tmp7_;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _build_tool_list);
		_build_tool_size = _tmp8_;
		_build_tool_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			BuildTool* _tmp10_;
			BuildTool _tmp11_;
			BuildTool _tmp12_ = {0};
			BuildTool _tmp13_;
			BuildTool build_tool;
			_build_tool_index = _build_tool_index + 1;
			if (!(_build_tool_index < _build_tool_size)) {
				break;
			}
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _build_tool_list, _build_tool_index);
			_tmp10_ = (BuildTool*) _tmp9_;
			build_tool_copy (_tmp10_, &_tmp12_);
			_tmp11_ = _tmp12_;
			_tmp13_ = _tmp11_;
			_build_tool_free0 (_tmp10_);
			build_tool = _tmp13_;
			if (g_strcmp0 (build_tool.icon, icon[type]) == 0) {
				BuildTool _tmp14_;
				BuildTool* _tmp15_;
				BuildTool* _tmp16_;
				_tmp14_ = build_tool;
				_tmp15_ = _build_tool_dup0 (&_tmp14_);
				_tmp16_ = _tmp15_;
				build_tool_destroy (&_tmp14_);
				result = _tmp16_;
				_g_object_unref0 (_build_tool_list);
				icon = (_vala_array_free (icon, icon_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_list);
	}
	result = NULL;
	icon = (_vala_array_free (icon, icon_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean build_tools_is_empty (BuildTools* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	result = _tmp0_ == 0;
	return result;
}


void build_tools_move_up (BuildTools* self, gint num) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (num > 0);
	build_tools_swap (self, num, num - 1);
}


void build_tools_move_down (BuildTools* self, gint num) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	g_return_if_fail (num < (_tmp0_ - 1));
	build_tools_swap (self, num, num + 1);
}


static void build_tools_swap (BuildTools* self, gint num1, gint num2) {
	gpointer _tmp0_ = NULL;
	BuildTool* _tmp1_;
	BuildTool _tmp2_;
	BuildTool _tmp3_ = {0};
	BuildTool _tmp4_;
	BuildTool tool;
	gpointer _tmp5_ = NULL;
	BuildTool* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num1);
	_tmp1_ = (BuildTool*) _tmp0_;
	build_tool_copy (_tmp1_, &_tmp3_);
	_tmp2_ = _tmp3_;
	_tmp4_ = _tmp2_;
	_build_tool_free0 (_tmp1_);
	tool = _tmp4_;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num1);
	_tmp6_ = (BuildTool*) _tmp5_;
	_build_tool_free0 (_tmp6_);
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num2, &tool);
	build_tools_update_all_menus (self);
	build_tool_destroy (&tool);
}


void build_tools_delete (BuildTools* self, gint num) {
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_ = NULL;
	BuildTool* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = num < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
	_tmp3_ = (BuildTool*) _tmp2_;
	_build_tool_free0 (_tmp3_);
	build_tools_update_all_menus (self);
}


void build_tools_add (BuildTools* self, BuildTool* tool) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	build_tools_insert (self, _tmp0_, tool);
}


void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (0 <= pos) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = pos <= _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp2_ = build_tools_is_compilation (self, (*tool).icon);
	(*tool).compilation = _tmp2_;
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, pos, tool);
	build_tools_update_all_menus (self);
}


void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show) {
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_ = NULL;
	BuildTool* _tmp3_;
	BuildTool _tmp4_;
	BuildTool _tmp5_ = {0};
	BuildTool _tmp6_;
	BuildTool current_tool;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = num < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num);
	_tmp3_ = (BuildTool*) _tmp2_;
	build_tool_copy (_tmp3_, &_tmp5_);
	_tmp4_ = _tmp5_;
	_tmp6_ = _tmp4_;
	_build_tool_free0 (_tmp3_);
	current_tool = _tmp6_;
	if (keep_show) {
		(*tool).show = current_tool.show;
	}
	_tmp7_ = build_tools_is_equal (self, &current_tool, tool);
	if (!_tmp7_) {
		gboolean _tmp8_;
		gpointer _tmp9_ = NULL;
		BuildTool* _tmp10_;
		_tmp8_ = build_tools_is_compilation (self, (*tool).icon);
		(*tool).compilation = _tmp8_;
		_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
		_tmp10_ = (BuildTool*) _tmp9_;
		_build_tool_free0 (_tmp10_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num, tool);
		build_tools_update_all_menus (self);
	}
	build_tool_destroy (&current_tool);
}


void build_tools_reset_all (BuildTools* self) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = build_tools_get_user_config_file (self);
	file = _tmp0_;
	_tmp1_ = g_file_query_exists (file, NULL);
	if (_tmp1_) {
		utils_delete_file (file);
	}
	build_tools_load (self);
	build_tools_update_all_menus (self);
	_g_object_unref0 (file);
}


static gboolean build_tools_is_equal (BuildTools* self, BuildTool* tool1, BuildTool* tool2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*tool1).show != (*tool2).show) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 ((*tool1).label, (*tool2).label) != 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 ((*tool1).description, (*tool2).description) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 ((*tool1).extensions, (*tool2).extensions) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 ((*tool1).icon, (*tool2).icon) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp5_;
		guint _tmp6_;
		_tmp5_ = g_list_length ((*tool1).jobs);
		_tmp6_ = g_list_length ((*tool2).jobs);
		_tmp0_ = _tmp5_ != _tmp6_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				guint _tmp8_;
				gconstpointer _tmp9_ = NULL;
				BuildJob _tmp10_;
				BuildJob _tmp11_ = {0};
				BuildJob job1;
				gconstpointer _tmp12_ = NULL;
				BuildJob _tmp13_;
				BuildJob _tmp14_ = {0};
				BuildJob job2;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				_tmp8_ = g_list_length ((*tool1).jobs);
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = g_list_nth_data ((*tool1).jobs, i);
				build_job_copy ((BuildJob*) _tmp9_, &_tmp11_);
				_tmp10_ = _tmp11_;
				job1 = _tmp10_;
				_tmp12_ = g_list_nth_data ((*tool2).jobs, i);
				build_job_copy ((BuildJob*) _tmp12_, &_tmp14_);
				_tmp13_ = _tmp14_;
				job2 = _tmp13_;
				if (g_strcmp0 (job1.command, job2.command) != 0) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = job1.must_succeed != job2.must_succeed;
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = job1.post_processor != job2.post_processor;
				}
				if (_tmp15_) {
					result = FALSE;
					build_job_destroy (&job2);
					build_job_destroy (&job1);
					return result;
				}
				build_job_destroy (&job2);
				build_job_destroy (&job1);
			}
		}
	}
	result = TRUE;
	return result;
}


static void build_tools_update_all_menus (BuildTools* self) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->modified = TRUE;
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_windows (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MainWindow* _tmp4_;
			MainWindow* window;
			_tmp4_ = _g_object_ref0 ((MainWindow*) window_it->data);
			window = _tmp4_;
			{
				main_window_update_build_tools_menu (window);
				_g_object_unref0 (window);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean build_tools_is_compilation (BuildTools* self, const gchar* icon) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (icon != NULL, FALSE);
	_tmp2_ = string_contains (icon, "compile");
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (icon, GTK_STOCK_EXECUTE) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (icon, GTK_STOCK_CONVERT) == 0;
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_add7 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	build_tools_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	build_tools_parser_end (self, context, element_name, error);
}


static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	build_tools_parser_text (self, context, text, text_len, error);
}


static void build_tools_load (BuildTools* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GFile** _tmp1_ = NULL;
	GFile** files;
	gint files_length1;
	gint _files_size_;
	GFile* _tmp2_ = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** language_names;
	gint language_names_length1;
	gint _language_names_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_TOOL, (GBoxedCopyFunc) build_tool_dup, build_tool_free, NULL);
	_g_object_unref0 (self->priv->build_tools);
	self->priv->build_tools = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = 0;
	_tmp2_ = build_tools_get_user_config_file (self);
	_vala_array_add7 (&files, &files_length1, &_files_size_, _tmp2_);
	_tmp4_ = _tmp3_ = g_get_language_names ();
	language_names = _tmp4_;
	language_names_length1 = _vala_array_length (_tmp3_);
	_language_names_size_ = _vala_array_length (_tmp3_);
	{
		gchar** language_name_collection;
		int language_name_collection_length1;
		int language_name_it;
		language_name_collection = language_names;
		language_name_collection_length1 = language_names_length1;
		for (language_name_it = 0; language_name_it < language_names_length1; language_name_it = language_name_it + 1) {
			gchar* _tmp5_;
			gchar* language_name;
			_tmp5_ = g_strdup (language_name_collection[language_name_it]);
			language_name = _tmp5_;
			{
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				GFile* _tmp8_ = NULL;
				_tmp6_ = g_build_filename (DATA_DIR, "build_tools", language_name, "build_tools.xml", NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_file_new_for_path (_tmp7_);
				_vala_array_add8 (&files, &files_length1, &_files_size_, _tmp8_);
				_g_free0 (_tmp7_);
				_g_free0 (language_name);
			}
		}
	}
	{
		GFile** file_collection;
		int file_collection_length1;
		int file_it;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < files_length1; file_it = file_it + 1) {
			GFile* _tmp9_;
			GFile* file;
			_tmp9_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp9_;
			{
				gboolean _tmp10_;
				gchar* contents = NULL;
				gchar* _tmp11_ = NULL;
				GMarkupParser _tmp12_ = {0};
				GMarkupParser parser;
				GMarkupParseContext* _tmp13_ = NULL;
				GMarkupParseContext* context;
				_tmp10_ = g_file_query_exists (file, NULL);
				if (!_tmp10_) {
					_g_object_unref0 (file);
					continue;
				}
				g_file_load_contents (file, NULL, &_tmp11_, NULL, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp11_;
				if (_inner_error_ != NULL) {
					_g_free0 (contents);
					goto __catch23_g_error;
				}
				_tmp12_.start_element = _build_tools_parser_start_gmarkup_parser_start_element_func;
				_tmp12_.end_element = _build_tools_parser_end_gmarkup_parser_end_element_func;
				_tmp12_.text = _build_tools_parser_text_gmarkup_parser_text_func;
				_tmp12_.passthrough = NULL;
				_tmp12_.error = NULL;
				parser = _tmp12_;
				_tmp13_ = g_markup_parse_context_new (&parser, 0, self, NULL);
				context = _tmp13_;
				g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_markup_parse_context_free0 (context);
					_g_free0 (contents);
					goto __catch23_g_error;
				}
				_g_markup_parse_context_free0 (context);
				_g_free0 (contents);
				_g_object_unref0 (file);
				break;
				_g_markup_parse_context_free0 (context);
				_g_free0 (contents);
				goto __finally23;
				__catch23_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("build_tools.vala:283: Impossible to load build tools: %s", e->message);
					_g_error_free0 (e);
				}
				__finally23:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (file);
			}
		}
	}
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("tools")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("label"))))) || (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("description"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp2_ = {0};
				BuildTool _tmp3_ = {0};
				memset (&_tmp2_, 0, sizeof (BuildTool));
				_tmp3_ = _tmp2_;
				build_tool_destroy (&self->priv->cur_tool);
				self->priv->cur_tool = _tmp3_;
				self->priv->cur_tool.compilation = FALSE;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							const gchar* _tmp5_;
							GQuark _tmp6_;
							static GQuark _tmp6__label0 = 0;
							static GQuark _tmp6__label1 = 0;
							static GQuark _tmp6__label2 = 0;
							if (!_tmp4_) {
								i++;
							}
							_tmp4_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp5_ = attr_names[i];
							_tmp6_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
							if (_tmp6_ == ((0 != _tmp6__label0) ? _tmp6__label0 : (_tmp6__label0 = g_quark_from_static_string ("show")))) {
								switch (0) {
									default:
									{
										gboolean _tmp7_;
										_tmp7_ = bool_parse (attr_values[i]);
										self->priv->cur_tool.show = _tmp7_;
										break;
									}
								}
							} else if (_tmp6_ == ((0 != _tmp6__label1) ? _tmp6__label1 : (_tmp6__label1 = g_quark_from_static_string ("extensions")))) {
								switch (0) {
									default:
									{
										gchar* _tmp8_;
										_tmp8_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->cur_tool.extensions);
										self->priv->cur_tool.extensions = _tmp8_;
										break;
									}
								}
							} else if (_tmp6_ == ((0 != _tmp6__label2) ? _tmp6__label2 : (_tmp6__label2 = g_quark_from_static_string ("icon")))) {
								switch (0) {
									default:
									{
										gchar* _tmp9_;
										gboolean _tmp10_;
										_tmp9_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->cur_tool.icon);
										self->priv->cur_tool.icon = _tmp9_;
										_tmp10_ = build_tools_is_compilation (self, attr_values[i]);
										self->priv->cur_tool.compilation = _tmp10_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp11_;
										gchar* _tmp12_;
										gchar* _tmp13_;
										gchar* _tmp14_;
										GError* _tmp15_ = NULL;
										GError* _tmp16_;
										_tmp11_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp12_ = _tmp11_;
										_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
										_tmp14_ = _tmp13_;
										_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp14_);
										_tmp16_ = _tmp15_;
										_g_free0 (_tmp14_);
										_g_free0 (_tmp12_);
										_inner_error_ = _tmp16_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildJob _tmp17_ = {0};
				BuildJob _tmp18_ = {0};
				memset (&_tmp17_, 0, sizeof (BuildJob));
				_tmp18_ = _tmp17_;
				build_job_destroy (&self->priv->cur_job);
				self->priv->cur_job = _tmp18_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp19_;
						_tmp19_ = TRUE;
						while (TRUE) {
							const gchar* _tmp20_;
							GQuark _tmp21_;
							static GQuark _tmp21__label0 = 0;
							static GQuark _tmp21__label1 = 0;
							if (!_tmp19_) {
								i++;
							}
							_tmp19_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp20_ = attr_names[i];
							_tmp21_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
							if (_tmp21_ == ((0 != _tmp21__label0) ? _tmp21__label0 : (_tmp21__label0 = g_quark_from_static_string ("mustSucceed")))) {
								switch (0) {
									default:
									{
										gboolean _tmp22_;
										_tmp22_ = bool_parse (attr_values[i]);
										self->priv->cur_job.must_succeed = _tmp22_;
										break;
									}
								}
							} else if (_tmp21_ == ((0 != _tmp21__label1) ? _tmp21__label1 : (_tmp21__label1 = g_quark_from_static_string ("postProcessor")))) {
								switch (0) {
									default:
									{
										PostProcessorType* _tmp23_ = NULL;
										PostProcessorType* _tmp24_;
										_tmp23_ = build_tools_get_post_processor_type_from_name (attr_values[i]);
										_tmp24_ = _tmp23_;
										self->priv->cur_job.post_processor = *_tmp24_;
										_g_free0 (_tmp24_);
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp25_;
										gchar* _tmp26_;
										gchar* _tmp27_;
										gchar* _tmp28_;
										GError* _tmp29_ = NULL;
										GError* _tmp30_;
										_tmp25_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp26_ = _tmp25_;
										_tmp27_ = g_strconcat (_tmp26_, "\"", NULL);
										_tmp28_ = _tmp27_;
										_tmp29_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp28_);
										_tmp30_ = _tmp29_;
										_g_free0 (_tmp28_);
										_g_free0 (_tmp26_);
										_inner_error_ = _tmp30_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				GError* _tmp35_ = NULL;
				GError* _tmp36_;
				_tmp31_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "\"", NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp34_);
				_tmp36_ = _tmp35_;
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				_inner_error_ = _tmp36_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("tools")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("label"))))) || (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("description"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				if (self->priv->cur_tool.description == NULL) {
					gchar* _tmp2_;
					_tmp2_ = g_strdup (self->priv->cur_tool.label);
					_g_free0 (self->priv->cur_tool.description);
					self->priv->cur_tool.description = _tmp2_;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->build_tools, &self->priv->cur_tool);
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildJob* _tmp3_;
				_tmp3_ = _build_job_dup0 (&self->priv->cur_job);
				self->priv->cur_tool.jobs = g_list_append (self->priv->cur_tool.jobs, _tmp3_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				GError* _tmp8_ = NULL;
				GError* _tmp9_;
				_tmp4_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp5_, "\"", NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp7_);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				_inner_error_ = _tmp9_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_markup_parse_context_get_element (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_ = NULL;
				_tmp3_ = string_strip (text);
				_g_free0 (self->priv->cur_job.command);
				self->priv->cur_job.command = _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = string_strip (text);
				_g_free0 (self->priv->cur_tool.label);
				self->priv->cur_tool.label = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("description")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = string_strip (text);
				_g_free0 (self->priv->cur_tool.description);
				self->priv->cur_tool.description = _tmp5_;
				break;
			}
		}
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void build_tools_save (BuildTools* self) {
	gchar* _tmp0_;
	gchar* content;
	gchar* _tmp32_;
	GFile* _tmp33_ = NULL;
	GFile* file;
	GFile* _tmp34_ = NULL;
	GFile* parent;
	gboolean _tmp35_ = FALSE;
	gint _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (!self->priv->modified) {
		return;
	}
	_tmp0_ = g_strdup ("<tools>");
	content = _tmp0_;
	{
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tool_list;
		gint _tmp2_;
		gint _tool_size;
		gint _tool_index;
		_tmp1_ = _g_object_ref0 (self->priv->build_tools);
		_tool_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tool_list);
		_tool_size = _tmp2_;
		_tool_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			BuildTool* _tmp4_;
			BuildTool _tmp5_;
			BuildTool _tmp6_ = {0};
			BuildTool _tmp7_;
			BuildTool tool;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp31_;
			_tool_index = _tool_index + 1;
			if (!(_tool_index < _tool_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tool_list, _tool_index);
			_tmp4_ = (BuildTool*) _tmp3_;
			build_tool_copy (_tmp4_, &_tmp6_);
			_tmp5_ = _tmp6_;
			_tmp7_ = _tmp5_;
			_build_tool_free0 (_tmp4_);
			tool = _tmp7_;
			_tmp8_ = bool_to_string (tool.show);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("\n  <tool show=\"%s\" extensions=\"%s\" icon=\"%s\">\n", _tmp9_, tool.extensions, tool.icon);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (content, _tmp11_, NULL);
			_g_free0 (content);
			content = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_tmp13_ = g_markup_printf_escaped ("    <label>%s</label>\n", tool.label);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (content, _tmp14_, NULL);
			_g_free0 (content);
			content = _tmp15_;
			_g_free0 (_tmp14_);
			_tmp16_ = g_markup_printf_escaped ("    <description>%s</description>\n", tool.description);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (content, _tmp17_, NULL);
			_g_free0 (content);
			content = _tmp18_;
			_g_free0 (_tmp17_);
			{
				GList* job_collection;
				GList* job_it;
				job_collection = tool.jobs;
				for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
					BuildJob _tmp19_;
					BuildJob _tmp20_ = {0};
					BuildJob job;
					build_job_copy ((BuildJob*) job_it->data, &_tmp20_);
					_tmp19_ = _tmp20_;
					job = _tmp19_;
					{
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						gchar* _tmp30_;
						_tmp21_ = bool_to_string (job.must_succeed);
						_tmp22_ = _tmp21_;
						_tmp23_ = build_tools_get_post_processor_name_from_type (job.post_processor);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strdup_printf ("    <job mustSucceed=\"%s\" postProcessor=\"%s\">", _tmp22_, _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strconcat (content, _tmp26_, NULL);
						_g_free0 (content);
						content = _tmp27_;
						_g_free0 (_tmp26_);
						_g_free0 (_tmp24_);
						_g_free0 (_tmp22_);
						_tmp28_ = g_markup_printf_escaped ("%s</job>\n", job.command);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strconcat (content, _tmp29_, NULL);
						_g_free0 (content);
						content = _tmp30_;
						_g_free0 (_tmp29_);
						build_job_destroy (&job);
					}
				}
			}
			_tmp31_ = g_strconcat (content, "  </tool>\n", NULL);
			_g_free0 (content);
			content = _tmp31_;
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_list);
	}
	_tmp32_ = g_strconcat (content, "</tools>\n", NULL);
	_g_free0 (content);
	content = _tmp32_;
	_tmp33_ = build_tools_get_user_config_file (self);
	file = _tmp33_;
	_tmp34_ = g_file_get_parent (file);
	parent = _tmp34_;
	if (parent != NULL) {
		gboolean _tmp36_;
		_tmp36_ = g_file_query_exists (parent, NULL);
		_tmp35_ = !_tmp36_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			goto __catch24_g_error;
		}
	}
	_tmp37_ = strlen (content);
	g_file_replace_contents (file, content, (gsize) _tmp37_, NULL, TRUE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		goto __catch24_g_error;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("build_tools.vala:435: Impossible to save build tools: %s", e->message);
		_g_error_free0 (e);
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
}


static GFile* build_tools_get_user_config_file (BuildTools* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "build_tools.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


static PostProcessorType* _post_processor_type_dup (PostProcessorType* self) {
	PostProcessorType* dup;
	dup = g_new0 (PostProcessorType, 1);
	memcpy (dup, self, sizeof (PostProcessorType));
	return dup;
}


static gpointer __post_processor_type_dup0 (gpointer self) {
	return self ? _post_processor_type_dup (self) : NULL;
}


PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name) {
	PostProcessorType* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint type;
		type = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					type++;
				}
				_tmp0_ = FALSE;
				if (!(type < POST_PROCESSOR_TYPE_N_POST_PROCESSORS)) {
					break;
				}
				if (g_strcmp0 (build_tools__post_processor_names[type], name) == 0) {
					PostProcessorType _tmp1_;
					PostProcessorType* _tmp2_;
					_tmp1_ = (PostProcessorType) type;
					_tmp2_ = __post_processor_type_dup0 (&_tmp1_);
					result = _tmp2_;
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (NULL);
}


gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (type != POST_PROCESSOR_TYPE_N_POST_PROCESSORS, NULL);
	_tmp0_ = g_strdup (build_tools__post_processor_names[type]);
	result = _tmp0_;
	return result;
}


static void value_build_tools_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_build_tools_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		build_tools_unref (value->data[0].v_pointer);
	}
}


static void value_build_tools_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_build_tools_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_build_tools_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BuildTools* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_build_tools_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BuildTools** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_build_tools (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void value_set_build_tools (GValue* value, gpointer v_object) {
	BuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		build_tools_unref (old);
	}
}


void value_take_build_tools (GValue* value, gpointer v_object) {
	BuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		build_tools_unref (old);
	}
}


static void build_tools_class_init (BuildToolsClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	build_tools_parent_class = g_type_class_peek_parent (klass);
	BUILD_TOOLS_CLASS (klass)->finalize = build_tools_finalize;
	g_type_class_add_private (klass, sizeof (BuildToolsPrivate));
	_tmp0_ = g_strdup ("all-output");
	_tmp1_ = g_strdup ("latex");
	_tmp2_ = g_strdup ("latexmk");
	_tmp3_ = g_strdup ("no-output");
	_tmp4_ = g_strdup ("rubber");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	build_tools__post_processor_names = _tmp5_;
	build_tools__post_processor_names_length1 = 5;
}


static void build_tools_instance_init (BuildTools * self) {
	self->priv = BUILD_TOOLS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
	self->ref_count = 1;
}


static void build_tools_finalize (BuildTools* obj) {
	BuildTools * self;
	self = BUILD_TOOLS (obj);
	_g_object_unref0 (self->priv->build_tools);
	build_tool_destroy (&self->priv->cur_tool);
	build_job_destroy (&self->priv->cur_job);
}


GType build_tools_get_type (void) {
	static volatile gsize build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_build_tools_init, value_build_tools_free_value, value_build_tools_copy_value, value_build_tools_peek_pointer, "p", value_build_tools_collect_value, "p", value_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildTools), 0, (GInstanceInitFunc) build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType build_tools_type_id;
		build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&build_tools_type_id__volatile, build_tools_type_id);
	}
	return build_tools_type_id__volatile;
}


gpointer build_tools_ref (gpointer instance) {
	BuildTools* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void build_tools_unref (gpointer instance) {
	BuildTools* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



