// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_URI_H
#define _LIBGNOMEVFSMM_URI_H

#include <glibmm.h>

/* $Id: uri.hg,v 1.4 2003/04/30 18:25:19 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/enums.h>
#include <glibmm/exception.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include <libgnomevfs/gnome-vfs-ops.h>


namespace Gnome
{

namespace Vfs
{

//TODO: Put this in its own file.
class exception : public Glib::Exception  //TODO: GnomeVFSResult.
{
public:
  exception();
  explicit exception(GnomeVFSResult gobj);
  virtual ~exception() throw();
  
  virtual Glib::ustring what() const;

protected:
  GnomeVFSResult gobj_;
};

class Uri
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Uri CppObjectType;
  typedef GnomeVFSURI BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  GnomeVFSURI*       gobj();
  const GnomeVFSURI* gobj() const;

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  GnomeVFSURI* gobj_copy() const;

protected:
  // Do not derive this.  Gnome::Vfs::Uri can neither be constructed nor deleted.
  Uri();
  void operator delete(void*, size_t);

private:
  // noncopyable
  Uri(const Uri&);
  Uri& operator=(const Uri&);


public:

  static Glib::RefPtr<Uri> create(const Glib::ustring& uri);
  
  
  Glib::RefPtr<Uri> resolve_relative(const Glib::ustring& relative_reference);


  Glib::RefPtr<Uri> append_string(const Glib::ustring& uri_fragment);
  
  Glib::RefPtr<Uri> append_path(const Glib::ustring& path);
  
  Glib::RefPtr<Uri> append_file_name(const Glib::ustring& filename);
  
  Glib::ustring to_string(GnomeVFSURIHideOptions hide_options);
  
  Glib::RefPtr<Uri> dup();
  
  bool is_local() const;
  
  bool has_parent();
  
  Glib::RefPtr<Uri> get_parent();

  
  GnomeVFSToplevelURI* get_toplevel();

  
  Glib::ustring get_host_name() const;
  
  Glib::ustring get_scheme() const;
  
  guint get_host_port() const;
  
  Glib::ustring get_user_name() const;
  
  Glib::ustring get_password() const;

  
  void set_host_name(const Glib::ustring& host_name);
  
  void set_host_port(guint host_port);
  
  void set_user_name(const Glib::ustring& user_name);
  
  void set_password(const Glib::ustring& password);

  //_WRAP_METHOD(bool gnome_vfs_uri_equal(const Glib::RefPtr<const Uri>& a, const Glib::RefPtr<const Uri>& b), )

  
  bool is_parent(const Glib::RefPtr<const Uri>& possible_child, bool recursive = true);

  
  Glib::ustring get_path() const;
  
  Glib::ustring get_fragment_identifier() const;
  
  Glib::ustring extract_dirname() const;
  
  Glib::ustring extract_short_name() const;
  
  Glib::ustring extract_short_path_name() const;

  //_WRAP_METHOD(int hequal(gconstpointer a, gconstpointer b), gnome_vfs_uri_hequal)
  //_WRAP_METHOD(guint hash(gconstpointer p), gnome_vfs_uri_hash)

/*
GList* gnome_vfs_uri_list_parse(const Glib::ustring& uri_list), )
GList* gnome_vfs_uri_list_ref(GList *list), )
GList* gnome_vfs_uri_list_unref(GList *list), )
GList* gnome_vfs_uri_list_copy(GList *list), )
void gnome_vfs_uri_list_free(GList *list), )
*/

  
  static Glib::ustring make_full_from_relative(const Glib::ustring& base_uri, const Glib::ustring& relative_uri);


  Glib::RefPtr<FileInfo> get_file_info(FileInfoOptions options = FILE_INFO_DEFAULT) const throw(exception);

  //Maybe these operations should be static methods in Handle,
  //like the existing ones that take string URIs.
  //That would leave Uri to be just a data class:
  
  void truncate(GnomeVFSFileSize length) throw(exception);
  void make_directory(guint perm) throw(exception);
  void remove_directory() throw(exception);
  void unlink() throw(exception);
  void create_symbolic_link(const Glib::ustring& target_reference) throw(exception);
  void move(const Glib::RefPtr<const Uri>& new_uri, bool force_replace) throw(exception);
  bool check_same_fs(const Glib::RefPtr<const Uri>& target_uri) const throw(exception);
  bool uri_exists() const throw(exception);
  void set_file_info(const Glib::RefPtr<const FileInfo>& info, GnomeVFSSetFileInfoMask mask) throw(exception);
protected:
  static void handle_result(GnomeVFSResult result) throw(exception);


};


class TopLevelUri : Uri
{
  //TODO: member accessors?
};
  

} // namespace Vfs
} // namespace Gnome


namespace Glib
{

/** @relates Gnome::Vfs::Uri */
Glib::RefPtr<Gnome::Vfs::Uri> wrap(GnomeVFSURI* object, bool take_copy = false);

} // namespace Glib

#endif /* _LIBGNOMEVFSMM_URI_H */

