/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#include <config.h>
#include <stdlib.h>
#include <time.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "om-fl-parser.h"

static const char *
format_time (time_t ts)
{
	struct tm *tm;
	static char buffer[81];

	tm = gmtime (&ts);
	buffer[sizeof(buffer) - 1] = '\0';
	strftime (buffer, sizeof(buffer) - 1, "%Y-%m-%d %H:%M:%S (UTC)", tm);
	return buffer;
}

static void
dump_file_info (GnomeVFSFileInfo *info)
{
	g_print ("Name: %s\n", info->name);
	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_SIZE) != 0)
		g_print ("Size: %" GNOME_VFS_SIZE_FORMAT_STR "\n",
			 info->size);
	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_TYPE) != 0)
		g_print ("Type: %s\n",
			 info->type == GNOME_VFS_FILE_TYPE_REGULAR ? "file" :
			 info->type == GNOME_VFS_FILE_TYPE_DIRECTORY ? "dir" :
			 "unknown");

	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_MTIME) != 0)
		g_print ("Modified: %s\n", format_time (info->mtime));
	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_CTIME) != 0)
		g_print ("Created: %s\n", format_time (info->ctime));
	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_ATIME) != 0)
		g_print ("Accessed: %s\n", format_time (info->atime));

	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_PERMISSIONS) != 0)
		g_print ("Permissions: %lo\n", (unsigned long) info->permissions);

	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_MIME_TYPE) != 0)
		g_print ("MIME type: %s\n",
			 info->mime_type ? info->mime_type : "(nil)");

	if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_DEVICE) != 0)
		g_print ("Memory type: %s\n",
			 om_mem_type_id_to_string (info->device));

	g_print ("\n");
}

int
main (int argc, char **argv)
{
	gchar *buf;
	gsize len;
	GError *error = NULL;
        gboolean result;
        GList *files = NULL, *tmp;

	/* ensure we are in a known time zone */
	putenv("TZ=Australia/Perth");
	tzset();

	if (argc != 2) {
		g_printerr ("usage: parse-obex-folder-listing filename.xml\n");
		return 1;
	}

	if (!g_file_get_contents (argv[1], &buf, &len, &error)) {
		g_printerr ("Could not read %s: %s\n",
			    argv[1], error->message);
		g_error_free (error);
		return 1;
	}

	result = om_fl_parser_parse (buf, len, &files, &error);
	g_free (buf);
	if (!result) {
		g_print ("Parse error: %s\n", error->message);
		g_error_free (error);
		return 0;
        }

        for (tmp = files; tmp != NULL; tmp = tmp->next) {
		dump_file_info (tmp->data);
        }
	gnome_vfs_file_info_list_free (files);

	return 0;
}
