/* ChannelFactory.c generated by valac 0.14.0, the Vala compiler
 * generated from ChannelFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
typedef struct _DVBPlayerThreadPrivate DVBPlayerThreadPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS (dvb_player_thread_channel_elements_get_type ())
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElements))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))

typedef struct _DVBPlayerThreadChannelElements DVBPlayerThreadChannelElements;
typedef struct _DVBPlayerThreadChannelElementsClass DVBPlayerThreadChannelElementsClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_player_thread_channel_elements_unref0(var) ((var == NULL) ? NULL : (var = (dvb_player_thread_channel_elements_unref (var), NULL)))
typedef struct _DVBPlayerThreadChannelElementsPrivate DVBPlayerThreadChannelElementsPrivate;
#define _gst_iterator_free0(var) ((var == NULL) ? NULL : (var = (gst_iterator_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBPlayerThreadParamSpecChannelElements DVBPlayerThreadParamSpecChannelElements;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;
typedef struct _DVBChannelFactoryPrivate DVBChannelFactoryPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBPlayerThread {
	GObject parent_instance;
	DVBPlayerThreadPrivate * priv;
};

struct _DVBPlayerThreadClass {
	GObjectClass parent_class;
	void (*destroy) (DVBPlayerThread* self, gboolean forced);
};

struct _DVBPlayerThreadPrivate {
	GeeHashSet* _active_channels;
	DVBDevice* _device;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GeeHashMap* elements_map;
	GStaticRecMutex __lock_elements_map;
	DVBEPGScanner* epgscanner;
	GstElement* dvbbasebin;
	gboolean destroyed;
	GStaticRecMutex __lock_destroyed;
};

struct _DVBPlayerThreadChannelElements {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBPlayerThreadChannelElementsPrivate * priv;
	guint sid;
	GeeArrayList* sinks;
	GstElement* tee;
	gboolean forced;
	DVBForcedStopNotify notify_func;
	gpointer notify_func_target;
};

struct _DVBPlayerThreadChannelElementsClass {
	GTypeClass parent_class;
	void (*finalize) (DVBPlayerThreadChannelElements *self);
};

struct _DVBPlayerThreadParamSpecChannelElements {
	GParamSpec parent_instance;
};

struct _DVBChannelFactory {
	GObject parent_instance;
	DVBChannelFactoryPrivate * priv;
};

struct _DVBChannelFactoryClass {
	GObjectClass parent_class;
	DVBPlayerThread* (*create_player) (DVBChannelFactory* self, DVBDevice* device);
};

struct _DVBChannelFactoryPrivate {
	DVBDeviceGroup* _device_group;
	GeeHashSet* active_players;
	GStaticRecMutex __lock_active_players;
};


static gpointer dvb_player_thread_parent_class = NULL;
static DVBLoggingLogger* dvb_player_thread_log;
static DVBLoggingLogger* dvb_player_thread_log = NULL;
static gpointer dvb_player_thread_channel_elements_parent_class = NULL;
static gpointer dvb_channel_factory_parent_class = NULL;
static DVBLoggingLogger* dvb_channel_factory_log;
static DVBLoggingLogger* dvb_channel_factory_log = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
static gpointer dvb_player_thread_channel_elements_ref (gpointer instance);
static void dvb_player_thread_channel_elements_unref (gpointer instance);
static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) G_GNUC_UNUSED;
static GType dvb_player_thread_channel_elements_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
#define DVB_PLAYER_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadPrivate))
enum  {
	DVB_PLAYER_THREAD_DUMMY_PROPERTY,
	DVB_PLAYER_THREAD_ACTIVE_CHANNELS,
	DVB_PLAYER_THREAD_DEVICE,
	DVB_PLAYER_THREAD_FORCED
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner);
DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message);
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad);
static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem);
static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element);
GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type);
static gint dvb_player_thread_find_element (void* av, void* bv);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
static gint _dvb_player_thread_find_element_gcompare_func (gconstpointer a, gconstpointer b);
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink);
static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self);
static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink);
void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced);
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value);
static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value);
gboolean dvb_player_thread_get_forced (DVBPlayerThread* self);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_DUMMY_PROPERTY
};
static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj);
static void dvb_player_thread_finalize (GObject* obj);
static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryPrivate))
enum  {
	DVB_CHANNEL_FACTORY_DUMMY_PROPERTY,
	DVB_CHANNEL_FACTORY_DEVICE_GROUP
};
DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup);
DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup);
void dvb_channel_factory_destroy (DVBChannelFactory* self);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value);
static void dvb_channel_factory_finalize (GObject* obj);
static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
         * @device: The device to use
         * @epgscanner: #EPGScanner to forward EIT to
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner) {
	DVBPlayerThread * self = NULL;
	DVBDevice* _tmp0_;
	DVBEPGScanner* _tmp1_;
	DVBEPGScanner* _tmp2_;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	self = (DVBPlayerThread*) g_object_new (object_type, "device", _tmp0_, NULL);
	_tmp1_ = epgscanner;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->epgscanner);
	self->priv->epgscanner = _tmp2_;
	return self;
}


DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner) {
	return dvb_player_thread_construct (DVB_TYPE_PLAYER_THREAD, device, epgscanner);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = _gst_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dvbbasebin;
	_tmp1_ = _gst_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * @returns: GstBin containing queue and @sink_element
         *
         * Start watching @channel and link it with @sink_element
         */
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_player_thread_bus_watch_func (self, _sender, message);
}


static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_player_thread_on_dvbbasebin_pad_added (self, _sender, pad);
}


GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target) {
	GstElement* result = NULL;
	DVBChannel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint channel_sid;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* channel_sid_str;
	gboolean create_channel = FALSE;
	GstElement* bin = NULL;
	GstElement* tee;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Sid (_tmp0_);
	_tmp2_ = _tmp1_;
	channel_sid = _tmp2_;
	_tmp3_ = channel_sid;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	channel_sid_str = _tmp4_;
	tee = NULL;
	{
		GstElement* _tmp5_;
		_tmp5_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp6_;
			gboolean _tmp97_;
			GstElement* _tmp121_;
			GstElement* _tmp122_;
			_tmp6_ = self->priv->pipeline;
			if (_tmp6_ == NULL) {
				DVBLoggingLogger* _tmp7_;
				GstPipeline* _tmp8_;
				GstElement* _tmp9_;
				GstBus* _tmp10_ = NULL;
				GstBus* bus;
				GstBus* _tmp11_;
				GstBus* _tmp12_;
				GstElement* _tmp13_ = NULL;
				GstElement* _tmp14_;
				GstElement* _tmp17_;
				DVBChannel* _tmp18_;
				GstElement* _tmp19_;
				GstElement* _tmp20_;
				const gchar* _tmp21_;
				GstElement* _tmp22_;
				DVBDevice* _tmp23_;
				guint _tmp24_;
				guint _tmp25_;
				GstElement* _tmp26_;
				DVBDevice* _tmp27_;
				guint _tmp28_;
				guint _tmp29_;
				GstElement* _tmp30_;
				GstElement* _tmp31_;
				GstElement* _tmp32_;
				GstElement* _tmp33_ = NULL;
				GstElement* _tmp34_;
				GstElement* _tmp35_;
				GstElement* _tmp36_;
				GstElement* _tmp37_ = NULL;
				GstElement* _tmp38_;
				GstElement* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp7_ = dvb_player_thread_log;
				dvb_logging_logger_debug (_tmp7_, "ChannelFactory.vala:118: Creating new pipeline");
				_tmp8_ = (GstPipeline*) gst_pipeline_new ("recording");
				gst_object_ref_sink (_tmp8_);
				_gst_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = (GstElement*) _tmp8_;
				_tmp9_ = self->priv->pipeline;
				_tmp10_ = gst_element_get_bus (_tmp9_);
				bus = _tmp10_;
				_tmp11_ = bus;
				gst_bus_add_signal_watch (_tmp11_);
				_tmp12_ = bus;
				g_signal_connect_object (_tmp12_, "message", (GCallback) _dvb_player_thread_bus_watch_func_gst_bus_message, self, 0);
				_tmp13_ = gst_element_factory_make ("dvbbasebin", NULL);
				_gst_object_unref0 (self->priv->dvbbasebin);
				self->priv->dvbbasebin = _tmp13_;
				_tmp14_ = self->priv->dvbbasebin;
				if (_tmp14_ == NULL) {
					DVBLoggingLogger* _tmp15_;
					_tmp15_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp15_, "ChannelFactory.vala:129: Could not create dvbbasebin element");
					result = NULL;
					_gst_object_unref0 (bus);
					{
						GstElement* _tmp16_;
						_tmp16_ = self->priv->pipeline;
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_gst_object_unref0 (tee);
					_gst_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (sink_element);
					return result;
				}
				_tmp17_ = self->priv->dvbbasebin;
				g_signal_connect_object (_tmp17_, "pad-added", (GCallback) _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
				_tmp18_ = channel;
				_tmp19_ = self->priv->dvbbasebin;
				dvb_channel_setup_dvb_source (_tmp18_, _tmp19_);
				_tmp20_ = self->priv->dvbbasebin;
				_tmp21_ = channel_sid_str;
				g_object_set ((GObject*) _tmp20_, "program-numbers", _tmp21_, NULL);
				_tmp22_ = self->priv->dvbbasebin;
				_tmp23_ = self->priv->_device;
				_tmp24_ = dvb_device_get_Adapter (_tmp23_);
				_tmp25_ = _tmp24_;
				g_object_set ((GObject*) _tmp22_, "adapter", _tmp25_, NULL);
				_tmp26_ = self->priv->dvbbasebin;
				_tmp27_ = self->priv->_device;
				_tmp28_ = dvb_device_get_Frontend (_tmp27_);
				_tmp29_ = _tmp28_;
				g_object_set ((GObject*) _tmp26_, "frontend", _tmp29_, NULL);
				_tmp30_ = self->priv->pipeline;
				_tmp31_ = self->priv->dvbbasebin;
				_tmp32_ = _gst_object_ref0 (_tmp31_);
				gst_bin_add (GST_BIN (_tmp30_), _tmp32_);
				_tmp33_ = gst_element_factory_make ("tee", NULL);
				_gst_object_unref0 (tee);
				tee = _tmp33_;
				_tmp34_ = tee;
				_tmp35_ = _gst_object_ref0 (_tmp34_);
				dvb_player_thread_add_element (self, _tmp35_);
				_tmp36_ = sink_element;
				_tmp37_ = dvb_player_thread_add_sink_bin (self, _tmp36_);
				_gst_object_unref0 (bin);
				bin = _tmp37_;
				_tmp38_ = tee;
				_tmp39_ = bin;
				_tmp40_ = gst_element_link (_tmp38_, _tmp39_);
				if (!_tmp40_) {
					DVBLoggingLogger* _tmp41_;
					_tmp41_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp41_, "ChannelFactory.vala:148: Could not link tee and bin");
					result = NULL;
					_gst_object_unref0 (bus);
					{
						GstElement* _tmp42_;
						_tmp42_ = self->priv->pipeline;
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_gst_object_unref0 (tee);
					_gst_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (sink_element);
					return result;
				}
				create_channel = TRUE;
				_gst_object_unref0 (bus);
			} else {
				DVBLoggingLogger* _tmp43_;
				GstElement* _tmp44_;
				GstElement* _tmp47_;
				GeeHashSet* _tmp48_;
				DVBChannel* _tmp49_;
				gboolean _tmp50_ = FALSE;
				_tmp43_ = dvb_player_thread_log;
				dvb_logging_logger_debug (_tmp43_, "ChannelFactory.vala:156: Reusing existing pipeline");
				_tmp44_ = self->priv->dvbbasebin;
				if (_tmp44_ == NULL) {
					DVBLoggingLogger* _tmp45_;
					_tmp45_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp45_, "ChannelFactory.vala:158: No dvbbasebin element");
					result = NULL;
					{
						GstElement* _tmp46_;
						_tmp46_ = self->priv->pipeline;
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_gst_object_unref0 (tee);
					_gst_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (sink_element);
					return result;
				}
				_tmp47_ = self->priv->pipeline;
				gst_element_set_state (_tmp47_, GST_STATE_PAUSED);
				_tmp48_ = self->priv->_active_channels;
				_tmp49_ = channel;
				_tmp50_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp48_, _tmp49_);
				if (!_tmp50_) {
					GstElement* _tmp51_ = NULL;
					GstElement* _tmp52_;
					GstElement* _tmp53_;
					GstElement* _tmp54_;
					GstElement* _tmp55_ = NULL;
					GstElement* _tmp56_;
					GstElement* _tmp57_;
					gboolean _tmp58_ = FALSE;
					gchar* programs = NULL;
					GstElement* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					gchar* _tmp64_ = NULL;
					gchar* new_programs;
					DVBLoggingLogger* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					GstElement* _tmp68_;
					const gchar* _tmp69_;
					_tmp51_ = gst_element_factory_make ("tee", NULL);
					_gst_object_unref0 (tee);
					tee = _tmp51_;
					_tmp52_ = tee;
					_tmp53_ = _gst_object_ref0 (_tmp52_);
					dvb_player_thread_add_element (self, _tmp53_);
					_tmp54_ = sink_element;
					_tmp55_ = dvb_player_thread_add_sink_bin (self, _tmp54_);
					_gst_object_unref0 (bin);
					bin = _tmp55_;
					_tmp56_ = tee;
					_tmp57_ = bin;
					_tmp58_ = gst_element_link (_tmp56_, _tmp57_);
					if (!_tmp58_) {
						DVBLoggingLogger* _tmp59_;
						_tmp59_ = dvb_player_thread_log;
						dvb_logging_logger_error (_tmp59_, "ChannelFactory.vala:172: Could not link tee and bin");
						result = NULL;
						{
							GstElement* _tmp60_;
							_tmp60_ = self->priv->pipeline;
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_gst_object_unref0 (tee);
						_gst_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (sink_element);
						return result;
					}
					_tmp61_ = self->priv->dvbbasebin;
					g_object_get ((GObject*) _tmp61_, "program-numbers", &programs, NULL);
					_tmp62_ = programs;
					_tmp63_ = channel_sid_str;
					_tmp64_ = g_strdup_printf ("%s:%s", _tmp62_, _tmp63_);
					new_programs = _tmp64_;
					_tmp65_ = dvb_player_thread_log;
					_tmp66_ = programs;
					_tmp67_ = new_programs;
					dvb_logging_logger_debug (_tmp65_, "ChannelFactory.vala:181: Changing program-numbers from %s to %s", _tmp66_, _tmp67_);
					_tmp68_ = self->priv->dvbbasebin;
					_tmp69_ = new_programs;
					g_object_set ((GObject*) _tmp68_, "program-numbers", _tmp69_, NULL);
					create_channel = TRUE;
					_g_free0 (new_programs);
					_g_free0 (programs);
				} else {
					DVBPlayerThreadChannelElements* c_element = NULL;
					{
						GeeHashMap* _tmp70_;
						_tmp70_ = self->priv->elements_map;
						g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							GeeHashMap* _tmp71_;
							guint _tmp72_;
							gpointer _tmp73_ = NULL;
							DVBPlayerThreadChannelElements* _tmp74_;
							GstElement* _tmp75_;
							GstElement* _tmp76_;
							GstElement* _tmp77_;
							GstElement* _tmp78_ = NULL;
							DVBLoggingLogger* _tmp79_;
							GstElement* _tmp80_;
							gchar* _tmp81_ = NULL;
							gchar* _tmp82_;
							GstElement* _tmp83_;
							gchar* _tmp84_ = NULL;
							gchar* _tmp85_;
							GstElement* _tmp86_;
							GstElement* _tmp87_;
							gboolean _tmp88_ = FALSE;
							DVBPlayerThreadChannelElements* _tmp92_;
							GeeArrayList* _tmp93_;
							GstElement* _tmp94_;
							_tmp71_ = self->priv->elements_map;
							_tmp72_ = channel_sid;
							_tmp73_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp71_, GUINT_TO_POINTER (_tmp72_));
							_dvb_player_thread_channel_elements_unref0 (c_element);
							c_element = (DVBPlayerThreadChannelElements*) _tmp73_;
							_tmp74_ = c_element;
							_tmp75_ = _tmp74_->tee;
							_tmp76_ = _gst_object_ref0 (_tmp75_);
							_gst_object_unref0 (tee);
							tee = _tmp76_;
							_tmp77_ = sink_element;
							_tmp78_ = dvb_player_thread_add_sink_bin (self, _tmp77_);
							_gst_object_unref0 (bin);
							bin = _tmp78_;
							_tmp79_ = dvb_player_thread_log;
							_tmp80_ = tee;
							_tmp81_ = gst_object_get_name ((GstObject*) _tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = bin;
							_tmp84_ = gst_object_get_name ((GstObject*) _tmp83_);
							_tmp85_ = _tmp84_;
							dvb_logging_logger_debug (_tmp79_, "ChannelFactory.vala:196: Linking %s with %s", _tmp82_, _tmp85_);
							_g_free0 (_tmp85_);
							_g_free0 (_tmp82_);
							_tmp86_ = tee;
							_tmp87_ = bin;
							_tmp88_ = gst_element_link (_tmp86_, _tmp87_);
							if (!_tmp88_) {
								DVBLoggingLogger* _tmp89_;
								_tmp89_ = dvb_player_thread_log;
								dvb_logging_logger_error (_tmp89_, "ChannelFactory.vala:198: Could not link tee and bin");
								result = NULL;
								{
									GeeHashMap* _tmp90_;
									_tmp90_ = self->priv->elements_map;
									g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
								}
								_dvb_player_thread_channel_elements_unref0 (c_element);
								{
									GstElement* _tmp91_;
									_tmp91_ = self->priv->pipeline;
									g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
								}
								_gst_object_unref0 (tee);
								_gst_object_unref0 (bin);
								_g_free0 (channel_sid_str);
								_gst_object_unref0 (sink_element);
								return result;
							}
							_tmp92_ = c_element;
							_tmp93_ = _tmp92_->sinks;
							_tmp94_ = bin;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp94_);
						}
						__finally15:
						{
							GeeHashMap* _tmp95_;
							_tmp95_ = self->priv->elements_map;
							g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (_inner_error_ != NULL) {
							_dvb_player_thread_channel_elements_unref0 (c_element);
							_dvb_player_thread_channel_elements_unref0 (c_element);
							{
								GstElement* _tmp96_;
								_tmp96_ = self->priv->pipeline;
								g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_gst_object_unref0 (tee);
							_gst_object_unref0 (bin);
							_g_free0 (channel_sid_str);
							_gst_object_unref0 (sink_element);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					create_channel = FALSE;
					_dvb_player_thread_channel_elements_unref0 (c_element);
				}
			}
			_tmp97_ = create_channel;
			if (_tmp97_) {
				DVBPlayerThreadChannelElements* _tmp98_;
				DVBPlayerThreadChannelElements* celems;
				DVBPlayerThreadChannelElements* _tmp99_;
				guint _tmp100_;
				DVBPlayerThreadChannelElements* _tmp101_;
				GeeArrayList* _tmp102_;
				DVBPlayerThreadChannelElements* _tmp103_;
				GeeArrayList* _tmp104_;
				GstElement* _tmp105_;
				DVBPlayerThreadChannelElements* _tmp106_;
				GstElement* _tmp107_;
				GstElement* _tmp108_;
				DVBPlayerThreadChannelElements* _tmp109_;
				gboolean _tmp110_;
				DVBPlayerThreadChannelElements* _tmp111_;
				DVBForcedStopNotify _tmp112_;
				void* _tmp112__target;
				GeeHashSet* _tmp119_;
				DVBChannel* _tmp120_;
				_tmp98_ = dvb_player_thread_channel_elements_new ();
				celems = _tmp98_;
				_tmp99_ = celems;
				_tmp100_ = channel_sid;
				_tmp99_->sid = _tmp100_;
				_tmp101_ = celems;
				_tmp102_ = gee_array_list_new (GST_TYPE_ELEMENT, (GBoxedCopyFunc) gst_object_ref, gst_object_unref, NULL);
				_g_object_unref0 (_tmp101_->sinks);
				_tmp101_->sinks = _tmp102_;
				_tmp103_ = celems;
				_tmp104_ = _tmp103_->sinks;
				_tmp105_ = bin;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, _tmp105_);
				_tmp106_ = celems;
				_tmp107_ = tee;
				_tmp108_ = _gst_object_ref0 (_tmp107_);
				_gst_object_unref0 (_tmp106_->tee);
				_tmp106_->tee = _tmp108_;
				_tmp109_ = celems;
				_tmp110_ = forced;
				_tmp109_->forced = _tmp110_;
				_tmp111_ = celems;
				_tmp112_ = notify_func;
				_tmp112__target = notify_func_target;
				_tmp111_->notify_func = _tmp112_;
				_tmp111_->notify_func_target = _tmp112__target;
				{
					GeeHashMap* _tmp113_;
					_tmp113_ = self->priv->elements_map;
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						GeeHashMap* _tmp114_;
						guint _tmp115_;
						DVBPlayerThreadChannelElements* _tmp116_;
						_tmp114_ = self->priv->elements_map;
						_tmp115_ = channel_sid;
						_tmp116_ = celems;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp114_, GUINT_TO_POINTER (_tmp115_), _tmp116_);
					}
					__finally16:
					{
						GeeHashMap* _tmp117_;
						_tmp117_ = self->priv->elements_map;
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (_inner_error_ != NULL) {
						_dvb_player_thread_channel_elements_unref0 (celems);
						_dvb_player_thread_channel_elements_unref0 (celems);
						{
							GstElement* _tmp118_;
							_tmp118_ = self->priv->pipeline;
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_gst_object_unref0 (tee);
						_gst_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (sink_element);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp119_ = self->priv->_active_channels;
				_tmp120_ = channel;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp119_, _tmp120_);
				_dvb_player_thread_channel_elements_unref0 (celems);
			}
			_tmp121_ = bin;
			_tmp122_ = _gst_object_ref0 (_tmp121_);
			result = _tmp122_;
			{
				GstElement* _tmp123_;
				_tmp123_ = self->priv->pipeline;
				g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
			}
			_gst_object_unref0 (tee);
			_gst_object_unref0 (bin);
			_g_free0 (channel_sid_str);
			_gst_object_unref0 (sink_element);
			return result;
		}
		__finally14:
		{
			GstElement* _tmp124_;
			_tmp124_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		_gst_object_unref0 (tee);
		_gst_object_unref0 (bin);
		_g_free0 (channel_sid_str);
		_gst_object_unref0 (sink_element);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_gst_object_unref0 (tee);
	_gst_object_unref0 (bin);
	_g_free0 (channel_sid_str);
	_gst_object_unref0 (sink_element);
}


static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* queue;
	GstElement* _tmp1_;
	GstBin* _tmp2_;
	GstElement* bin;
	GstElement* _tmp3_;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GstElement* _tmp18_;
	GstPad* _tmp19_ = NULL;
	GstPad* pad;
	GstGhostPad* _tmp20_;
	GstGhostPad* ghost;
	GstElement* _tmp21_;
	GstPad* _tmp22_;
	GstElement* _tmp23_;
	GstElement* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = gst_element_factory_make ("queue", NULL);
	queue = _tmp0_;
	_tmp1_ = queue;
	g_object_set ((GObject*) _tmp1_, "max-size-buffers", 0, NULL);
	_tmp2_ = (GstBin*) gst_bin_new (NULL);
	gst_object_ref_sink (_tmp2_);
	bin = (GstElement*) _tmp2_;
	_tmp3_ = bin;
	_tmp4_ = queue;
	_tmp5_ = _gst_object_ref0 (_tmp4_);
	_tmp6_ = sink_element;
	_tmp7_ = _gst_object_ref0 (_tmp6_);
	gst_bin_add_many (GST_BIN (_tmp3_), _tmp5_, _tmp7_, NULL);
	_tmp8_ = queue;
	_tmp9_ = sink_element;
	_tmp10_ = gst_element_link (_tmp8_, _tmp9_);
	if (!_tmp10_) {
		DVBLoggingLogger* _tmp11_;
		GstElement* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GstElement* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = dvb_player_thread_log;
		_tmp12_ = queue;
		_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = sink_element;
		_tmp16_ = gst_object_get_name ((GstObject*) _tmp15_);
		_tmp17_ = _tmp16_;
		dvb_logging_logger_error (_tmp11_, "ChannelFactory.vala:234: Could not link elements %s and %s", _tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
	}
	_tmp18_ = queue;
	_tmp19_ = gst_element_get_static_pad (_tmp18_, "sink");
	pad = _tmp19_;
	_tmp20_ = (GstGhostPad*) gst_ghost_pad_new ("sink", pad);
	gst_object_ref_sink (_tmp20_);
	ghost = _tmp20_;
	gst_pad_set_active ((GstPad*) ghost, TRUE);
	_tmp21_ = bin;
	_tmp22_ = _gst_object_ref0 ((GstPad*) ghost);
	gst_element_add_pad (_tmp21_, _tmp22_);
	_tmp23_ = bin;
	_tmp24_ = _gst_object_ref0 (_tmp23_);
	dvb_player_thread_add_element (self, _tmp24_);
	result = bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (queue);
	return result;
}


static gint dvb_player_thread_find_element (void* av, void* bv) {
	gint result = 0;
	void* _tmp0_;
	GstElement* _tmp1_;
	GstElement* a;
	void* _tmp2_;
	GstElement* _tmp3_;
	GstElement* b;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	_tmp0_ = av;
	_tmp1_ = _gst_object_ref0 (GST_ELEMENT (_tmp0_));
	a = _tmp1_;
	_tmp2_ = bv;
	_tmp3_ = _gst_object_ref0 (GST_ELEMENT (_tmp2_));
	b = _tmp3_;
	_tmp4_ = a;
	_tmp5_ = b;
	if (_tmp4_ == _tmp5_) {
		result = 0;
		_gst_object_unref0 (b);
		_gst_object_unref0 (a);
		return result;
	} else {
		result = 1;
		_gst_object_unref0 (b);
		_gst_object_unref0 (a);
		return result;
	}
	_gst_object_unref0 (b);
	_gst_object_unref0 (a);
}


/**
         * @sid: Channel SID
         * @sink: The sink element that the bin should contain
         * @returns: GstBin containing queue and sink for the specified channel
         */
static gint _dvb_player_thread_find_element_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = dvb_player_thread_find_element (a, b);
	return result;
}


GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink) {
	GstElement* result = NULL;
	GstElement* _result_;
	DVBLoggingLogger* _tmp0_;
	GstElement* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GstElement* _tmp4_;
	guint _tmp5_;
	GstElement* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = dvb_player_thread_log;
	_tmp1_ = sink;
	_tmp2_ = gst_object_get_name ((GstObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sink;
	_tmp5_ = sid;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:264: Searching for sink %s (%p) of channel %u", _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_tmp3_);
	{
		GeeHashMap* _tmp6_;
		_tmp6_ = self->priv->elements_map;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeHashMap* _tmp7_;
			guint _tmp8_;
			gpointer _tmp9_ = NULL;
			DVBPlayerThreadChannelElements* celems;
			DVBPlayerThreadChannelElements* _tmp10_;
			_tmp7_ = self->priv->elements_map;
			_tmp8_ = sid;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, GUINT_TO_POINTER (_tmp8_));
			celems = (DVBPlayerThreadChannelElements*) _tmp9_;
			_tmp10_ = celems;
			if (_tmp10_ != NULL) {
				{
					DVBPlayerThreadChannelElements* _tmp11_;
					GeeArrayList* _tmp12_;
					GeeArrayList* _tmp13_;
					GeeArrayList* _sink_bin_list;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _sink_bin_size;
					gint _sink_bin_index;
					_tmp11_ = celems;
					_tmp12_ = _tmp11_->sinks;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_sink_bin_list = _tmp13_;
					_tmp14_ = _sink_bin_list;
					_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_sink_bin_size = _tmp16_;
					_sink_bin_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						GeeArrayList* _tmp20_;
						gint _tmp21_;
						gpointer _tmp22_ = NULL;
						GstElement* sink_bin;
						GstElement* _tmp23_;
						GstIterator* _tmp24_ = NULL;
						GstIterator* it;
						GstIterator* _tmp25_;
						GstElement* _tmp26_;
						gpointer _tmp27_ = NULL;
						GstElement* element;
						GstElement* _tmp28_;
						_tmp17_ = _sink_bin_index;
						_sink_bin_index = _tmp17_ + 1;
						_tmp18_ = _sink_bin_index;
						_tmp19_ = _sink_bin_size;
						if (!(_tmp18_ < _tmp19_)) {
							break;
						}
						_tmp20_ = _sink_bin_list;
						_tmp21_ = _sink_bin_index;
						_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
						sink_bin = (GstElement*) _tmp22_;
						_tmp23_ = sink_bin;
						_tmp24_ = gst_bin_iterate_elements (GST_BIN (_tmp23_));
						it = _tmp24_;
						_tmp25_ = it;
						_tmp26_ = sink;
						_tmp27_ = gst_iterator_find_custom (_tmp25_, _dvb_player_thread_find_element_gcompare_func, _tmp26_);
						element = (GstElement*) _tmp27_;
						_tmp28_ = element;
						if (_tmp28_ != NULL) {
							GstElement* _tmp29_;
							GstElement* _tmp30_;
							_tmp29_ = sink_bin;
							_tmp30_ = _gst_object_ref0 (_tmp29_);
							_gst_object_unref0 (_result_);
							_result_ = _tmp30_;
							_gst_object_unref0 (element);
							_gst_iterator_free0 (it);
							_gst_object_unref0 (sink_bin);
							break;
						}
						_gst_object_unref0 (element);
						_gst_iterator_free0 (it);
						_gst_object_unref0 (sink_bin);
					}
					_g_object_unref0 (_sink_bin_list);
				}
			} else {
				guint _tmp31_;
				_tmp31_ = sid;
				g_warning ("ChannelFactory.vala:277: Could not find any sinks of channel %u", _tmp31_);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally17:
		{
			GeeHashMap* _tmp32_;
			_tmp32_ = self->priv->elements_map;
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp33_ = _result_;
	if (_tmp33_ == NULL) {
		DVBLoggingLogger* _tmp34_;
		_tmp34_ = dvb_player_thread_log;
		dvb_logging_logger_debug (_tmp34_, "ChannelFactory.vala:281: Found NO sink");
	} else {
		DVBLoggingLogger* _tmp35_;
		_tmp35_ = dvb_player_thread_log;
		dvb_logging_logger_debug (_tmp35_, "ChannelFactory.vala:283: Found sink");
	}
	result = _result_;
	return result;
}


/**
         * Stop watching @channel
         */
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	DVBChannel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint channel_sid;
	GeeHashSet* _tmp3_;
	DVBChannel* _tmp4_;
	gboolean _tmp5_ = FALSE;
	DVBPlayerThreadChannelElements* celements = NULL;
	gboolean stop_channel = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Sid (_tmp0_);
	_tmp2_ = _tmp1_;
	channel_sid = _tmp2_;
	_tmp3_ = self->priv->_active_channels;
	_tmp4_ = channel;
	_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	if (!_tmp5_) {
		DVBLoggingLogger* _tmp6_;
		guint _tmp7_;
		_tmp6_ = dvb_player_thread_log;
		_tmp7_ = channel_sid;
		dvb_logging_logger_error (_tmp6_, "ChannelFactory.vala:294: Could not find channel with SID %u", _tmp7_);
		result = FALSE;
		return result;
	}
	{
		GeeHashMap* _tmp8_;
		_tmp8_ = self->priv->elements_map;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeHashMap* _tmp9_;
			guint _tmp10_;
			gpointer _tmp11_ = NULL;
			DVBPlayerThreadChannelElements* _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp9_ = self->priv->elements_map;
			_tmp10_ = channel_sid;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, GUINT_TO_POINTER (_tmp10_));
			_dvb_player_thread_channel_elements_unref0 (celements);
			celements = (DVBPlayerThreadChannelElements*) _tmp11_;
			_tmp12_ = celements;
			_tmp13_ = _tmp12_->sinks;
			_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			stop_channel = _tmp15_ == 1;
		}
		__finally18:
		{
			GeeHashMap* _tmp16_;
			_tmp16_ = self->priv->elements_map;
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		GstElement* _tmp17_;
		_tmp17_ = self->priv->pipeline;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GeeHashSet* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp18_ = self->priv->_active_channels;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ > 1) {
				gboolean _tmp21_;
				guint _tmp73_;
				GstElement* _tmp74_;
				gboolean _tmp75_;
				_tmp21_ = stop_channel;
				if (_tmp21_) {
					guint _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* channel_sid_string;
					gchar* programs = NULL;
					GstElement* _tmp24_;
					const gchar* _tmp25_;
					gchar** _tmp26_;
					gchar** _tmp27_ = NULL;
					gchar** programs_arr;
					gint programs_arr_length1;
					gint _programs_arr_size_;
					GeeArrayList* _tmp28_;
					GeeArrayList* new_programs_list;
					GeeArrayList* _tmp42_;
					gpointer _tmp43_ = NULL;
					gchar* _tmp44_;
					GString* _tmp45_;
					GString* _tmp46_;
					GString* new_programs;
					DVBLoggingLogger* _tmp61_;
					const gchar* _tmp62_;
					GString* _tmp63_;
					const gchar* _tmp64_;
					GstElement* _tmp65_;
					GstElement* _tmp66_;
					GString* _tmp67_;
					const gchar* _tmp68_;
					gboolean _tmp69_ = FALSE;
					GeeHashSet* _tmp71_;
					DVBChannel* _tmp72_;
					_tmp22_ = channel_sid;
					_tmp23_ = g_strdup_printf ("%u", _tmp22_);
					channel_sid_string = _tmp23_;
					_tmp24_ = self->priv->dvbbasebin;
					g_object_get ((GObject*) _tmp24_, "program-numbers", &programs, NULL);
					_tmp25_ = programs;
					_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, ":", 0);
					programs_arr = _tmp27_;
					programs_arr_length1 = _vala_array_length (_tmp26_);
					_programs_arr_size_ = programs_arr_length1;
					_tmp28_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
					new_programs_list = _tmp28_;
					{
						gint i;
						i = 0;
						{
							gboolean _tmp29_;
							_tmp29_ = TRUE;
							while (TRUE) {
								gboolean _tmp30_;
								gint _tmp32_;
								gchar** _tmp33_;
								gint _tmp33__length1;
								gchar** _tmp34_;
								gint _tmp34__length1;
								gint _tmp35_;
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								_tmp30_ = _tmp29_;
								if (!_tmp30_) {
									gint _tmp31_;
									_tmp31_ = i;
									i = _tmp31_ + 1;
								}
								_tmp29_ = FALSE;
								_tmp32_ = i;
								_tmp33_ = programs_arr;
								_tmp33__length1 = programs_arr_length1;
								if (!(_tmp32_ < _tmp33__length1)) {
									break;
								}
								_tmp34_ = programs_arr;
								_tmp34__length1 = programs_arr_length1;
								_tmp35_ = i;
								_tmp36_ = _tmp34_[_tmp35_];
								_tmp37_ = channel_sid_string;
								if (g_strcmp0 (_tmp36_, _tmp37_) != 0) {
									GeeArrayList* _tmp38_;
									gchar** _tmp39_;
									gint _tmp39__length1;
									gint _tmp40_;
									const gchar* _tmp41_;
									_tmp38_ = new_programs_list;
									_tmp39_ = programs_arr;
									_tmp39__length1 = programs_arr_length1;
									_tmp40_ = i;
									_tmp41_ = _tmp39_[_tmp40_];
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp41_);
								}
							}
						}
					}
					_tmp42_ = new_programs_list;
					_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 0);
					_tmp44_ = (gchar*) _tmp43_;
					_tmp45_ = g_string_new (_tmp44_);
					_tmp46_ = _tmp45_;
					_g_free0 (_tmp44_);
					new_programs = _tmp46_;
					{
						gint i;
						i = 1;
						{
							gboolean _tmp47_;
							_tmp47_ = TRUE;
							while (TRUE) {
								gboolean _tmp48_;
								gint _tmp50_;
								GeeArrayList* _tmp51_;
								gint _tmp52_;
								gint _tmp53_;
								GString* _tmp54_;
								GeeArrayList* _tmp55_;
								gint _tmp56_;
								gpointer _tmp57_ = NULL;
								gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								_tmp48_ = _tmp47_;
								if (!_tmp48_) {
									gint _tmp49_;
									_tmp49_ = i;
									i = _tmp49_ + 1;
								}
								_tmp47_ = FALSE;
								_tmp50_ = i;
								_tmp51_ = new_programs_list;
								_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
								_tmp53_ = _tmp52_;
								if (!(_tmp50_ < _tmp53_)) {
									break;
								}
								_tmp54_ = new_programs;
								_tmp55_ = new_programs_list;
								_tmp56_ = i;
								_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _tmp56_);
								_tmp58_ = (gchar*) _tmp57_;
								_tmp59_ = g_strconcat (":", _tmp58_, NULL);
								_tmp60_ = _tmp59_;
								g_string_append (_tmp54_, _tmp60_);
								_g_free0 (_tmp60_);
								_g_free0 (_tmp58_);
							}
						}
					}
					_tmp61_ = dvb_player_thread_log;
					_tmp62_ = programs;
					_tmp63_ = new_programs;
					_tmp64_ = _tmp63_->str;
					dvb_logging_logger_debug (_tmp61_, "ChannelFactory.vala:333: Changing program-numbers from %s to %s", _tmp62_, _tmp64_);
					_tmp65_ = self->priv->pipeline;
					gst_element_set_state (_tmp65_, GST_STATE_PAUSED);
					_tmp66_ = self->priv->dvbbasebin;
					_tmp67_ = new_programs;
					_tmp68_ = _tmp67_->str;
					g_object_set ((GObject*) _tmp66_, "program-numbers", _tmp68_, NULL);
					_tmp69_ = dvb_player_thread_set_playing_or_destroy (self);
					if (!_tmp69_) {
						result = FALSE;
						_g_string_free0 (new_programs);
						_g_object_unref0 (new_programs_list);
						programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (programs);
						_g_free0 (channel_sid_string);
						{
							GstElement* _tmp70_;
							_tmp70_ = self->priv->pipeline;
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
					_tmp71_ = self->priv->_active_channels;
					_tmp72_ = channel;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp71_, _tmp72_);
					_g_string_free0 (new_programs);
					_g_object_unref0 (new_programs_list);
					programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (programs);
					_g_free0 (channel_sid_string);
				}
				_tmp73_ = channel_sid;
				_tmp74_ = sink;
				dvb_player_thread_remove_sink_bin (self, _tmp73_, _tmp74_);
				_tmp75_ = stop_channel;
				if (_tmp75_) {
					DVBLoggingLogger* _tmp76_;
					DVBPlayerThreadChannelElements* _tmp77_;
					GstElement* _tmp78_;
					gchar* _tmp79_ = NULL;
					gchar* _tmp80_;
					DVBPlayerThreadChannelElements* _tmp81_;
					GstElement* _tmp82_;
					GstElement* _tmp83_;
					DVBPlayerThreadChannelElements* _tmp84_;
					GstElement* _tmp85_;
					_tmp76_ = dvb_player_thread_log;
					_tmp77_ = celements;
					_tmp78_ = _tmp77_->tee;
					_tmp79_ = gst_object_get_name ((GstObject*) _tmp78_);
					_tmp80_ = _tmp79_;
					dvb_logging_logger_debug (_tmp76_, "ChannelFactory.vala:348: Removing tee %s from pipeline", _tmp80_);
					_g_free0 (_tmp80_);
					_tmp81_ = celements;
					_tmp82_ = _tmp81_->tee;
					gst_element_set_state (_tmp82_, GST_STATE_NULL);
					_tmp83_ = self->priv->pipeline;
					_tmp84_ = celements;
					_tmp85_ = _tmp84_->tee;
					gst_bin_remove (GST_BIN (_tmp83_), _tmp85_);
					{
						GeeHashMap* _tmp86_;
						_tmp86_ = self->priv->elements_map;
						g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							GeeHashMap* _tmp87_;
							guint _tmp88_;
							_tmp87_ = self->priv->elements_map;
							_tmp88_ = channel_sid;
							gee_abstract_map_unset ((GeeAbstractMap*) _tmp87_, GUINT_TO_POINTER (_tmp88_), NULL);
						}
						__finally20:
						{
							GeeHashMap* _tmp89_;
							_tmp89_ = self->priv->elements_map;
							g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (_inner_error_ != NULL) {
							{
								GstElement* _tmp90_;
								_tmp90_ = self->priv->pipeline;
								g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_dvb_player_thread_channel_elements_unref0 (celements);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			} else {
				gboolean _tmp91_;
				_tmp91_ = stop_channel;
				if (_tmp91_) {
					dvb_player_thread_destroy (self, FALSE);
				} else {
					guint _tmp92_;
					GstElement* _tmp93_;
					gboolean _tmp94_ = FALSE;
					_tmp92_ = channel_sid;
					_tmp93_ = sink;
					dvb_player_thread_remove_sink_bin (self, _tmp92_, _tmp93_);
					_tmp94_ = dvb_player_thread_set_playing_or_destroy (self);
					if (!_tmp94_) {
						result = FALSE;
						{
							GstElement* _tmp95_;
							_tmp95_ = self->priv->pipeline;
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
				}
			}
		}
		__finally19:
		{
			GstElement* _tmp96_;
			_tmp96_ = self->priv->pipeline;
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_dvb_player_thread_channel_elements_unref0 (celements);
	return result;
}


static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self) {
	gboolean result = FALSE;
	GstElement* _tmp0_;
	GstStateChangeReturn _tmp1_ = 0;
	GstStateChangeReturn ret;
	GstStateChangeReturn _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = gst_element_set_state (_tmp0_, GST_STATE_PLAYING);
	ret = _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ == GST_STATE_CHANGE_FAILURE) {
		DVBLoggingLogger* _tmp3_;
		_tmp3_ = dvb_player_thread_log;
		dvb_logging_logger_error (_tmp3_, "ChannelFactory.vala:379: Failed setting pipeline to playing");
		dvb_player_thread_destroy (self, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink) {
	DVBLoggingLogger* _tmp0_;
	GstElement* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GstElement* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_ = NULL;
	GstElement* sink_bin;
	GstElement* _tmp9_;
	DVBLoggingLogger* _tmp39_;
	GstElement* _tmp40_;
	GstElement* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink != NULL);
	_tmp0_ = dvb_player_thread_log;
	_tmp1_ = sink;
	_tmp2_ = gst_object_get_name ((GstObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sink;
	_tmp5_ = channel_sid;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:387: Removing sink bin of sink %s (%p) of channel " \
"%u", _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = channel_sid;
	_tmp7_ = sink;
	_tmp8_ = dvb_player_thread_get_sink_bin (self, _tmp6_, _tmp7_);
	sink_bin = _tmp8_;
	_tmp9_ = sink_bin;
	if (_tmp9_ == NULL) {
		DVBLoggingLogger* _tmp10_;
		guint _tmp11_;
		GstElement* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GstElement* _tmp15_;
		_tmp10_ = dvb_player_thread_log;
		_tmp11_ = channel_sid;
		_tmp12_ = sink;
		_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = sink;
		dvb_logging_logger_error (_tmp10_, "ChannelFactory.vala:393: Could not find sink bin for channel %u and si" \
"nk %s (%p)", _tmp11_, _tmp14_, _tmp15_);
		_g_free0 (_tmp14_);
		_gst_object_unref0 (sink_bin);
		return;
	}
	{
		GeeHashMap* _tmp16_;
		_tmp16_ = self->priv->elements_map;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeHashMap* _tmp17_;
			guint _tmp18_;
			gpointer _tmp19_ = NULL;
			DVBPlayerThreadChannelElements* celems;
			DVBLoggingLogger* _tmp20_;
			GstElement* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			GstElement* _tmp24_;
			DVBPlayerThreadChannelElements* _tmp25_;
			GstElement* _tmp26_;
			GstElement* _tmp27_;
			GstElement* _tmp28_;
			DVBPlayerThreadChannelElements* _tmp29_;
			GeeArrayList* _tmp30_;
			GstElement* _tmp31_;
			gboolean _tmp32_ = FALSE;
			_tmp17_ = self->priv->elements_map;
			_tmp18_ = channel_sid;
			_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, GUINT_TO_POINTER (_tmp18_));
			celems = (DVBPlayerThreadChannelElements*) _tmp19_;
			_tmp20_ = dvb_player_thread_log;
			_tmp21_ = sink;
			_tmp22_ = gst_object_get_name ((GstObject*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = sink;
			dvb_logging_logger_debug (_tmp20_, "ChannelFactory.vala:401: Setting state of queue and sink %s (%p) to NU" \
"LL", _tmp23_, _tmp24_);
			_g_free0 (_tmp23_);
			_tmp25_ = celems;
			_tmp26_ = _tmp25_->tee;
			_tmp27_ = sink_bin;
			gst_element_unlink (_tmp26_, _tmp27_);
			_tmp28_ = sink_bin;
			gst_element_set_state (_tmp28_, GST_STATE_NULL);
			_tmp29_ = celems;
			_tmp30_ = _tmp29_->sinks;
			_tmp31_ = sink_bin;
			_tmp32_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp30_, _tmp31_);
			if (!_tmp32_) {
				DVBLoggingLogger* _tmp33_;
				GstElement* _tmp34_;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				GstElement* _tmp37_;
				_tmp33_ = dvb_player_thread_log;
				_tmp34_ = sink_bin;
				_tmp35_ = gst_object_get_name ((GstObject*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = sink_bin;
				dvb_logging_logger_error (_tmp33_, "ChannelFactory.vala:407: Could not find sink bin %s (%p)", _tmp36_, _tmp37_);
				_g_free0 (_tmp36_);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally21:
		{
			GeeHashMap* _tmp38_;
			_tmp38_ = self->priv->elements_map;
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (sink_bin);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp39_ = dvb_player_thread_log;
	dvb_logging_logger_debug (_tmp39_, "ChannelFactory.vala:412: Removing queue and sink from pipeline");
	_tmp40_ = self->priv->pipeline;
	_tmp41_ = sink_bin;
	gst_bin_remove (GST_BIN (_tmp40_), _tmp41_);
	_gst_object_unref0 (sink_bin);
}


/**
         * Stop pipeline and clean up everything else
         */
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->destroyed;
	if (_tmp0_) {
		return;
	}
	{
		gboolean _tmp1_;
		_tmp1_ = self->priv->destroyed;
		g_static_rec_mutex_lock (&self->priv->__lock_destroyed);
		{
			gboolean _tmp2_;
			GeeHashSet* _tmp40_;
			self->priv->destroyed = TRUE;
			_tmp2_ = forced;
			if (_tmp2_) {
				{
					GeeHashMap* _tmp3_;
					_tmp3_ = self->priv->elements_map;
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						{
							GeeHashMap* _tmp4_;
							GeeCollection* _tmp5_;
							GeeCollection* _tmp6_;
							GeeCollection* _tmp7_;
							GeeIterator* _tmp8_ = NULL;
							GeeIterator* _tmp9_;
							GeeIterator* _celems_it;
							_tmp4_ = self->priv->elements_map;
							_tmp5_ = gee_map_get_values ((GeeMap*) _tmp4_);
							_tmp6_ = _tmp5_;
							_tmp7_ = _tmp6_;
							_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
							_tmp9_ = _tmp8_;
							_g_object_unref0 (_tmp7_);
							_celems_it = _tmp9_;
							while (TRUE) {
								GeeIterator* _tmp10_;
								gboolean _tmp11_ = FALSE;
								GeeIterator* _tmp12_;
								gpointer _tmp13_ = NULL;
								DVBPlayerThreadChannelElements* celems;
								DVBPlayerThreadChannelElements* _tmp14_;
								DVBForcedStopNotify _tmp15_;
								void* _tmp15__target;
								_tmp10_ = _celems_it;
								_tmp11_ = gee_iterator_next (_tmp10_);
								if (!_tmp11_) {
									break;
								}
								_tmp12_ = _celems_it;
								_tmp13_ = gee_iterator_get (_tmp12_);
								celems = (DVBPlayerThreadChannelElements*) _tmp13_;
								_tmp14_ = celems;
								_tmp15_ = _tmp14_->notify_func;
								_tmp15__target = _tmp14_->notify_func_target;
								if (_tmp15_ != NULL) {
									DVBDevice* _tmp16_;
									DVBChannelList* _tmp17_;
									DVBChannelList* _tmp18_;
									DVBPlayerThreadChannelElements* _tmp19_;
									guint _tmp20_;
									DVBChannel* _tmp21_ = NULL;
									DVBChannel* channel;
									DVBPlayerThreadChannelElements* _tmp22_;
									DVBForcedStopNotify _tmp23_;
									void* _tmp23__target;
									DVBChannel* _tmp24_;
									_tmp16_ = self->priv->_device;
									_tmp17_ = dvb_device_get_Channels (_tmp16_);
									_tmp18_ = _tmp17_;
									_tmp19_ = celems;
									_tmp20_ = _tmp19_->sid;
									_tmp21_ = dvb_channel_list_get_channel (_tmp18_, _tmp20_);
									channel = _tmp21_;
									_tmp22_ = celems;
									_tmp23_ = _tmp22_->notify_func;
									_tmp23__target = _tmp22_->notify_func_target;
									_tmp24_ = channel;
									_tmp23_ (_tmp24_, _tmp23__target);
									_g_object_unref0 (channel);
								}
								_dvb_player_thread_channel_elements_unref0 (celems);
							}
							_g_object_unref0 (_celems_it);
						}
					}
					__finally23:
					{
						GeeHashMap* _tmp25_;
						_tmp25_ = self->priv->elements_map;
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (_inner_error_ != NULL) {
						{
							gboolean _tmp26_;
							_tmp26_ = self->priv->destroyed;
							g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			{
				GstElement* _tmp27_;
				_tmp27_ = self->priv->pipeline;
				g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
				{
					GstElement* _tmp28_;
					_tmp28_ = self->priv->pipeline;
					if (_tmp28_ != NULL) {
						DVBLoggingLogger* _tmp29_;
						GstElement* _tmp30_;
						GstBus* _tmp31_ = NULL;
						GstBus* bus;
						GstBus* _tmp32_;
						GstElement* _tmp33_;
						_tmp29_ = dvb_player_thread_log;
						dvb_logging_logger_debug (_tmp29_, "ChannelFactory.vala:437: Stopping pipeline");
						_tmp30_ = self->priv->pipeline;
						_tmp31_ = gst_element_get_bus (_tmp30_);
						bus = _tmp31_;
						_tmp32_ = bus;
						gst_bus_remove_signal_watch (_tmp32_);
						_tmp33_ = self->priv->pipeline;
						gst_element_set_state (_tmp33_, GST_STATE_NULL);
						_gst_object_unref0 (bus);
					}
					_gst_object_unref0 (self->priv->pipeline);
					self->priv->pipeline = NULL;
				}
				__finally24:
				{
					GstElement* _tmp34_;
					_tmp34_ = self->priv->pipeline;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				if (_inner_error_ != NULL) {
					{
						gboolean _tmp35_;
						_tmp35_ = self->priv->destroyed;
						g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			{
				GeeHashMap* _tmp36_;
				_tmp36_ = self->priv->elements_map;
				g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
				{
					GeeHashMap* _tmp37_;
					_tmp37_ = self->priv->elements_map;
					gee_abstract_map_clear ((GeeAbstractMap*) _tmp37_);
				}
				__finally25:
				{
					GeeHashMap* _tmp38_;
					_tmp38_ = self->priv->elements_map;
					g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
				}
				if (_inner_error_ != NULL) {
					{
						gboolean _tmp39_;
						_tmp39_ = self->priv->destroyed;
						g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp40_ = self->priv->_active_channels;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp40_);
		}
		__finally22:
		{
			gboolean _tmp41_;
			_tmp41_ = self->priv->destroyed;
			g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced) {
	g_return_if_fail (self != NULL);
	DVB_PLAYER_THREAD_GET_CLASS (self)->destroy (self, forced);
}


static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem) {
	gboolean result = FALSE;
	GstElement* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* elem_name;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GstElement* _tmp4_;
	gboolean _tmp5_ = FALSE;
	DVBLoggingLogger* _tmp8_;
	const gchar* _tmp9_;
	GstElement* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elem != NULL, FALSE);
	_tmp0_ = elem;
	_tmp1_ = gst_object_get_name ((GstObject*) _tmp0_);
	elem_name = _tmp1_;
	_tmp2_ = self->priv->pipeline;
	_tmp3_ = elem;
	_tmp4_ = _gst_object_ref0 (_tmp3_);
	_tmp5_ = gst_bin_add (GST_BIN (_tmp2_), _tmp4_);
	if (!_tmp5_) {
		DVBLoggingLogger* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = dvb_player_thread_log;
		_tmp7_ = elem_name;
		dvb_logging_logger_error (_tmp6_, "ChannelFactory.vala:454: Could not add element %s", _tmp7_);
		result = FALSE;
		_g_free0 (elem_name);
		_gst_object_unref0 (elem);
		return result;
	}
	_tmp8_ = dvb_player_thread_log;
	_tmp9_ = elem_name;
	_tmp10_ = elem;
	dvb_logging_logger_debug (_tmp8_, "ChannelFactory.vala:457: Element %s (%p) added to pipeline", _tmp9_, _tmp10_);
	result = TRUE;
	_g_free0 (elem_name);
	_gst_object_unref0 (elem);
	return result;
}


/**
         * Link program_%d pad with tee
         */
static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad) {
	GstPad* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* pad_name;
	DVBLoggingLogger* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	guint sid = 0U;
	const gchar* _tmp6_;
	DVBLoggingLogger* _tmp7_;
	guint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0_ = pad;
	_tmp1_ = gst_object_get_name ((GstObject*) _tmp0_);
	pad_name = _tmp1_;
	_tmp2_ = dvb_player_thread_log;
	_tmp3_ = pad_name;
	dvb_logging_logger_debug (_tmp2_, "ChannelFactory.vala:466: Pad %s added", _tmp3_);
	_tmp4_ = pad_name;
	_tmp5_ = g_str_has_prefix (_tmp4_, "program_");
	if (!_tmp5_) {
		_g_free0 (pad_name);
		return;
	}
	_tmp6_ = pad_name;
	sscanf (_tmp6_, "program_%u", &sid);
	_tmp7_ = dvb_player_thread_log;
	_tmp8_ = sid;
	dvb_logging_logger_debug (_tmp7_, "ChannelFactory.vala:474: SID is '%u'", _tmp8_);
	{
		GeeHashMap* _tmp9_;
		_tmp9_ = self->priv->elements_map;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeHashMap* _tmp10_;
			guint _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp10_ = self->priv->elements_map;
			_tmp11_ = sid;
			_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, GUINT_TO_POINTER (_tmp11_));
			if (_tmp12_) {
				GeeHashMap* _tmp13_;
				guint _tmp14_;
				gpointer _tmp15_ = NULL;
				DVBPlayerThreadChannelElements* _tmp16_;
				GstElement* _tmp17_;
				GstElement* _tmp18_;
				GstElement* _tmp19_;
				GstElement* sink;
				GstElement* _tmp20_;
				DVBLoggingLogger* _tmp24_;
				GstElement* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				GstElement* _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				GstElement* _tmp31_;
				GstPad* _tmp32_ = NULL;
				GstPad* sinkpad;
				GstPad* _tmp33_;
				GstPad* _tmp34_;
				GstPadLinkReturn _tmp35_ = 0;
				GstPadLinkReturn rc;
				GstPadLinkReturn _tmp36_;
				_tmp13_ = self->priv->elements_map;
				_tmp14_ = sid;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, GUINT_TO_POINTER (_tmp14_));
				_tmp16_ = (DVBPlayerThreadChannelElements*) _tmp15_;
				_tmp17_ = _tmp16_->tee;
				_tmp18_ = _gst_object_ref0 (_tmp17_);
				_tmp19_ = _tmp18_;
				_dvb_player_thread_channel_elements_unref0 (_tmp16_);
				sink = _tmp19_;
				_tmp20_ = sink;
				if (_tmp20_ == NULL) {
					DVBLoggingLogger* _tmp21_;
					guint _tmp22_;
					_tmp21_ = dvb_player_thread_log;
					_tmp22_ = sid;
					dvb_logging_logger_error (_tmp21_, "ChannelFactory.vala:480: Could not find sink for SID %u", _tmp22_);
					_gst_object_unref0 (sink);
					{
						GeeHashMap* _tmp23_;
						_tmp23_ = self->priv->elements_map;
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					_g_free0 (pad_name);
					return;
				}
				_tmp24_ = dvb_player_thread_log;
				_tmp25_ = elem;
				_tmp26_ = gst_object_get_name ((GstObject*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = sink;
				_tmp29_ = gst_object_get_name ((GstObject*) _tmp28_);
				_tmp30_ = _tmp29_;
				dvb_logging_logger_debug (_tmp24_, "ChannelFactory.vala:484: Linking elements %s and %s", _tmp27_, _tmp30_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp27_);
				_tmp31_ = sink;
				_tmp32_ = gst_element_get_static_pad (_tmp31_, "sink");
				sinkpad = _tmp32_;
				_tmp33_ = pad;
				_tmp34_ = sinkpad;
				_tmp35_ = gst_pad_link (_tmp33_, _tmp34_);
				rc = _tmp35_;
				_tmp36_ = rc;
				if (_tmp36_ != GST_PAD_LINK_OK) {
					DVBLoggingLogger* _tmp37_;
					GstPad* _tmp38_;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_;
					GstPad* _tmp41_;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_;
					_tmp37_ = dvb_player_thread_log;
					_tmp38_ = pad;
					_tmp39_ = gst_object_get_name ((GstObject*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = sinkpad;
					_tmp42_ = gst_object_get_name ((GstObject*) _tmp41_);
					_tmp43_ = _tmp42_;
					dvb_logging_logger_error (_tmp37_, "ChannelFactory.vala:489: Could not link pads %s and %s", _tmp40_, _tmp43_);
					_g_free0 (_tmp43_);
					_g_free0 (_tmp40_);
				} else {
					DVBLoggingLogger* _tmp44_;
					GstPad* _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					GstPad* _tmp48_;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_;
					_tmp44_ = dvb_player_thread_log;
					_tmp45_ = pad;
					_tmp46_ = gst_object_get_name ((GstObject*) _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = sinkpad;
					_tmp49_ = gst_object_get_name ((GstObject*) _tmp48_);
					_tmp50_ = _tmp49_;
					dvb_logging_logger_debug (_tmp44_, "ChannelFactory.vala:492: Src pad %s linked with sink pad %s", _tmp47_, _tmp50_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp47_);
				}
				_gst_object_unref0 (sinkpad);
				_gst_object_unref0 (sink);
			}
		}
		__finally26:
		{
			GeeHashMap* _tmp51_;
			_tmp51_ = self->priv->elements_map;
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_g_free0 (pad_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (pad_name);
}


/**
         * Forward EIT structure
         */
static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_;
	const GstStructure* _tmp1_ = NULL;
	GstStructure* _tmp2_;
	GstStructure* structure;
	GstMessage* _tmp3_;
	GstMessageType _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = gst_message_get_structure (_tmp0_);
	_tmp2_ = _gst_structure_copy0 (_tmp1_);
	structure = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = _tmp3_->type;
	switch (_tmp4_) {
		case GST_MESSAGE_ELEMENT:
		{
			const GstStructure* _tmp5_;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* structure_name;
			const gchar* _tmp8_;
			_tmp5_ = structure;
			_tmp6_ = gst_structure_get_name (_tmp5_);
			_tmp7_ = g_strdup (_tmp6_);
			structure_name = _tmp7_;
			_tmp8_ = structure_name;
			if (g_strcmp0 (_tmp8_, "eit") == 0) {
				DVBEPGScanner* _tmp9_;
				const GstStructure* _tmp12_;
				_tmp9_ = self->priv->epgscanner;
				if (_tmp9_ != NULL) {
					DVBEPGScanner* _tmp10_;
					const GstStructure* _tmp11_;
					_tmp10_ = self->priv->epgscanner;
					_tmp11_ = structure;
					dvb_epg_scanner_on_eit_structure (_tmp10_, _tmp11_);
				}
				_tmp12_ = structure;
				g_signal_emit_by_name (self, "eit-structure", _tmp12_);
			}
			_g_free0 (structure_name);
			break;
		}
		case GST_MESSAGE_WARNING:
		{
			const GstStructure* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp13_ = structure;
			_tmp14_ = gst_structure_to_string (_tmp13_);
			_tmp15_ = _tmp14_;
			g_warning ("ChannelFactory.vala:514: %s", _tmp15_);
			_g_free0 (_tmp15_);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			DVBLoggingLogger* _tmp16_;
			const GstStructure* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp16_ = dvb_player_thread_log;
			_tmp17_ = structure;
			_tmp18_ = gst_structure_to_string (_tmp17_);
			_tmp19_ = _tmp18_;
			dvb_logging_logger_error (_tmp16_, "ChannelFactory.vala:517: %s", _tmp19_);
			_g_free0 (_tmp19_);
			break;
		}
		default:
		{
			break;
		}
	}
	_gst_structure_free0 (structure);
}


GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self) {
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_channels;
	result = _tmp0_;
	return result;
}


static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value) {
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_active_channels);
	self->priv->_active_channels = _tmp1_;
	g_object_notify ((GObject *) self, "active-channels");
}


DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self) {
	DVBDevice* result;
	DVBDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	DVBDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_device);
	self->priv->_device = _tmp1_;
	g_object_notify ((GObject *) self, "device");
}


gboolean dvb_player_thread_get_forced (DVBPlayerThread* self) {
	gboolean result;
	gboolean val;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	val = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->elements_map;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			{
				GeeHashMap* _tmp1_;
				GeeCollection* _tmp2_;
				GeeCollection* _tmp3_;
				GeeCollection* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _celem_it;
				_tmp1_ = self->priv->elements_map;
				_tmp2_ = gee_map_get_values ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_celem_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					DVBPlayerThreadChannelElements* celem;
					DVBPlayerThreadChannelElements* _tmp11_;
					gboolean _tmp12_;
					_tmp7_ = _celem_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _celem_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					celem = (DVBPlayerThreadChannelElements*) _tmp10_;
					_tmp11_ = celem;
					_tmp12_ = _tmp11_->forced;
					if (_tmp12_) {
						val = TRUE;
						_dvb_player_thread_channel_elements_unref0 (celem);
						break;
					}
					_dvb_player_thread_channel_elements_unref0 (celem);
				}
				_g_object_unref0 (_celem_it);
			}
		}
		__finally27:
		{
			GeeHashMap* _tmp13_;
			_tmp13_ = self->priv->elements_map;
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp14_ = val;
	result = _tmp14_;
	return result;
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBPlayerThread * self;
	GeeHashMap* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	parent_class = G_OBJECT_CLASS (dvb_player_thread_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_PLAYER_THREAD (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, (GBoxedCopyFunc) dvb_player_thread_channel_elements_ref, dvb_player_thread_channel_elements_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->elements_map);
	self->priv->elements_map = _tmp0_;
	_tmp1_ = gee_hash_set_new (DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_tmp2_ = _tmp1_;
	dvb_player_thread_set_active_channels (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	self->priv->destroyed = FALSE;
	return obj;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type) {
	DVBPlayerThreadChannelElements* self = NULL;
	self = (DVBPlayerThreadChannelElements*) g_type_create_instance (object_type);
	return self;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void) {
	return dvb_player_thread_channel_elements_construct (DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS);
}


static void dvb_player_thread_value_channel_elements_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_player_thread_value_channel_elements_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_player_thread_channel_elements_unref (value->data[0].v_pointer);
	}
}


static void dvb_player_thread_value_channel_elements_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_player_thread_value_channel_elements_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_player_thread_value_channel_elements_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBPlayerThreadChannelElements* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_player_thread_value_channel_elements_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBPlayerThreadChannelElements** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBPlayerThreadParamSpecChannelElements* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	return value->data[0].v_pointer;
}


static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_channel_elements_class_init (DVBPlayerThreadChannelElementsClass * klass) {
	dvb_player_thread_channel_elements_parent_class = g_type_class_peek_parent (klass);
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS (klass)->finalize = dvb_player_thread_channel_elements_finalize;
}


static void dvb_player_thread_channel_elements_instance_init (DVBPlayerThreadChannelElements * self) {
	self->ref_count = 1;
}


static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj) {
	DVBPlayerThreadChannelElements * self;
	self = DVB_PLAYER_THREAD_CHANNEL_ELEMENTS (obj);
	_g_object_unref0 (self->sinks);
	_gst_object_unref0 (self->tee);
}


static GType dvb_player_thread_channel_elements_get_type (void) {
	static volatile gsize dvb_player_thread_channel_elements_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_channel_elements_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_player_thread_value_channel_elements_init, dvb_player_thread_value_channel_elements_free_value, dvb_player_thread_value_channel_elements_copy_value, dvb_player_thread_value_channel_elements_peek_pointer, "p", dvb_player_thread_value_channel_elements_collect_value, "p", dvb_player_thread_value_channel_elements_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadChannelElementsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_channel_elements_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThreadChannelElements), 0, (GInstanceInitFunc) dvb_player_thread_channel_elements_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_player_thread_channel_elements_type_id;
		dvb_player_thread_channel_elements_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBPlayerThreadChannelElements", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_player_thread_channel_elements_type_id__volatile, dvb_player_thread_channel_elements_type_id);
	}
	return dvb_player_thread_channel_elements_type_id__volatile;
}


static gpointer dvb_player_thread_channel_elements_ref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void dvb_player_thread_channel_elements_unref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_player_thread_class_init (DVBPlayerThreadClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_player_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBPlayerThreadPrivate));
	DVB_PLAYER_THREAD_CLASS (klass)->destroy = dvb_player_thread_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_player_thread_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_player_thread_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_player_thread_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_player_thread_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_ACTIVE_CHANNELS, g_param_spec_object ("active-channels", "active-channels", "active-channels", GEE_TYPE_HASH_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_DEVICE, g_param_spec_object ("device", "device", "device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_FORCED, g_param_spec_boolean ("forced", "forced", "forced", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Emitted when we came across EIT table
	         */
	g_signal_new ("eit_structure", DVB_TYPE_PLAYER_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GST_TYPE_STRUCTURE);
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_player_thread_log = _tmp1_;
}


static void dvb_player_thread_instance_init (DVBPlayerThread * self) {
	self->priv = DVB_PLAYER_THREAD_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_elements_map);
	g_static_rec_mutex_init (&self->priv->__lock_destroyed);
}


static void dvb_player_thread_finalize (GObject* obj) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (obj);
	_g_object_unref0 (self->priv->_active_channels);
	_g_object_unref0 (self->priv->_device);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	g_static_rec_mutex_free (&self->priv->__lock_elements_map);
	_g_object_unref0 (self->priv->elements_map);
	_g_object_unref0 (self->priv->epgscanner);
	_gst_object_unref0 (self->priv->dvbbasebin);
	g_static_rec_mutex_free (&self->priv->__lock_destroyed);
	G_OBJECT_CLASS (dvb_player_thread_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels one physical device.
     *
     * It's possible to watch multiple channels at the same time
     * if they are all on the same transport stream.
     *
     * The class is able to reuse channels that are already watched
     * and forward EPG data to #EPGScanner.
     */
GType dvb_player_thread_get_type (void) {
	static volatile gsize dvb_player_thread_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThread), 0, (GInstanceInitFunc) dvb_player_thread_instance_init, NULL };
		GType dvb_player_thread_type_id;
		dvb_player_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBPlayerThread", &g_define_type_info, 0);
		g_once_init_leave (&dvb_player_thread_type_id__volatile, dvb_player_thread_type_id);
	}
	return dvb_player_thread_type_id__volatile;
}


static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		g_value_set_object (value, dvb_player_thread_get_active_channels (self));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		g_value_set_object (value, dvb_player_thread_get_device (self));
		break;
		case DVB_PLAYER_THREAD_FORCED:
		g_value_set_boolean (value, dvb_player_thread_get_forced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		dvb_player_thread_set_active_channels (self, g_value_get_object (value));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		dvb_player_thread_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup) {
	DVBChannelFactory * self = NULL;
	DVBDeviceGroup* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	_tmp0_ = devgroup;
	self = (DVBChannelFactory*) g_object_new (object_type, "device-group", _tmp0_, NULL);
	_tmp1_ = gee_hash_set_new (DVB_TYPE_PLAYER_THREAD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->active_players);
	self->priv->active_players = _tmp1_;
	return self;
}


DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup) {
	return dvb_channel_factory_construct (DVB_TYPE_CHANNEL_FACTORY, devgroup);
}


/**
         * Stop all currently active players
         */
void dvb_channel_factory_destroy (DVBChannelFactory* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashSet* _tmp0_;
		_tmp0_ = self->priv->active_players;
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeHashSet* _tmp8_;
			{
				GeeHashSet* _tmp1_;
				GeeIterator* _tmp2_ = NULL;
				GeeIterator* _active_player_it;
				_tmp1_ = self->priv->active_players;
				_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
				_active_player_it = _tmp2_;
				while (TRUE) {
					GeeIterator* _tmp3_;
					gboolean _tmp4_ = FALSE;
					GeeIterator* _tmp5_;
					gpointer _tmp6_ = NULL;
					DVBPlayerThread* active_player;
					DVBPlayerThread* _tmp7_;
					_tmp3_ = _active_player_it;
					_tmp4_ = gee_iterator_next (_tmp3_);
					if (!_tmp4_) {
						break;
					}
					_tmp5_ = _active_player_it;
					_tmp6_ = gee_iterator_get (_tmp5_);
					active_player = (DVBPlayerThread*) _tmp6_;
					_tmp7_ = active_player;
					dvb_player_thread_destroy (_tmp7_, FALSE);
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			_tmp8_ = self->priv->active_players;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
		}
		__finally28:
		{
			GeeHashSet* _tmp9_;
			_tmp9_ = self->priv->active_players;
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * @channel: channel to watch
         * @sink_element: The element the src pad should be linked with
         * @force: Whether to stop a player when there's currently no free device
         * @notify_func: The given function is called when watching the channel
         *   is aborted because a recording on a different transport streams is
         *   about to start
         * @returns: The #PlayerThread used to watch @channel
         *
         * Watch @channel and use @sink_element as sink element
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target) {
	DVBPlayerThread* result = NULL;
	DVBLoggingLogger* _tmp0_;
	DVBChannel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	DVBChannel* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gboolean create_new;
	DVBPlayerThread* player;
	DVBDevice* free_device;
	DVBLoggingLogger* _tmp28_;
	gboolean _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	gboolean _tmp32_;
	DVBPlayerThread* _tmp59_;
	DVBChannel* _tmp60_;
	GstElement* _tmp61_;
	GstElement* _tmp62_;
	gboolean _tmp63_;
	DVBForcedStopNotify _tmp64_;
	void* _tmp64__target;
	GstElement* _tmp65_ = NULL;
	GstElement* _tmp66_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = dvb_channel_factory_log;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = channel;
	_tmp5_ = dvb_channel_get_Sid (_tmp4_);
	_tmp6_ = _tmp5_;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:568: Watching channel %s (%u)", _tmp3_, _tmp6_);
	create_new = TRUE;
	player = NULL;
	free_device = NULL;
	{
		GeeHashSet* _tmp7_;
		_tmp7_ = self->priv->active_players;
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			{
				GeeHashSet* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _active_player_it;
				_tmp8_ = self->priv->active_players;
				_tmp9_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp8_);
				_active_player_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					gboolean _tmp11_ = FALSE;
					GeeIterator* _tmp12_;
					gpointer _tmp13_ = NULL;
					DVBPlayerThread* active_player;
					_tmp10_ = _active_player_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _active_player_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					active_player = (DVBPlayerThread*) _tmp13_;
					{
						DVBPlayerThread* _tmp14_;
						GeeHashSet* _tmp15_;
						GeeHashSet* _tmp16_;
						GeeIterator* _tmp17_ = NULL;
						GeeIterator* _other_channel_it;
						_tmp14_ = active_player;
						_tmp15_ = dvb_player_thread_get_active_channels (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp16_);
						_other_channel_it = _tmp17_;
						while (TRUE) {
							GeeIterator* _tmp18_;
							gboolean _tmp19_ = FALSE;
							GeeIterator* _tmp20_;
							gpointer _tmp21_ = NULL;
							DVBChannel* other_channel;
							DVBChannel* _tmp22_;
							DVBChannel* _tmp23_;
							gboolean _tmp24_ = FALSE;
							_tmp18_ = _other_channel_it;
							_tmp19_ = gee_iterator_next (_tmp18_);
							if (!_tmp19_) {
								break;
							}
							_tmp20_ = _other_channel_it;
							_tmp21_ = gee_iterator_get (_tmp20_);
							other_channel = (DVBChannel*) _tmp21_;
							_tmp22_ = channel;
							_tmp23_ = other_channel;
							_tmp24_ = dvb_channel_on_same_transport_stream (_tmp22_, _tmp23_);
							if (_tmp24_) {
								DVBPlayerThread* _tmp25_;
								DVBPlayerThread* _tmp26_;
								create_new = FALSE;
								_tmp25_ = active_player;
								_tmp26_ = _g_object_ref0 (_tmp25_);
								_g_object_unref0 (player);
								player = _tmp26_;
								_g_object_unref0 (other_channel);
								break;
							}
							_g_object_unref0 (other_channel);
						}
						_g_object_unref0 (_other_channel_it);
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
		}
		__finally29:
		{
			GeeHashSet* _tmp27_;
			_tmp27_ = self->priv->active_players;
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = dvb_channel_factory_log;
	_tmp29_ = create_new;
	_tmp30_ = bool_to_string (_tmp29_);
	_tmp31_ = _tmp30_;
	dvb_logging_logger_debug (_tmp28_, "ChannelFactory.vala:585: Creating new PlayerThread: %s", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = create_new;
	if (_tmp32_) {
		DVBDeviceGroup* _tmp33_;
		DVBDeviceGroup* _tmp34_;
		DVBDevice* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		DVBDevice* _tmp37_;
		gboolean _tmp39_;
		DVBDevice* _tmp55_;
		DVBDevice* _tmp57_;
		DVBPlayerThread* _tmp58_ = NULL;
		_tmp33_ = self->priv->_device_group;
		dvb_device_group_stop_epg_scanner (_tmp33_);
		_tmp34_ = self->priv->_device_group;
		_tmp35_ = dvb_device_group_get_next_free_device (_tmp34_);
		_g_object_unref0 (free_device);
		free_device = _tmp35_;
		_tmp37_ = free_device;
		if (_tmp37_ == NULL) {
			gboolean _tmp38_;
			_tmp38_ = force;
			_tmp36_ = _tmp38_;
		} else {
			_tmp36_ = FALSE;
		}
		_tmp39_ = _tmp36_;
		if (_tmp39_) {
			DVBDeviceGroup* _tmp53_;
			DVBDevice* _tmp54_ = NULL;
			{
				GeeHashSet* _tmp40_;
				_tmp40_ = self->priv->active_players;
				g_static_rec_mutex_lock (&self->priv->__lock_active_players);
				{
					{
						GeeHashSet* _tmp41_;
						GeeIterator* _tmp42_ = NULL;
						GeeIterator* _active_player_it;
						_tmp41_ = self->priv->active_players;
						_tmp42_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp41_);
						_active_player_it = _tmp42_;
						while (TRUE) {
							GeeIterator* _tmp43_;
							gboolean _tmp44_ = FALSE;
							GeeIterator* _tmp45_;
							gpointer _tmp46_ = NULL;
							DVBPlayerThread* active_player;
							DVBPlayerThread* _tmp47_;
							gboolean _tmp48_;
							gboolean _tmp49_;
							_tmp43_ = _active_player_it;
							_tmp44_ = gee_iterator_next (_tmp43_);
							if (!_tmp44_) {
								break;
							}
							_tmp45_ = _active_player_it;
							_tmp46_ = gee_iterator_get (_tmp45_);
							active_player = (DVBPlayerThread*) _tmp46_;
							_tmp47_ = active_player;
							_tmp48_ = dvb_player_thread_get_forced (_tmp47_);
							_tmp49_ = _tmp48_;
							if (!_tmp49_) {
								DVBPlayerThread* _tmp50_;
								_tmp50_ = active_player;
								dvb_player_thread_destroy (_tmp50_, TRUE);
								_g_object_unref0 (active_player);
								break;
							} else {
								DVBLoggingLogger* _tmp51_;
								_tmp51_ = dvb_channel_factory_log;
								dvb_logging_logger_error (_tmp51_, "ChannelFactory.vala:599: No active players that are not forced");
							}
							_g_object_unref0 (active_player);
						}
						_g_object_unref0 (_active_player_it);
					}
				}
				__finally30:
				{
					GeeHashSet* _tmp52_;
					_tmp52_ = self->priv->active_players;
					g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
				}
				if (_inner_error_ != NULL) {
					_g_object_unref0 (free_device);
					_g_object_unref0 (player);
					_gst_object_unref0 (sink_element);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp53_ = self->priv->_device_group;
			_tmp54_ = dvb_device_group_get_next_free_device (_tmp53_);
			_g_object_unref0 (free_device);
			free_device = _tmp54_;
		}
		_tmp55_ = free_device;
		if (_tmp55_ == NULL) {
			DVBLoggingLogger* _tmp56_;
			_tmp56_ = dvb_channel_factory_log;
			dvb_logging_logger_info (_tmp56_, "ChannelFactory.vala:606: All devices are busy");
			result = NULL;
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			return result;
		}
		_tmp57_ = free_device;
		_tmp58_ = dvb_channel_factory_create_player (self, _tmp57_);
		_g_object_unref0 (player);
		player = _tmp58_;
	}
	_tmp59_ = player;
	_tmp60_ = channel;
	_tmp61_ = sink_element;
	_tmp62_ = _gst_object_ref0 (_tmp61_);
	_tmp63_ = force;
	_tmp64_ = notify_func;
	_tmp64__target = notify_func_target;
	_tmp65_ = dvb_player_thread_get_element (_tmp59_, _tmp60_, _tmp62_, _tmp63_, _tmp64_, _tmp64__target);
	_tmp66_ = _tmp65_;
	_gst_object_unref0 (_tmp66_);
	{
		GeeHashSet* _tmp67_;
		_tmp67_ = self->priv->active_players;
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeHashSet* _tmp68_;
			DVBPlayerThread* _tmp69_;
			_tmp68_ = self->priv->active_players;
			_tmp69_ = player;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
		}
		__finally31:
		{
			GeeHashSet* _tmp70_;
			_tmp70_ = self->priv->active_players;
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = player;
	_g_object_unref0 (free_device);
	_gst_object_unref0 (sink_element);
	return result;
}


/**
         * @returns: TRUE on success
         *
         * Stop watching @channel
         */
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_;
	DVBChannel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	DVBChannel* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gboolean success;
	DVBPlayerThread* player;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = dvb_channel_factory_log;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = channel;
	_tmp5_ = dvb_channel_get_Sid (_tmp4_);
	_tmp6_ = _tmp5_;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:627: Stopping channel %s (%u)", _tmp3_, _tmp6_);
	success = FALSE;
	player = NULL;
	{
		GeeHashSet* _tmp7_;
		_tmp7_ = self->priv->active_players;
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_;
			gboolean _tmp32_;
			GeeHashSet* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			{
				GeeHashSet* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _active_player_it;
				_tmp8_ = self->priv->active_players;
				_tmp9_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp8_);
				_active_player_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					gboolean _tmp11_ = FALSE;
					GeeIterator* _tmp12_;
					gpointer _tmp13_ = NULL;
					DVBPlayerThread* active_player;
					DVBPlayerThread* _tmp14_;
					GeeHashSet* _tmp15_;
					GeeHashSet* _tmp16_;
					DVBChannel* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp10_ = _active_player_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _active_player_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					active_player = (DVBPlayerThread*) _tmp13_;
					_tmp14_ = active_player;
					_tmp15_ = dvb_player_thread_get_active_channels (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = channel;
					_tmp18_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					if (_tmp18_) {
						DVBPlayerThread* _tmp19_;
						DVBChannel* _tmp20_;
						GstElement* _tmp21_;
						gboolean _tmp22_ = FALSE;
						DVBPlayerThread* _tmp23_;
						DVBPlayerThread* _tmp24_;
						_tmp19_ = active_player;
						_tmp20_ = channel;
						_tmp21_ = sink;
						_tmp22_ = dvb_player_thread_remove_channel (_tmp19_, _tmp20_, _tmp21_);
						success = _tmp22_;
						_tmp23_ = active_player;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (player);
						player = _tmp24_;
						_g_object_unref0 (active_player);
						break;
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			_tmp26_ = success;
			if (_tmp26_) {
				DVBPlayerThread* _tmp27_;
				GeeHashSet* _tmp28_;
				GeeHashSet* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp27_ = player;
				_tmp28_ = dvb_player_thread_get_active_channels (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp25_ = _tmp31_ == 0;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp32_ = _tmp25_;
			if (_tmp32_) {
				GeeHashSet* _tmp33_;
				DVBPlayerThread* _tmp34_;
				_tmp33_ = self->priv->active_players;
				_tmp34_ = player;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp34_);
			}
			_tmp35_ = self->priv->active_players;
			_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ == 0) {
				DVBDeviceGroup* _tmp38_;
				_tmp38_ = self->priv->_device_group;
				dvb_device_group_start_epg_scanner (_tmp38_);
			}
		}
		__finally32:
		{
			GeeHashSet* _tmp39_;
			_tmp39_ = self->priv->active_players;
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (player);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (player);
	return result;
}


/**
         * @returns: a new #PlayerThread instance for @device
         */
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device) {
	DVBPlayerThread* result = NULL;
	DVBDevice* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	DVBEPGScanner* _tmp2_;
	DVBEPGScanner* _tmp3_;
	DVBPlayerThread* _tmp4_;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = self->priv->_device_group;
	_tmp2_ = dvb_device_group_get_epgscanner (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = dvb_player_thread_new (_tmp0_, _tmp3_);
	result = _tmp4_;
	return result;
}


DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_CHANNEL_FACTORY_GET_CLASS (self)->create_player (self, device);
}


DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device_group;
	result = _tmp0_;
	return result;
}


static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_device_group = _tmp0_;
	g_object_notify ((GObject *) self, "device-group");
}


static void dvb_channel_factory_class_init (DVBChannelFactoryClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_channel_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelFactoryPrivate));
	DVB_CHANNEL_FACTORY_CLASS (klass)->create_player = dvb_channel_factory_real_create_player;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FACTORY_DEVICE_GROUP, g_param_spec_object ("device-group", "device-group", "device-group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_channel_factory_log = _tmp1_;
}


static void dvb_channel_factory_instance_init (DVBChannelFactory * self) {
	self->priv = DVB_CHANNEL_FACTORY_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_active_players);
}


static void dvb_channel_factory_finalize (GObject* obj) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (obj);
	g_static_rec_mutex_free (&self->priv->__lock_active_players);
	_g_object_unref0 (self->priv->active_players);
	G_OBJECT_CLASS (dvb_channel_factory_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels for a single #DeviceGroup
     */
GType dvb_channel_factory_get_type (void) {
	static volatile gsize dvb_channel_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelFactory), 0, (GInstanceInitFunc) dvb_channel_factory_instance_init, NULL };
		GType dvb_channel_factory_type_id;
		dvb_channel_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_channel_factory_type_id__volatile, dvb_channel_factory_type_id);
	}
	return dvb_channel_factory_type_id__volatile;
}


static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		g_value_set_object (value, dvb_channel_factory_get_device_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		dvb_channel_factory_set_device_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



