/* Utils.c generated by valac 0.12.0, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>


#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))


extern DVBLoggingLogger* main_log;

#define DVB_UTILS_NAME_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME
#define DVB_UTILS_READ_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue);
const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
time_t dvb_utils_t_max (time_t a, time_t b);
time_t dvb_utils_t_min (time_t a, time_t b);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);
void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
static void _lambda0_ (void);
static void __lambda0__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _lambda1_ (void);
static void __lambda1__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error);


inline const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* eclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	_tmp0_ = g_type_class_ref (enumtype);
	eclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value (eclass, val);
	eval = _tmp1_;
	if (eval == NULL) {
		dvb_logging_logger_error (main_log, "Utils.vala:32: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (eclass);
		return result;
	} else {
		result = (*eval).value_nick;
		_g_type_class_unref0 (eclass);
		return result;
	}
	_g_type_class_unref0 (eclass);
}


inline gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue) {
	gint _evalue = 0;
	gboolean result = FALSE;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* enumclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_type_class_ref (enumtype);
	enumclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value_by_name (enumclass, name);
	eval = _tmp1_;
	if (eval == NULL) {
		dvb_logging_logger_error (main_log, "Utils.vala:44: Enum has no member named %s", name);
		result = FALSE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _evalue;
		}
		return result;
	} else {
		_evalue = (*eval).value;
		result = TRUE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _evalue;
		}
		return result;
	}
	_g_type_class_unref0 (enumclass);
	if (evalue) {
		*evalue = _evalue;
	}
}


inline const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GTypeClass* _tmp0_ = NULL;
	GEnumClass* enumclass;
	GEnumValue* _tmp1_ = NULL;
	GEnumValue* eval;
	_tmp0_ = g_type_class_ref (enumtype);
	enumclass = (GEnumClass*) _tmp0_;
	_tmp1_ = g_enum_get_value (enumclass, val);
	eval = _tmp1_;
	if (eval == NULL) {
		dvb_logging_logger_error (main_log, "Utils.vala:57: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		result = (*eval).value_name;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GSList* create_dirs;
	GFile* _tmp0_;
	GFile* current_dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (directory != NULL);
	create_dirs = NULL;
	_tmp0_ = _g_object_ref0 (directory);
	current_dir = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_ = NULL;
		if (!(current_dir != NULL)) {
			break;
		}
		_tmp1_ = g_file_query_exists (current_dir, NULL);
		if (_tmp1_) {
			break;
		}
		_tmp2_ = _g_object_ref0 (current_dir);
		create_dirs = g_slist_prepend (create_dirs, _tmp2_);
		_tmp3_ = g_file_get_parent (current_dir);
		_g_object_unref0 (current_dir);
		current_dir = _tmp3_;
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* _tmp4_;
			GFile* dir;
			_tmp4_ = _g_object_ref0 ((GFile*) dir_it->data);
			dir = _tmp4_;
			{
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = g_file_get_path (dir);
				_tmp6_ = _tmp5_;
				dvb_logging_logger_debug (main_log, "Utils.vala:75: Creating %s", _tmp6_);
				_g_free0 (_tmp6_);
				g_file_make_directory (dir, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dir);
					_g_object_unref0 (current_dir);
					__g_slist_free__g_object_unref0_0 (create_dirs);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
	_g_object_unref0 (current_dir);
	__g_slist_free__g_object_unref0_0 (create_dirs);
}


gchar* dvb_utils_remove_nonalphanums (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	gchar* new_text = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_regex_new ("[^-_\\.a-zA-Z0-9]", 0, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch193_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (regex);
	regex = _tmp1_;
	goto __finally193;
	__catch193_g_regex_error:
	{
		GError * e;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (main_log, "Utils.vala:85: RegexError: %s", e->message);
		_tmp2_ = g_strdup (text);
		result = _tmp2_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally193:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "_", 0, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch194_g_regex_error;
		}
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (new_text);
	new_text = _tmp4_;
	goto __finally194;
	__catch194_g_regex_error:
	{
		GError * e;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (main_log, "Utils.vala:93: RegexError: %s", e->message);
		_tmp5_ = g_strdup (text);
		result = _tmp5_;
		_g_error_free0 (e);
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally194:
	if (_inner_error_ != NULL) {
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_text;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * @returns: Difference in seconds
     */
inline time_t dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	time_t result = 0;
	time_t _tmp0_;
	time_t ts1;
	time_t _tmp1_;
	time_t ts2;
	time_t diff;
	_tmp0_ = mktime (t1);
	ts1 = _tmp0_;
	_tmp1_ = mktime (t2);
	ts2 = _tmp1_;
	diff = ts1 - ts2;
	if (diff < 0) {
		result = (-1) * diff;
		return result;
	} else {
		result = diff;
		return result;
	}
}


/**
     * Creates Time of local time
     */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	time_t _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm _tmp7_ = {0};
	struct tm t;
	if (year >= 1900) {
		_tmp4_ = month >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = day >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = hour >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = minute >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = second >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_tmp5_ = time (NULL);
	g_time_local (_tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	t = _tmp7_;
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	*result = t;
	return;
}


/**
     * Creates Time of UTC time
     */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	time_t _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm _tmp7_ = {0};
	struct tm t;
	if (year >= 1900) {
		_tmp4_ = month >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = day >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = hour >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = minute >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = second >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_tmp5_ = time (NULL);
	g_time_gm (_tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	t = _tmp7_;
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	*result = t;
	return;
}


gboolean dvb_utils_is_readable_file (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_;
	GFileType _tmp2_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_query_info (file, DVB_UTILS_READ_ATTRS, 0, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch195_g_error;
	}
	_g_object_unref0 (info);
	info = _tmp1_;
	goto __finally195;
	__catch195_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (main_log, "Utils.vala:162: Could not retrieve attributes: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally195:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = g_file_info_get_file_type (info);
	if (_tmp2_ != G_FILE_TYPE_REGULAR) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		dvb_logging_logger_error (main_log, "Utils.vala:167: %s is not a regular file", _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp5_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_file_get_path (file);
		_tmp7_ = _tmp6_;
		dvb_logging_logger_error (main_log, "Utils.vala:172: Cannot read %s", _tmp7_);
		_g_free0 (_tmp7_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GFileEnumerator* files = NULL;
	GFileEnumerator* _tmp0_ = NULL;
	GFileEnumerator* _tmp1_;
	GFileInfo* childinfo = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	_tmp0_ = g_file_enumerate_children (dir, DVB_UTILS_NAME_ATTRS, 0, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (files);
		return;
	}
	_g_object_unref0 (files);
	files = _tmp1_;
	if (files == NULL) {
		_g_object_unref0 (files);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_;
		guint32 _tmp4_;
		guint32 type;
		const gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* child;
		_tmp2_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (childinfo);
			_g_object_unref0 (files);
			return;
		}
		_g_object_unref0 (childinfo);
		childinfo = _tmp3_;
		if (!(childinfo != NULL)) {
			break;
		}
		_tmp4_ = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		type = _tmp4_;
		_tmp5_ = g_file_info_get_name (childinfo);
		_tmp6_ = g_file_get_child (dir, _tmp5_);
		child = _tmp6_;
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_utils_delete_dir_recursively (child, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp7_ = g_file_get_path (child);
				_tmp8_ = _tmp7_;
				dvb_logging_logger_debug (main_log, "Utils.vala:197: Deleting file %s", _tmp8_);
				_g_free0 (_tmp8_);
				g_file_delete (child, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			default:
			break;
		}
		_g_object_unref0 (child);
	}
	_tmp9_ = g_file_get_path (dir);
	_tmp10_ = _tmp9_;
	dvb_logging_logger_debug (main_log, "Utils.vala:203: Deleting directory %s", _tmp10_);
	_g_free0 (_tmp10_);
	g_file_delete (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (childinfo);
		_g_object_unref0 (files);
		return;
	}
	_g_object_unref0 (childinfo);
	_g_object_unref0 (files);
}


time_t dvb_utils_t_max (time_t a, time_t b) {
	time_t result = 0;
	time_t _tmp0_ = 0;
	if (a < b) {
		_tmp0_ = b;
	} else {
		_tmp0_ = a;
	}
	result = _tmp0_;
	return result;
}


time_t dvb_utils_t_min (time_t a, time_t b) {
	time_t result = 0;
	time_t _tmp0_ = 0;
	if (a < b) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	result = _tmp0_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched) {
	glong _unmatched = 0L;
	glong result = 0L;
	gint _tmp0_;
	glong len_a;
	gint _tmp1_;
	glong len_b;
	glong max = 0L;
	glong diff;
	g_return_val_if_fail (a != NULL, 0L);
	g_return_val_if_fail (b != NULL, 0L);
	_tmp0_ = strlen (a);
	len_a = (glong) _tmp0_;
	_tmp1_ = strlen (b);
	len_b = (glong) _tmp1_;
	if (len_a < len_b) {
		max = len_b;
		_unmatched = len_b - len_a;
	} else {
		max = len_a;
		_unmatched = len_a - len_b;
	}
	diff = (glong) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp3_;
				gchar _tmp4_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < max)) {
					break;
				}
				_tmp3_ = string_get (a, (glong) i);
				_tmp4_ = string_get (b, (glong) i);
				if (_tmp3_ != _tmp4_) {
					diff++;
				}
			}
		}
	}
	result = diff;
	if (unmatched) {
		*unmatched = _unmatched;
	}
	return result;
}


static void _lambda0_ (void) {
}


static void __lambda0__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda0_ ();
}


static void _lambda1_ (void) {
	g_warning ("Utils.vala:243: Could not acquire name");
}


static void __lambda1__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda1_ ();
}


void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target) {
	GBusAcquiredCallback _tmp0_;
	g_return_if_fail (service_name != NULL);
	dvb_logging_logger_info (main_log, "Utils.vala:239: Creating D-Bus service %s", service_name);
	_tmp0_ = cb;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, service_name, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_tmp0_ == NULL) ? NULL : g_cclosure_new ((GCallback) _tmp0_, cb_target, NULL)), (GClosure*) ((__lambda0__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda0__gbus_name_acquired_callback, NULL, NULL)), (GClosure*) ((__lambda1__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda1__gbus_name_lost_callback, NULL, NULL)));
}


static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error) {
	void *func;
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
	if (!func) {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
		return 0;
	}
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
}


inline void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (object_path != NULL);
	_vala_g_dbus_connection_register_object (t_type, obj, conn, object_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch196_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally196;
	__catch196_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (main_log, "Utils.vala:250: Could not register object '%s': %s", object_path, e->message);
		_g_error_free0 (e);
	}
	__finally196:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}



